<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_UnidadMast.xml */
/* Generado: 2022-04-18 21:15:01 */

/* Busqueda de registros de la tabla MST_UnidadMast. */
abstract class BaseMST_UnidadMastFN extends MST_UnidadMastBN
{
    /* Declaracion de constantes */
    const IdUnidad = "MST_UnidadMast.IdUnidad";
    const DescripcionCorta = "MST_UnidadMast.DescripcionCorta";
    const DescripcionExtranjera = "MST_UnidadMast.DescripcionExtranjera";
    const CodigoSunat = "MST_UnidadMast.CodigoSunat";
    const UnidadTipo = "MST_UnidadMast.UnidadTipo";
    const NumeroDecimales = "MST_UnidadMast.NumeroDecimales";
    const UnidadEquivalenteFlag = "MST_UnidadMast.UnidadEquivalenteFlag";
    const UsoFraccionFlag = "MST_UnidadMast.UsoFraccionFlag";
    const EsUnidadMinimaFlag = "MST_UnidadMast.EsUnidadMinimaFlag";
    const Estado = "MST_UnidadMast.Estado";
    const FechaModificacion = "MST_UnidadMast.FechaModificacion";
    const UsuarioModificacion = "MST_UnidadMast.UsuarioModificacion";
    const FechaCreacion = "MST_UnidadMast.FechaCreacion";
    const UsuarioCreacion = "MST_UnidadMast.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_UnidadMast.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "MST_UnidadMast.DescripcionCorta AS DescripcionCorta, ";
        $s_SQLQuery .= "MST_UnidadMast.DescripcionExtranjera AS DescripcionExtranjera, ";
        $s_SQLQuery .= "MST_UnidadMast.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "MST_UnidadMast.UnidadTipo AS UnidadTipo, ";
        $s_SQLQuery .= "MST_UnidadMast.NumeroDecimales AS NumeroDecimales, ";
        $s_SQLQuery .= "MST_UnidadMast.UnidadEquivalenteFlag AS UnidadEquivalenteFlag, ";
        $s_SQLQuery .= "MST_UnidadMast.UsoFraccionFlag AS UsoFraccionFlag, ";
        $s_SQLQuery .= "MST_UnidadMast.EsUnidadMinimaFlag AS EsUnidadMinimaFlag, ";
        $s_SQLQuery .= "MST_UnidadMast.Estado AS Estado, ";
        $s_SQLQuery .= "MST_UnidadMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_UnidadMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_UnidadMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_UnidadMast.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_UnidadMastBN */
    public function setByBN( MST_UnidadMastBN $o_MST_UnidadMastBN )
    {
        if ( !is_null( $o_MST_UnidadMastBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_MST_UnidadMastBN->getIdUnidad() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getDescripcionCorta() ) )
        {
            $this->setDescripcionCorta( $o_MST_UnidadMastBN->getDescripcionCorta() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getDescripcionExtranjera() ) )
        {
            $this->setDescripcionExtranjera( $o_MST_UnidadMastBN->getDescripcionExtranjera() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_MST_UnidadMastBN->getCodigoSunat() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getUnidadTipo() ) )
        {
            $this->setUnidadTipo( $o_MST_UnidadMastBN->getUnidadTipo() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getNumeroDecimales() ) )
        {
            $this->setNumeroDecimales( $o_MST_UnidadMastBN->getNumeroDecimales() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getUnidadEquivalenteFlag() ) )
        {
            $this->setUnidadEquivalenteFlag( $o_MST_UnidadMastBN->getUnidadEquivalenteFlag() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getUsoFraccionFlag() ) )
        {
            $this->setUsoFraccionFlag( $o_MST_UnidadMastBN->getUsoFraccionFlag() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getEsUnidadMinimaFlag() ) )
        {
            $this->setEsUnidadMinimaFlag( $o_MST_UnidadMastBN->getEsUnidadMinimaFlag() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_UnidadMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_UnidadMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_UnidadMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_UnidadMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_UnidadMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_UnidadMastBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return MST_UnidadMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdUnidad )
    {
        if( is_null( $s_IdUnidad ) ){ $s_IdUnidad = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_UnidadMast ";
        $s_SQLQuery .= "WHERE IdUnidad = '".$s_IdUnidad."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_UnidadMastBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_UnidadMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_UnidadMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "MST_UnidadMast.IdUnidad = '".$this->getIdUnidad()."' AND ";
        if ( !is_null( $this->getDescripcionCorta() ) ) $s_SQLQuery .= "MST_UnidadMast.DescripcionCorta = '".$this->getDescripcionCorta()."' AND ";
        if ( !is_null( $this->getDescripcionExtranjera() ) ) $s_SQLQuery .= "MST_UnidadMast.DescripcionExtranjera = '".$this->getDescripcionExtranjera()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "MST_UnidadMast.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getUnidadTipo() ) ) $s_SQLQuery .= "MST_UnidadMast.UnidadTipo = '".$this->getUnidadTipo()."' AND ";
        if ( !is_null( $this->getNumeroDecimales() ) ) $s_SQLQuery .= "MST_UnidadMast.NumeroDecimales = ".$this->getNumeroDecimales()." AND ";
        if ( !is_null( $this->getUnidadEquivalenteFlag() ) ) $s_SQLQuery .= "MST_UnidadMast.UnidadEquivalenteFlag = ".$this->getUnidadEquivalenteFlag()." AND ";
        if ( !is_null( $this->getUsoFraccionFlag() ) ) $s_SQLQuery .= "MST_UnidadMast.UsoFraccionFlag = ".$this->getUsoFraccionFlag()." AND ";
        if ( !is_null( $this->getEsUnidadMinimaFlag() ) ) $s_SQLQuery .= "MST_UnidadMast.EsUnidadMinimaFlag = ".$this->getEsUnidadMinimaFlag()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_UnidadMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_UnidadMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_UnidadMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_UnidadMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_UnidadMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_UnidadMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_UnidadMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_UnidadMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_UnidadMastBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_UnidadMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_UnidadMastBN[] = $o_MST_UnidadMastBN;
            }
        }
        return $a_MST_UnidadMastBN;
    }

    /* Devuelve un objeto MST_UnidadMastBN desde un objeto propel */
    public function insertObjectBN( $a_MST_UnidadMast )
    {
        $o_MST_UnidadMastBN = new MST_UnidadMastBN();
        if ( !is_null( $a_MST_UnidadMast['IdUnidad'] ) ) $o_MST_UnidadMastBN->setIdUnidad( $a_MST_UnidadMast['IdUnidad'] );
        if ( !is_null( $a_MST_UnidadMast['DescripcionCorta'] ) ) $o_MST_UnidadMastBN->setDescripcionCorta( $a_MST_UnidadMast['DescripcionCorta'] );
        if ( !is_null( $a_MST_UnidadMast['DescripcionExtranjera'] ) ) $o_MST_UnidadMastBN->setDescripcionExtranjera( $a_MST_UnidadMast['DescripcionExtranjera'] );
        if ( !is_null( $a_MST_UnidadMast['CodigoSunat'] ) ) $o_MST_UnidadMastBN->setCodigoSunat( $a_MST_UnidadMast['CodigoSunat'] );
        if ( !is_null( $a_MST_UnidadMast['UnidadTipo'] ) ) $o_MST_UnidadMastBN->setUnidadTipo( $a_MST_UnidadMast['UnidadTipo'] );
        if ( !is_null( $a_MST_UnidadMast['NumeroDecimales'] ) ) $o_MST_UnidadMastBN->setNumeroDecimales( ( integer ) $a_MST_UnidadMast['NumeroDecimales'] );
        if ( !is_null( $a_MST_UnidadMast['UnidadEquivalenteFlag'] ) ) $o_MST_UnidadMastBN->setUnidadEquivalenteFlag( ( integer ) $a_MST_UnidadMast['UnidadEquivalenteFlag'] );
        if ( !is_null( $a_MST_UnidadMast['UsoFraccionFlag'] ) ) $o_MST_UnidadMastBN->setUsoFraccionFlag( ( integer ) $a_MST_UnidadMast['UsoFraccionFlag'] );
        if ( !is_null( $a_MST_UnidadMast['EsUnidadMinimaFlag'] ) ) $o_MST_UnidadMastBN->setEsUnidadMinimaFlag( ( integer ) $a_MST_UnidadMast['EsUnidadMinimaFlag'] );
        if ( !is_null( $a_MST_UnidadMast['Estado'] ) ) $o_MST_UnidadMastBN->setEstado( $a_MST_UnidadMast['Estado'] );
        if ( !is_null( $a_MST_UnidadMast['FechaModificacion'] ) ) $o_MST_UnidadMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_UnidadMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_UnidadMast['UsuarioModificacion'] ) ) $o_MST_UnidadMastBN->setUsuarioModificacion( $a_MST_UnidadMast['UsuarioModificacion'] );
        if ( !is_null( $a_MST_UnidadMast['FechaCreacion'] ) ) $o_MST_UnidadMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_UnidadMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_UnidadMast['UsuarioCreacion'] ) ) $o_MST_UnidadMastBN->setUsuarioCreacion( $a_MST_UnidadMast['UsuarioCreacion'] );
        return $o_MST_UnidadMastBN;
    }
}
?>