<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoNegocio.xml */
/* Generado: 2022-04-18 21:15:00 */

/* Busqueda de registros de la tabla MST_TipoNegocio. */
abstract class BaseMST_TipoNegocioFN extends MST_TipoNegocioBN
{
    /* Declaracion de constantes */
    const TipoNegocioId = "MST_TipoNegocio.TipoNegocioId";
    const Descripcion = "MST_TipoNegocio.Descripcion";
    const Codigo = "MST_TipoNegocio.Codigo";
    const Estado = "MST_TipoNegocio.Estado";
    const UsuarioModificacion = "MST_TipoNegocio.UsuarioModificacion";
    const FechaModificacion = "MST_TipoNegocio.FechaModificacion";
    const UsuarioCreacion = "MST_TipoNegocio.UsuarioCreacion";
    const FechaCreacion = "MST_TipoNegocio.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TipoNegocio.TipoNegocioId AS TipoNegocioId, ";
        $s_SQLQuery .= "MST_TipoNegocio.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_TipoNegocio.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_TipoNegocio.Estado AS Estado, ";
        $s_SQLQuery .= "MST_TipoNegocio.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_TipoNegocio.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_TipoNegocio.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_TipoNegocio.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TipoNegocioBN */
    public function setByBN( MST_TipoNegocioBN $o_MST_TipoNegocioBN )
    {
        if ( !is_null( $o_MST_TipoNegocioBN->getTipoNegocioId() ) )
        {
            $this->setTipoNegocioId( $o_MST_TipoNegocioBN->getTipoNegocioId() );
        }
        if ( !is_null( $o_MST_TipoNegocioBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoNegocioBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TipoNegocioBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_TipoNegocioBN->getCodigo() );
        }
        if ( !is_null( $o_MST_TipoNegocioBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TipoNegocioBN->getEstado() );
        }
        if ( !is_null( $o_MST_TipoNegocioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TipoNegocioBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_TipoNegocioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TipoNegocioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TipoNegocioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TipoNegocioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TipoNegocioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TipoNegocioBN->getFechaCreacion() );
        }
    }

    /**
    * @return MST_TipoNegocioBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_TipoNegocioId )
    {
        if( is_null( $i_TipoNegocioId ) ){ $i_TipoNegocioId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoNegocio ";
        $s_SQLQuery .= "WHERE TipoNegocioId = ".$i_TipoNegocioId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_TipoNegocioBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TipoNegocioBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TipoNegocioBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getTipoNegocioId() ) ) $s_SQLQuery .= "MST_TipoNegocio.TipoNegocioId = ".$this->getTipoNegocioId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_TipoNegocio.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_TipoNegocio.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_TipoNegocio.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_TipoNegocio.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_TipoNegocio.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_TipoNegocio.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_TipoNegocio.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TipoNegocio WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TipoNegocioBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoNegocio WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_TipoNegocioBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TipoNegocioBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TipoNegocioBN[] = $o_MST_TipoNegocioBN;
            }
        }
        return $a_MST_TipoNegocioBN;
    }

    /* Devuelve un objeto MST_TipoNegocioBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TipoNegocio )
    {
        $o_MST_TipoNegocioBN = new MST_TipoNegocioBN();
        if ( !is_null( $a_MST_TipoNegocio['TipoNegocioId'] ) ) $o_MST_TipoNegocioBN->setTipoNegocioId( ( integer ) $a_MST_TipoNegocio['TipoNegocioId'] );
        if ( !is_null( $a_MST_TipoNegocio['Descripcion'] ) ) $o_MST_TipoNegocioBN->setDescripcion( $a_MST_TipoNegocio['Descripcion'] );
        if ( !is_null( $a_MST_TipoNegocio['Codigo'] ) ) $o_MST_TipoNegocioBN->setCodigo( $a_MST_TipoNegocio['Codigo'] );
        if ( !is_null( $a_MST_TipoNegocio['Estado'] ) ) $o_MST_TipoNegocioBN->setEstado( $a_MST_TipoNegocio['Estado'] );
        if ( !is_null( $a_MST_TipoNegocio['UsuarioModificacion'] ) ) $o_MST_TipoNegocioBN->setUsuarioModificacion( $a_MST_TipoNegocio['UsuarioModificacion'] );
        if ( !is_null( $a_MST_TipoNegocio['FechaModificacion'] ) ) $o_MST_TipoNegocioBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_TipoNegocio['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TipoNegocio['UsuarioCreacion'] ) ) $o_MST_TipoNegocioBN->setUsuarioCreacion( $a_MST_TipoNegocio['UsuarioCreacion'] );
        if ( !is_null( $a_MST_TipoNegocio['FechaCreacion'] ) ) $o_MST_TipoNegocioBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_TipoNegocio['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_MST_TipoNegocioBN;
    }
}
?>