<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TiempoCabecera.xml */
/* Generado: 2022-04-18 21:15:00 */

/* Busqueda de registros de la tabla MST_TiempoCabecera. */
abstract class BaseMST_TiempoCabeceraFN extends MST_TiempoCabeceraBN
{
    /* Declaracion de constantes */
    const IdTiempoCab = "MST_TiempoCabecera.IdTiempoCab";
    const IdCompania = "MST_TiempoCabecera.IdCompania";
    const IdSucursal = "MST_TiempoCabecera.IdSucursal";
    const Descripcion = "MST_TiempoCabecera.Descripcion";
    const Estado = "MST_TiempoCabecera.Estado";
    const FechaCreacion = "MST_TiempoCabecera.FechaCreacion";
    const UsuarioCreacion = "MST_TiempoCabecera.UsuarioCreacion";
    const FechaModificacion = "MST_TiempoCabecera.FechaModificacion";
    const UsuarioModificacion = "MST_TiempoCabecera.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TiempoCabecera.IdTiempoCab AS IdTiempoCab, ";
        $s_SQLQuery .= "MST_TiempoCabecera.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_TiempoCabecera.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_TiempoCabecera.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_TiempoCabecera.Estado AS Estado, ";
        $s_SQLQuery .= "MST_TiempoCabecera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_TiempoCabecera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_TiempoCabecera.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_TiempoCabecera.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TiempoCabeceraBN */
    public function setByBN( MST_TiempoCabeceraBN $o_MST_TiempoCabeceraBN )
    {
        if ( !is_null( $o_MST_TiempoCabeceraBN->getIdTiempoCab() ) )
        {
            $this->setIdTiempoCab( $o_MST_TiempoCabeceraBN->getIdTiempoCab() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_TiempoCabeceraBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_TiempoCabeceraBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TiempoCabeceraBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TiempoCabeceraBN->getEstado() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TiempoCabeceraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TiempoCabeceraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TiempoCabeceraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TiempoCabeceraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TiempoCabeceraBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_TiempoCabeceraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTiempoCab )
    {
        if( is_null( $i_IdTiempoCab ) ){ $i_IdTiempoCab = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TiempoCabecera ";
        $s_SQLQuery .= "WHERE IdTiempoCab = ".$i_IdTiempoCab." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_TiempoCabeceraBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TiempoCabeceraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TiempoCabeceraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTiempoCab() ) ) $s_SQLQuery .= "MST_TiempoCabecera.IdTiempoCab = ".$this->getIdTiempoCab()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_TiempoCabecera.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_TiempoCabecera.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_TiempoCabecera.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_TiempoCabecera.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_TiempoCabecera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_TiempoCabecera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_TiempoCabecera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_TiempoCabecera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TiempoCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TiempoCabeceraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TiempoCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_TiempoCabeceraBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TiempoCabeceraBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TiempoCabeceraBN[] = $o_MST_TiempoCabeceraBN;
            }
        }
        return $a_MST_TiempoCabeceraBN;
    }

    /* Devuelve un objeto MST_TiempoCabeceraBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TiempoCabecera )
    {
        $o_MST_TiempoCabeceraBN = new MST_TiempoCabeceraBN();
        if ( !is_null( $a_MST_TiempoCabecera['IdTiempoCab'] ) ) $o_MST_TiempoCabeceraBN->setIdTiempoCab( ( integer ) $a_MST_TiempoCabecera['IdTiempoCab'] );
        if ( !is_null( $a_MST_TiempoCabecera['IdCompania'] ) ) $o_MST_TiempoCabeceraBN->setIdCompania( ( integer ) $a_MST_TiempoCabecera['IdCompania'] );
        if ( !is_null( $a_MST_TiempoCabecera['IdSucursal'] ) ) $o_MST_TiempoCabeceraBN->setIdSucursal( ( integer ) $a_MST_TiempoCabecera['IdSucursal'] );
        if ( !is_null( $a_MST_TiempoCabecera['Descripcion'] ) ) $o_MST_TiempoCabeceraBN->setDescripcion( $a_MST_TiempoCabecera['Descripcion'] );
        if ( !is_null( $a_MST_TiempoCabecera['Estado'] ) ) $o_MST_TiempoCabeceraBN->setEstado( $a_MST_TiempoCabecera['Estado'] );
        if ( !is_null( $a_MST_TiempoCabecera['FechaCreacion'] ) ) $o_MST_TiempoCabeceraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_TiempoCabecera['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TiempoCabecera['UsuarioCreacion'] ) ) $o_MST_TiempoCabeceraBN->setUsuarioCreacion( $a_MST_TiempoCabecera['UsuarioCreacion'] );
        if ( !is_null( $a_MST_TiempoCabecera['FechaModificacion'] ) ) $o_MST_TiempoCabeceraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_TiempoCabecera['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TiempoCabecera['UsuarioModificacion'] ) ) $o_MST_TiempoCabeceraBN->setUsuarioModificacion( $a_MST_TiempoCabecera['UsuarioModificacion'] );
        return $o_MST_TiempoCabeceraBN;
    }
}
?>