<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_StockReposicionDetalle.xml */
/* Generado: 2024-10-15 08:22:32 */

/* Busqueda de registros de la tabla MST_StockReposicionDetalle. */
abstract class BaseMST_StockReposicionDetalleFN extends MST_StockReposicionDetalleBN
{
    /* Declaracion de constantes */
    const IdStockRepoDet = "MST_StockReposicionDetalle.IdStockRepoDet";
    const IdStockRepo = "MST_StockReposicionDetalle.IdStockRepo";
    const IdItem = "MST_StockReposicionDetalle.IdItem";
    const Estado = "MST_StockReposicionDetalle.Estado";
    const StockMinimo = "MST_StockReposicionDetalle.StockMinimo";
    const StockMaximo = "MST_StockReposicionDetalle.StockMaximo";
    const StockActual = "MST_StockReposicionDetalle.StockActual";
    const FechaCreacion = "MST_StockReposicionDetalle.FechaCreacion";
    const UsuarioCreacion = "MST_StockReposicionDetalle.UsuarioCreacion";
    const FechaModificacion = "MST_StockReposicionDetalle.FechaModificacion";
    const UsuarioModificacion = "MST_StockReposicionDetalle.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_StockReposicionDetalle.IdStockRepoDet AS IdStockRepoDet, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.IdStockRepo AS IdStockRepo, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.StockMinimo AS StockMinimo, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.StockMaximo AS StockMaximo, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.StockActual AS StockActual, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_StockReposicionDetalleBN */
    public function setByBN( MST_StockReposicionDetalleBN $o_MST_StockReposicionDetalleBN )
    {
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdStockRepoDet() ) )
        {
            $this->setIdStockRepoDet( $o_MST_StockReposicionDetalleBN->getIdStockRepoDet() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdStockRepo() ) )
        {
            $this->setIdStockRepo( $o_MST_StockReposicionDetalleBN->getIdStockRepo() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_StockReposicionDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_StockReposicionDetalleBN->getEstado() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getStockMinimo() ) )
        {
            $this->setStockMinimo( $o_MST_StockReposicionDetalleBN->getStockMinimo() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getStockMaximo() ) )
        {
            $this->setStockMaximo( $o_MST_StockReposicionDetalleBN->getStockMaximo() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getStockActual() ) )
        {
            $this->setStockActual( $o_MST_StockReposicionDetalleBN->getStockActual() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_StockReposicionDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_StockReposicionDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_StockReposicionDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_StockReposicionDetalleBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_StockReposicionDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdStockRepoDet )
    {
        if( is_null( $i_IdStockRepoDet ) ){ $i_IdStockRepoDet = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionDetalle ";
        $s_SQLQuery .= "WHERE IdStockRepoDet = ".$i_IdStockRepoDet." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_StockReposicionDetalleBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_StockReposicionDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_StockReposicionDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdStockRepoDet() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdStockRepoDet = ".$this->getIdStockRepoDet()." AND ";
        if ( !is_null( $this->getIdStockRepo() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdStockRepo = ".$this->getIdStockRepo()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getStockMinimo() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.StockMinimo = ".$this->getStockMinimo()." AND ";
        if ( !is_null( $this->getStockMaximo() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.StockMaximo = ".$this->getStockMaximo()." AND ";
        if ( !is_null( $this->getStockActual() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.StockActual = ".$this->getStockActual()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_StockReposicionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_StockReposicionDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_StockReposicionDetalleBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_StockReposicionDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_StockReposicionDetalleBN[] = $o_MST_StockReposicionDetalleBN;
            }
        }
        return $a_MST_StockReposicionDetalleBN;
    }

    /* Devuelve un objeto MST_StockReposicionDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_MST_StockReposicionDetalle )
    {
        $o_MST_StockReposicionDetalleBN = new MST_StockReposicionDetalleBN();
        if ( !is_null( $a_MST_StockReposicionDetalle['IdStockRepoDet'] ) ) $o_MST_StockReposicionDetalleBN->setIdStockRepoDet( ( integer ) $a_MST_StockReposicionDetalle['IdStockRepoDet'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['IdStockRepo'] ) ) $o_MST_StockReposicionDetalleBN->setIdStockRepo( ( integer ) $a_MST_StockReposicionDetalle['IdStockRepo'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['IdItem'] ) ) $o_MST_StockReposicionDetalleBN->setIdItem( $a_MST_StockReposicionDetalle['IdItem'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['Estado'] ) ) $o_MST_StockReposicionDetalleBN->setEstado( $a_MST_StockReposicionDetalle['Estado'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['StockMinimo'] ) ) $o_MST_StockReposicionDetalleBN->setStockMinimo( ( float ) $a_MST_StockReposicionDetalle['StockMinimo'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['StockMaximo'] ) ) $o_MST_StockReposicionDetalleBN->setStockMaximo( ( float ) $a_MST_StockReposicionDetalle['StockMaximo'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['StockActual'] ) ) $o_MST_StockReposicionDetalleBN->setStockActual( ( float ) $a_MST_StockReposicionDetalle['StockActual'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['FechaCreacion'] ) ) $o_MST_StockReposicionDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionDetalle['UsuarioCreacion'] ) ) $o_MST_StockReposicionDetalleBN->setUsuarioCreacion( $a_MST_StockReposicionDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['FechaModificacion'] ) ) $o_MST_StockReposicionDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionDetalle['UsuarioModificacion'] ) ) $o_MST_StockReposicionDetalleBN->setUsuarioModificacion( $a_MST_StockReposicionDetalle['UsuarioModificacion'] );
        return $o_MST_StockReposicionDetalleBN;
    }
}
?>