<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProductoCatTalla.xml */
/* Generado: 2024-08-20 23:01:57 */

/* Busqueda de registros de la tabla MST_ReferenciaProductoCatTalla. */
abstract class BaseMST_ReferenciaProductoCatTallaFN extends MST_ReferenciaProductoCatTallaBN
{
    /* Declaracion de constantes */
    const IdReferencia = "MST_ReferenciaProductoCatTalla.IdReferencia";
    const IdColor = "MST_ReferenciaProductoCatTalla.IdColor";
    const IdCatTalla = "MST_ReferenciaProductoCatTalla.IdCatTalla";
    const Aplicado = "MST_ReferenciaProductoCatTalla.Aplicado";
    const UsuarioCreacion = "MST_ReferenciaProductoCatTalla.UsuarioCreacion";
    const FechaCreacion = "MST_ReferenciaProductoCatTalla.FechaCreacion";
    const UsuarioModificacion = "MST_ReferenciaProductoCatTalla.UsuarioModificacion";
    const FechaModificacion = "MST_ReferenciaProductoCatTalla.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ReferenciaProductoCatTalla.IdReferencia AS IdReferencia, ";
        $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.IdColor AS IdColor, ";
        $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.IdCatTalla AS IdCatTalla, ";
        $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.Aplicado AS Aplicado, ";
        $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ReferenciaProductoCatTallaBN */
    public function setByBN( MST_ReferenciaProductoCatTallaBN $o_MST_ReferenciaProductoCatTallaBN )
    {
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_ReferenciaProductoCatTallaBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_ReferenciaProductoCatTallaBN->getIdColor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_ReferenciaProductoCatTallaBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getAplicado() ) )
        {
            $this->setAplicado( $o_MST_ReferenciaProductoCatTallaBN->getAplicado() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ReferenciaProductoCatTallaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ReferenciaProductoCatTallaBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_ReferenciaProductoCatTallaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdReferencia, $i_IdColor, $i_IdCatTalla )
    {
        if( is_null( $i_IdReferencia ) ){ $i_IdReferencia = -1; } 
        if( is_null( $i_IdColor ) ){ $i_IdColor = -1; } 
        if( is_null( $i_IdCatTalla ) ){ $i_IdCatTalla = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProductoCatTalla ";
        $s_SQLQuery .= "WHERE IdReferencia = ".$i_IdReferencia." ";
        $s_SQLQuery .= "AND IdColor = ".$i_IdColor." ";
        $s_SQLQuery .= "AND IdCatTalla = ".$i_IdCatTalla." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ReferenciaProductoCatTallaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ReferenciaProductoCatTallaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ReferenciaProductoCatTallaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdReferencia() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.IdReferencia = ".$this->getIdReferencia()." AND ";
        if ( !is_null( $this->getIdColor() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.IdColor = ".$this->getIdColor()." AND ";
        if ( !is_null( $this->getIdCatTalla() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.IdCatTalla = ".$this->getIdCatTalla()." AND ";
        if ( !is_null( $this->getAplicado() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.Aplicado = ".$this->getAplicado()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoCatTalla.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ReferenciaProductoCatTalla WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ReferenciaProductoCatTallaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProductoCatTalla WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ReferenciaProductoCatTallaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ReferenciaProductoCatTallaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ReferenciaProductoCatTallaBN[] = $o_MST_ReferenciaProductoCatTallaBN;
            }
        }
        return $a_MST_ReferenciaProductoCatTallaBN;
    }

    /* Devuelve un objeto MST_ReferenciaProductoCatTallaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ReferenciaProductoCatTalla )
    {
        $o_MST_ReferenciaProductoCatTallaBN = new MST_ReferenciaProductoCatTallaBN();
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['IdReferencia'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setIdReferencia( ( integer ) $a_MST_ReferenciaProductoCatTalla['IdReferencia'] );
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['IdColor'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setIdColor( ( integer ) $a_MST_ReferenciaProductoCatTalla['IdColor'] );
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['IdCatTalla'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setIdCatTalla( ( integer ) $a_MST_ReferenciaProductoCatTalla['IdCatTalla'] );
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['Aplicado'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setAplicado( ( integer ) $a_MST_ReferenciaProductoCatTalla['Aplicado'] );
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['UsuarioCreacion'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setUsuarioCreacion( $a_MST_ReferenciaProductoCatTalla['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['FechaCreacion'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ReferenciaProductoCatTalla['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['UsuarioModificacion'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setUsuarioModificacion( $a_MST_ReferenciaProductoCatTalla['UsuarioModificacion'] );
        if ( !is_null( $a_MST_ReferenciaProductoCatTalla['FechaModificacion'] ) ) $o_MST_ReferenciaProductoCatTallaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ReferenciaProductoCatTalla['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_ReferenciaProductoCatTallaBN;
    }
}
?>