<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemUbicacion.xml */
/* Generado: 2022-04-18 21:14:58 */

/* Busqueda de registros de la tabla MST_ItemUbicacion. */
abstract class BaseMST_ItemUbicacionFN extends MST_ItemUbicacionBN
{
    /* Declaracion de constantes */
    const IdItem = "MST_ItemUbicacion.IdItem";
    const IdCategoria = "MST_ItemUbicacion.IdCategoria";
    const IdTipoUbicacion = "MST_ItemUbicacion.IdTipoUbicacion";
    const HoraHabitacion = "MST_ItemUbicacion.HoraHabitacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ItemUbicacion.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_ItemUbicacion.IdCategoria AS IdCategoria, ";
        $s_SQLQuery .= "MST_ItemUbicacion.IdTipoUbicacion AS IdTipoUbicacion, ";
        $s_SQLQuery .= "MST_ItemUbicacion.HoraHabitacion AS HoraHabitacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ItemUbicacionBN */
    public function setByBN( MST_ItemUbicacionBN $o_MST_ItemUbicacionBN )
    {
        if ( !is_null( $o_MST_ItemUbicacionBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ItemUbicacionBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ItemUbicacionBN->getIdCategoria() ) )
        {
            $this->setIdCategoria( $o_MST_ItemUbicacionBN->getIdCategoria() );
        }
        if ( !is_null( $o_MST_ItemUbicacionBN->getIdTipoUbicacion() ) )
        {
            $this->setIdTipoUbicacion( $o_MST_ItemUbicacionBN->getIdTipoUbicacion() );
        }
        if ( !is_null( $o_MST_ItemUbicacionBN->getHoraHabitacion() ) )
        {
            $this->setHoraHabitacion( $o_MST_ItemUbicacionBN->getHoraHabitacion() );
        }
    }

    /**
    * @return MST_ItemUbicacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdItem )
    {
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemUbicacion ";
        $s_SQLQuery .= "WHERE IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ItemUbicacionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ItemUbicacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ItemUbicacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_ItemUbicacion.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdCategoria() ) ) $s_SQLQuery .= "MST_ItemUbicacion.IdCategoria = ".$this->getIdCategoria()." AND ";
        if ( !is_null( $this->getIdTipoUbicacion() ) ) $s_SQLQuery .= "MST_ItemUbicacion.IdTipoUbicacion = ".$this->getIdTipoUbicacion()." AND ";
        if ( !is_null( $this->getHoraHabitacion() ) ) $s_SQLQuery .= "MST_ItemUbicacion.HoraHabitacion = ".$this->getHoraHabitacion()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ItemUbicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ItemUbicacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemUbicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ItemUbicacionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ItemUbicacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ItemUbicacionBN[] = $o_MST_ItemUbicacionBN;
            }
        }
        return $a_MST_ItemUbicacionBN;
    }

    /* Devuelve un objeto MST_ItemUbicacionBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ItemUbicacion )
    {
        $o_MST_ItemUbicacionBN = new MST_ItemUbicacionBN();
        if ( !is_null( $a_MST_ItemUbicacion['IdItem'] ) ) $o_MST_ItemUbicacionBN->setIdItem( $a_MST_ItemUbicacion['IdItem'] );
        if ( !is_null( $a_MST_ItemUbicacion['IdCategoria'] ) ) $o_MST_ItemUbicacionBN->setIdCategoria( ( integer ) $a_MST_ItemUbicacion['IdCategoria'] );
        if ( !is_null( $a_MST_ItemUbicacion['IdTipoUbicacion'] ) ) $o_MST_ItemUbicacionBN->setIdTipoUbicacion( ( integer ) $a_MST_ItemUbicacion['IdTipoUbicacion'] );
        if ( !is_null( $a_MST_ItemUbicacion['HoraHabitacion'] ) ) $o_MST_ItemUbicacionBN->setHoraHabitacion( ( integer ) $a_MST_ItemUbicacion['HoraHabitacion'] );
        return $o_MST_ItemUbicacionBN;
    }
}
?>