<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemDiaSemana.xml */
/* Generado: 2022-04-18 21:14:58 */

/* Busqueda de registros de la tabla MST_ItemDiaSemana. */
abstract class BaseMST_ItemDiaSemanaFN extends MST_ItemDiaSemanaBN
{
    /* Declaracion de constantes */
    const IdDiaSem = "MST_ItemDiaSemana.IdDiaSem";
    const IdItem = "MST_ItemDiaSemana.IdItem";
    const DiaNumero = "MST_ItemDiaSemana.DiaNumero";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ItemDiaSemana.IdDiaSem AS IdDiaSem, ";
        $s_SQLQuery .= "MST_ItemDiaSemana.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_ItemDiaSemana.DiaNumero AS DiaNumero ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ItemDiaSemanaBN */
    public function setByBN( MST_ItemDiaSemanaBN $o_MST_ItemDiaSemanaBN )
    {
        if ( !is_null( $o_MST_ItemDiaSemanaBN->getIdDiaSem() ) )
        {
            $this->setIdDiaSem( $o_MST_ItemDiaSemanaBN->getIdDiaSem() );
        }
        if ( !is_null( $o_MST_ItemDiaSemanaBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ItemDiaSemanaBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ItemDiaSemanaBN->getDiaNumero() ) )
        {
            $this->setDiaNumero( $o_MST_ItemDiaSemanaBN->getDiaNumero() );
        }
    }

    /**
    * @return MST_ItemDiaSemanaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdDiaSem, $s_IdItem )
    {
        if( is_null( $i_IdDiaSem ) ){ $i_IdDiaSem = -1; } 
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemDiaSemana ";
        $s_SQLQuery .= "WHERE IdDiaSem = ".$i_IdDiaSem." ";
        $s_SQLQuery .= "AND IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ItemDiaSemanaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ItemDiaSemanaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ItemDiaSemanaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdDiaSem() ) ) $s_SQLQuery .= "MST_ItemDiaSemana.IdDiaSem = ".$this->getIdDiaSem()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_ItemDiaSemana.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getDiaNumero() ) ) $s_SQLQuery .= "MST_ItemDiaSemana.DiaNumero = ".$this->getDiaNumero()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ItemDiaSemana WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ItemDiaSemanaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemDiaSemana WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ItemDiaSemanaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ItemDiaSemanaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ItemDiaSemanaBN[] = $o_MST_ItemDiaSemanaBN;
            }
        }
        return $a_MST_ItemDiaSemanaBN;
    }

    /* Devuelve un objeto MST_ItemDiaSemanaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ItemDiaSemana )
    {
        $o_MST_ItemDiaSemanaBN = new MST_ItemDiaSemanaBN();
        if ( !is_null( $a_MST_ItemDiaSemana['IdDiaSem'] ) ) $o_MST_ItemDiaSemanaBN->setIdDiaSem( ( integer ) $a_MST_ItemDiaSemana['IdDiaSem'] );
        if ( !is_null( $a_MST_ItemDiaSemana['IdItem'] ) ) $o_MST_ItemDiaSemanaBN->setIdItem( $a_MST_ItemDiaSemana['IdItem'] );
        if ( !is_null( $a_MST_ItemDiaSemana['DiaNumero'] ) ) $o_MST_ItemDiaSemanaBN->setDiaNumero( ( integer ) $a_MST_ItemDiaSemana['DiaNumero'] );
        return $o_MST_ItemDiaSemanaBN;
    }
}
?>