<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_DiasAlq.xml */
/* Generado: 2022-04-18 21:14:58 */

/* Busqueda de registros de la tabla MST_DiasAlq. */
abstract class BaseMST_DiasAlqFN extends MST_DiasAlqBN
{
    /* Declaracion de constantes */
    const DiasAlqId = "MST_DiasAlq.DiasAlqId";
    const Descripcion = "MST_DiasAlq.Descripcion";
    const CantDias = "MST_DiasAlq.CantDias";
    const Estado = "MST_DiasAlq.Estado";
    const UsuarioCreacion = "MST_DiasAlq.UsuarioCreacion";
    const FechaCreacion = "MST_DiasAlq.FechaCreacion";
    const UsuarioModificacion = "MST_DiasAlq.UsuarioModificacion";
    const FechaModificacion = "MST_DiasAlq.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_DiasAlq.DiasAlqId AS DiasAlqId, ";
        $s_SQLQuery .= "MST_DiasAlq.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_DiasAlq.CantDias AS CantDias, ";
        $s_SQLQuery .= "MST_DiasAlq.Estado AS Estado, ";
        $s_SQLQuery .= "MST_DiasAlq.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_DiasAlq.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_DiasAlq.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_DiasAlq.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_DiasAlqBN */
    public function setByBN( MST_DiasAlqBN $o_MST_DiasAlqBN )
    {
        if ( !is_null( $o_MST_DiasAlqBN->getDiasAlqId() ) )
        {
            $this->setDiasAlqId( $o_MST_DiasAlqBN->getDiasAlqId() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_DiasAlqBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getCantDias() ) )
        {
            $this->setCantDias( $o_MST_DiasAlqBN->getCantDias() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_DiasAlqBN->getEstado() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_DiasAlqBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_DiasAlqBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_DiasAlqBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_DiasAlqBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_DiasAlqBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DiasAlqId )
    {
        if( is_null( $i_DiasAlqId ) ){ $i_DiasAlqId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_DiasAlq ";
        $s_SQLQuery .= "WHERE DiasAlqId = ".$i_DiasAlqId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_DiasAlqBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_DiasAlqBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_DiasAlqBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDiasAlqId() ) ) $s_SQLQuery .= "MST_DiasAlq.DiasAlqId = ".$this->getDiasAlqId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_DiasAlq.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCantDias() ) ) $s_SQLQuery .= "MST_DiasAlq.CantDias = ".$this->getCantDias()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_DiasAlq.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_DiasAlq.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_DiasAlq.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_DiasAlq.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_DiasAlq.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_DiasAlq WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_DiasAlqBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_DiasAlq WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_DiasAlqBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_DiasAlqBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_DiasAlqBN[] = $o_MST_DiasAlqBN;
            }
        }
        return $a_MST_DiasAlqBN;
    }

    /* Devuelve un objeto MST_DiasAlqBN desde un objeto propel */
    public function insertObjectBN( $a_MST_DiasAlq )
    {
        $o_MST_DiasAlqBN = new MST_DiasAlqBN();
        if ( !is_null( $a_MST_DiasAlq['DiasAlqId'] ) ) $o_MST_DiasAlqBN->setDiasAlqId( ( integer ) $a_MST_DiasAlq['DiasAlqId'] );
        if ( !is_null( $a_MST_DiasAlq['Descripcion'] ) ) $o_MST_DiasAlqBN->setDescripcion( $a_MST_DiasAlq['Descripcion'] );
        if ( !is_null( $a_MST_DiasAlq['CantDias'] ) ) $o_MST_DiasAlqBN->setCantDias( ( integer ) $a_MST_DiasAlq['CantDias'] );
        if ( !is_null( $a_MST_DiasAlq['Estado'] ) ) $o_MST_DiasAlqBN->setEstado( $a_MST_DiasAlq['Estado'] );
        if ( !is_null( $a_MST_DiasAlq['UsuarioCreacion'] ) ) $o_MST_DiasAlqBN->setUsuarioCreacion( $a_MST_DiasAlq['UsuarioCreacion'] );
        if ( !is_null( $a_MST_DiasAlq['FechaCreacion'] ) ) $o_MST_DiasAlqBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_DiasAlq['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_DiasAlq['UsuarioModificacion'] ) ) $o_MST_DiasAlqBN->setUsuarioModificacion( $a_MST_DiasAlq['UsuarioModificacion'] );
        if ( !is_null( $a_MST_DiasAlq['FechaModificacion'] ) ) $o_MST_DiasAlqBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_DiasAlq['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_DiasAlqBN;
    }
}
?>