<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CodigoTipoTributos.xml */
/* Generado: 2022-04-18 21:14:57 */

/* Busqueda de registros de la tabla MST_CodigoTipoTributos. */
abstract class BaseMST_CodigoTipoTributosFN extends MST_CodigoTipoTributosBN
{
    /* Declaracion de constantes */
    const Codigo = "MST_CodigoTipoTributos.Codigo";
    const Descripcion = "MST_CodigoTipoTributos.Descripcion";
    const CodigoInternacional = "MST_CodigoTipoTributos.CodigoInternacional";
    const NombreCorto = "MST_CodigoTipoTributos.NombreCorto";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_CodigoTipoTributos.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_CodigoTipoTributos.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_CodigoTipoTributos.CodigoInternacional AS CodigoInternacional, ";
        $s_SQLQuery .= "MST_CodigoTipoTributos.NombreCorto AS NombreCorto ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_CodigoTipoTributosBN */
    public function setByBN( MST_CodigoTipoTributosBN $o_MST_CodigoTipoTributosBN )
    {
        if ( !is_null( $o_MST_CodigoTipoTributosBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_CodigoTipoTributosBN->getCodigo() );
        }
        if ( !is_null( $o_MST_CodigoTipoTributosBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_CodigoTipoTributosBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_CodigoTipoTributosBN->getCodigoInternacional() ) )
        {
            $this->setCodigoInternacional( $o_MST_CodigoTipoTributosBN->getCodigoInternacional() );
        }
        if ( !is_null( $o_MST_CodigoTipoTributosBN->getNombreCorto() ) )
        {
            $this->setNombreCorto( $o_MST_CodigoTipoTributosBN->getNombreCorto() );
        }
    }

    /**
    * @return MST_CodigoTipoTributosBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_Codigo )
    {
        if( is_null( $s_Codigo ) ){ $s_Codigo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CodigoTipoTributos ";
        $s_SQLQuery .= "WHERE Codigo = '".$s_Codigo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_CodigoTipoTributosBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_CodigoTipoTributosBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_CodigoTipoTributosBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_CodigoTipoTributos.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_CodigoTipoTributos.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigoInternacional() ) ) $s_SQLQuery .= "MST_CodigoTipoTributos.CodigoInternacional = '".$this->getCodigoInternacional()."' AND ";
        if ( !is_null( $this->getNombreCorto() ) ) $s_SQLQuery .= "MST_CodigoTipoTributos.NombreCorto = '".$this->getNombreCorto()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_CodigoTipoTributos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_CodigoTipoTributosBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CodigoTipoTributos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_CodigoTipoTributosBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_CodigoTipoTributosBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_CodigoTipoTributosBN[] = $o_MST_CodigoTipoTributosBN;
            }
        }
        return $a_MST_CodigoTipoTributosBN;
    }

    /* Devuelve un objeto MST_CodigoTipoTributosBN desde un objeto propel */
    public function insertObjectBN( $a_MST_CodigoTipoTributos )
    {
        $o_MST_CodigoTipoTributosBN = new MST_CodigoTipoTributosBN();
        if ( !is_null( $a_MST_CodigoTipoTributos['Codigo'] ) ) $o_MST_CodigoTipoTributosBN->setCodigo( $a_MST_CodigoTipoTributos['Codigo'] );
        if ( !is_null( $a_MST_CodigoTipoTributos['Descripcion'] ) ) $o_MST_CodigoTipoTributosBN->setDescripcion( $a_MST_CodigoTipoTributos['Descripcion'] );
        if ( !is_null( $a_MST_CodigoTipoTributos['CodigoInternacional'] ) ) $o_MST_CodigoTipoTributosBN->setCodigoInternacional( $a_MST_CodigoTipoTributos['CodigoInternacional'] );
        if ( !is_null( $a_MST_CodigoTipoTributos['NombreCorto'] ) ) $o_MST_CodigoTipoTributosBN->setNombreCorto( $a_MST_CodigoTipoTributos['NombreCorto'] );
        return $o_MST_CodigoTipoTributosBN;
    }
}
?>