<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClienteMast.xml */
/* Generado: 2022-04-18 21:14:57 */

/* Busqueda de registros de la tabla MST_ClienteMast. */
abstract class BaseMST_ClienteMastFN extends MST_ClienteMastBN
{
    /* Declaracion de constantes */
    const IdCliente = "MST_ClienteMast.IdCliente";
    const Clasificacion = "MST_ClienteMast.Clasificacion";
    const LineaCredito = "MST_ClienteMast.LineaCredito";
    const IngresoMensual = "MST_ClienteMast.IngresoMensual";
    const Vendedor = "MST_ClienteMast.Vendedor";
    const VendedorCod = "MST_ClienteMast.VendedorCod";
    const FormadePago = "MST_ClienteMast.FormadePago";
    const TotalAcumulado = "MST_ClienteMast.TotalAcumulado";
    const TipoServicio = "MST_ClienteMast.TipoServicio";
    const NumeroDiasCobranza = "MST_ClienteMast.NumeroDiasCobranza";
    const PagoEfectivoFlag = "MST_ClienteMast.PagoEfectivoFlag";
    const TipoFacturacion = "MST_ClienteMast.TipoFacturacion";
    const TipoVenta = "MST_ClienteMast.TipoVenta";
    const FormaFacturacion = "MST_ClienteMast.FormaFacturacion";
    const TipoCliente = "MST_ClienteMast.TipoCliente";
    const CentroCosto = "MST_ClienteMast.CentroCosto";
    const CodCanal = "MST_ClienteMast.CodCanal";
    const CreditoHold = "MST_ClienteMast.CreditoHold";
    const UsuarioModificacion = "MST_ClienteMast.UsuarioModificacion";
    const FechaModificacion = "MST_ClienteMast.FechaModificacion";
    const UsuarioCreacion = "MST_ClienteMast.UsuarioCreacion";
    const FechaCreacion = "MST_ClienteMast.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ClienteMast.IdCliente AS IdCliente, ";
        $s_SQLQuery .= "MST_ClienteMast.Clasificacion AS Clasificacion, ";
        $s_SQLQuery .= "MST_ClienteMast.LineaCredito AS LineaCredito, ";
        $s_SQLQuery .= "MST_ClienteMast.IngresoMensual AS IngresoMensual, ";
        $s_SQLQuery .= "MST_ClienteMast.Vendedor AS Vendedor, ";
        $s_SQLQuery .= "MST_ClienteMast.VendedorCod AS VendedorCod, ";
        $s_SQLQuery .= "MST_ClienteMast.FormadePago AS FormadePago, ";
        $s_SQLQuery .= "MST_ClienteMast.TotalAcumulado AS TotalAcumulado, ";
        $s_SQLQuery .= "MST_ClienteMast.TipoServicio AS TipoServicio, ";
        $s_SQLQuery .= "MST_ClienteMast.NumeroDiasCobranza AS NumeroDiasCobranza, ";
        $s_SQLQuery .= "MST_ClienteMast.PagoEfectivoFlag AS PagoEfectivoFlag, ";
        $s_SQLQuery .= "MST_ClienteMast.TipoFacturacion AS TipoFacturacion, ";
        $s_SQLQuery .= "MST_ClienteMast.TipoVenta AS TipoVenta, ";
        $s_SQLQuery .= "MST_ClienteMast.FormaFacturacion AS FormaFacturacion, ";
        $s_SQLQuery .= "MST_ClienteMast.TipoCliente AS TipoCliente, ";
        $s_SQLQuery .= "MST_ClienteMast.CentroCosto AS CentroCosto, ";
        $s_SQLQuery .= "MST_ClienteMast.CodCanal AS CodCanal, ";
        $s_SQLQuery .= "MST_ClienteMast.CreditoHold AS CreditoHold, ";
        $s_SQLQuery .= "MST_ClienteMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_ClienteMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_ClienteMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ClienteMast.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ClienteMastBN */
    public function setByBN( MST_ClienteMastBN $o_MST_ClienteMastBN )
    {
        if ( !is_null( $o_MST_ClienteMastBN->getIdCliente() ) )
        {
            $this->setIdCliente( $o_MST_ClienteMastBN->getIdCliente() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getClasificacion() ) )
        {
            $this->setClasificacion( $o_MST_ClienteMastBN->getClasificacion() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getLineaCredito() ) )
        {
            $this->setLineaCredito( $o_MST_ClienteMastBN->getLineaCredito() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getIngresoMensual() ) )
        {
            $this->setIngresoMensual( $o_MST_ClienteMastBN->getIngresoMensual() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getVendedor() ) )
        {
            $this->setVendedor( $o_MST_ClienteMastBN->getVendedor() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getVendedorCod() ) )
        {
            $this->setVendedorCod( $o_MST_ClienteMastBN->getVendedorCod() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getFormadePago() ) )
        {
            $this->setFormadePago( $o_MST_ClienteMastBN->getFormadePago() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getTotalAcumulado() ) )
        {
            $this->setTotalAcumulado( $o_MST_ClienteMastBN->getTotalAcumulado() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getTipoServicio() ) )
        {
            $this->setTipoServicio( $o_MST_ClienteMastBN->getTipoServicio() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getNumeroDiasCobranza() ) )
        {
            $this->setNumeroDiasCobranza( $o_MST_ClienteMastBN->getNumeroDiasCobranza() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getPagoEfectivoFlag() ) )
        {
            $this->setPagoEfectivoFlag( $o_MST_ClienteMastBN->getPagoEfectivoFlag() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getTipoFacturacion() ) )
        {
            $this->setTipoFacturacion( $o_MST_ClienteMastBN->getTipoFacturacion() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getTipoVenta() ) )
        {
            $this->setTipoVenta( $o_MST_ClienteMastBN->getTipoVenta() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getFormaFacturacion() ) )
        {
            $this->setFormaFacturacion( $o_MST_ClienteMastBN->getFormaFacturacion() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getTipoCliente() ) )
        {
            $this->setTipoCliente( $o_MST_ClienteMastBN->getTipoCliente() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getCentroCosto() ) )
        {
            $this->setCentroCosto( $o_MST_ClienteMastBN->getCentroCosto() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getCodCanal() ) )
        {
            $this->setCodCanal( $o_MST_ClienteMastBN->getCodCanal() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getCreditoHold() ) )
        {
            $this->setCreditoHold( $o_MST_ClienteMastBN->getCreditoHold() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ClienteMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ClienteMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ClienteMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ClienteMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ClienteMastBN->getFechaCreacion() );
        }
    }

    /**
    * @return MST_ClienteMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCliente )
    {
        if( is_null( $i_IdCliente ) ){ $i_IdCliente = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClienteMast ";
        $s_SQLQuery .= "WHERE IdCliente = ".$i_IdCliente." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ClienteMastBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ClienteMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ClienteMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCliente() ) ) $s_SQLQuery .= "MST_ClienteMast.IdCliente = ".$this->getIdCliente()." AND ";
        if ( !is_null( $this->getClasificacion() ) ) $s_SQLQuery .= "MST_ClienteMast.Clasificacion = '".$this->getClasificacion()."' AND ";
        if ( !is_null( $this->getLineaCredito() ) ) $s_SQLQuery .= "MST_ClienteMast.LineaCredito = ".$this->getLineaCredito()." AND ";
        if ( !is_null( $this->getIngresoMensual() ) ) $s_SQLQuery .= "MST_ClienteMast.IngresoMensual = ".$this->getIngresoMensual()." AND ";
        if ( !is_null( $this->getVendedor() ) ) $s_SQLQuery .= "MST_ClienteMast.Vendedor = ".$this->getVendedor()." AND ";
        if ( !is_null( $this->getVendedorCod() ) ) $s_SQLQuery .= "MST_ClienteMast.VendedorCod = '".$this->getVendedorCod()."' AND ";
        if ( !is_null( $this->getFormadePago() ) ) $s_SQLQuery .= "MST_ClienteMast.FormadePago = '".$this->getFormadePago()."' AND ";
        if ( !is_null( $this->getTotalAcumulado() ) ) $s_SQLQuery .= "MST_ClienteMast.TotalAcumulado = ".$this->getTotalAcumulado()." AND ";
        if ( !is_null( $this->getTipoServicio() ) ) $s_SQLQuery .= "MST_ClienteMast.TipoServicio = '".$this->getTipoServicio()."' AND ";
        if ( !is_null( $this->getNumeroDiasCobranza() ) ) $s_SQLQuery .= "MST_ClienteMast.NumeroDiasCobranza = ".$this->getNumeroDiasCobranza()." AND ";
        if ( !is_null( $this->getPagoEfectivoFlag() ) ) $s_SQLQuery .= "MST_ClienteMast.PagoEfectivoFlag = '".$this->getPagoEfectivoFlag()."' AND ";
        if ( !is_null( $this->getTipoFacturacion() ) ) $s_SQLQuery .= "MST_ClienteMast.TipoFacturacion = '".$this->getTipoFacturacion()."' AND ";
        if ( !is_null( $this->getTipoVenta() ) ) $s_SQLQuery .= "MST_ClienteMast.TipoVenta = '".$this->getTipoVenta()."' AND ";
        if ( !is_null( $this->getFormaFacturacion() ) ) $s_SQLQuery .= "MST_ClienteMast.FormaFacturacion = '".$this->getFormaFacturacion()."' AND ";
        if ( !is_null( $this->getTipoCliente() ) ) $s_SQLQuery .= "MST_ClienteMast.TipoCliente = '".$this->getTipoCliente()."' AND ";
        if ( !is_null( $this->getCentroCosto() ) ) $s_SQLQuery .= "MST_ClienteMast.CentroCosto = '".$this->getCentroCosto()."' AND ";
        if ( !is_null( $this->getCodCanal() ) ) $s_SQLQuery .= "MST_ClienteMast.CodCanal = '".$this->getCodCanal()."' AND ";
        if ( !is_null( $this->getCreditoHold() ) ) $s_SQLQuery .= "MST_ClienteMast.CreditoHold = '".$this->getCreditoHold()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ClienteMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ClienteMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ClienteMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ClienteMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ClienteMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ClienteMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClienteMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ClienteMastBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ClienteMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ClienteMastBN[] = $o_MST_ClienteMastBN;
            }
        }
        return $a_MST_ClienteMastBN;
    }

    /* Devuelve un objeto MST_ClienteMastBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ClienteMast )
    {
        $o_MST_ClienteMastBN = new MST_ClienteMastBN();
        if ( !is_null( $a_MST_ClienteMast['IdCliente'] ) ) $o_MST_ClienteMastBN->setIdCliente( ( integer ) $a_MST_ClienteMast['IdCliente'] );
        if ( !is_null( $a_MST_ClienteMast['Clasificacion'] ) ) $o_MST_ClienteMastBN->setClasificacion( $a_MST_ClienteMast['Clasificacion'] );
        if ( !is_null( $a_MST_ClienteMast['LineaCredito'] ) ) $o_MST_ClienteMastBN->setLineaCredito( ( integer ) $a_MST_ClienteMast['LineaCredito'] );
        if ( !is_null( $a_MST_ClienteMast['IngresoMensual'] ) ) $o_MST_ClienteMastBN->setIngresoMensual( ( float ) $a_MST_ClienteMast['IngresoMensual'] );
        if ( !is_null( $a_MST_ClienteMast['Vendedor'] ) ) $o_MST_ClienteMastBN->setVendedor( ( integer ) $a_MST_ClienteMast['Vendedor'] );
        if ( !is_null( $a_MST_ClienteMast['VendedorCod'] ) ) $o_MST_ClienteMastBN->setVendedorCod( $a_MST_ClienteMast['VendedorCod'] );
        if ( !is_null( $a_MST_ClienteMast['FormadePago'] ) ) $o_MST_ClienteMastBN->setFormadePago( $a_MST_ClienteMast['FormadePago'] );
        if ( !is_null( $a_MST_ClienteMast['TotalAcumulado'] ) ) $o_MST_ClienteMastBN->setTotalAcumulado( ( float ) $a_MST_ClienteMast['TotalAcumulado'] );
        if ( !is_null( $a_MST_ClienteMast['TipoServicio'] ) ) $o_MST_ClienteMastBN->setTipoServicio( $a_MST_ClienteMast['TipoServicio'] );
        if ( !is_null( $a_MST_ClienteMast['NumeroDiasCobranza'] ) ) $o_MST_ClienteMastBN->setNumeroDiasCobranza( ( integer ) $a_MST_ClienteMast['NumeroDiasCobranza'] );
        if ( !is_null( $a_MST_ClienteMast['PagoEfectivoFlag'] ) ) $o_MST_ClienteMastBN->setPagoEfectivoFlag( $a_MST_ClienteMast['PagoEfectivoFlag'] );
        if ( !is_null( $a_MST_ClienteMast['TipoFacturacion'] ) ) $o_MST_ClienteMastBN->setTipoFacturacion( $a_MST_ClienteMast['TipoFacturacion'] );
        if ( !is_null( $a_MST_ClienteMast['TipoVenta'] ) ) $o_MST_ClienteMastBN->setTipoVenta( $a_MST_ClienteMast['TipoVenta'] );
        if ( !is_null( $a_MST_ClienteMast['FormaFacturacion'] ) ) $o_MST_ClienteMastBN->setFormaFacturacion( $a_MST_ClienteMast['FormaFacturacion'] );
        if ( !is_null( $a_MST_ClienteMast['TipoCliente'] ) ) $o_MST_ClienteMastBN->setTipoCliente( $a_MST_ClienteMast['TipoCliente'] );
        if ( !is_null( $a_MST_ClienteMast['CentroCosto'] ) ) $o_MST_ClienteMastBN->setCentroCosto( $a_MST_ClienteMast['CentroCosto'] );
        if ( !is_null( $a_MST_ClienteMast['CodCanal'] ) ) $o_MST_ClienteMastBN->setCodCanal( $a_MST_ClienteMast['CodCanal'] );
        if ( !is_null( $a_MST_ClienteMast['CreditoHold'] ) ) $o_MST_ClienteMastBN->setCreditoHold( $a_MST_ClienteMast['CreditoHold'] );
        if ( !is_null( $a_MST_ClienteMast['UsuarioModificacion'] ) ) $o_MST_ClienteMastBN->setUsuarioModificacion( $a_MST_ClienteMast['UsuarioModificacion'] );
        if ( !is_null( $a_MST_ClienteMast['FechaModificacion'] ) ) $o_MST_ClienteMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ClienteMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ClienteMast['UsuarioCreacion'] ) ) $o_MST_ClienteMastBN->setUsuarioCreacion( $a_MST_ClienteMast['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ClienteMast['FechaCreacion'] ) ) $o_MST_ClienteMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ClienteMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_MST_ClienteMastBN;
    }
}
?>