<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClaseFamilia.xml */
/* Generado: 2022-04-18 21:14:57 */

/* Busqueda de registros de la tabla MST_ClaseFamilia. */
abstract class BaseMST_ClaseFamiliaFN extends MST_ClaseFamiliaBN
{
    /* Declaracion de constantes */
    const IdFamilia = "MST_ClaseFamilia.IdFamilia";
    const IdLinea = "MST_ClaseFamilia.IdLinea";
    const Descripcion = "MST_ClaseFamilia.Descripcion";
    const Codigo = "MST_ClaseFamilia.Codigo";
    const Estado = "MST_ClaseFamilia.Estado";
    const FechaCreacion = "MST_ClaseFamilia.FechaCreacion";
    const UsuarioCreacion = "MST_ClaseFamilia.UsuarioCreacion";
    const FechaModificacion = "MST_ClaseFamilia.FechaModificacion";
    const UsuarioModificacion = "MST_ClaseFamilia.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ClaseFamilia.IdFamilia AS IdFamilia, ";
        $s_SQLQuery .= "MST_ClaseFamilia.IdLinea AS IdLinea, ";
        $s_SQLQuery .= "MST_ClaseFamilia.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_ClaseFamilia.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_ClaseFamilia.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ClaseFamilia.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ClaseFamilia.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ClaseFamilia.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_ClaseFamilia.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ClaseFamiliaBN */
    public function setByBN( MST_ClaseFamiliaBN $o_MST_ClaseFamiliaBN )
    {
        if ( !is_null( $o_MST_ClaseFamiliaBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_MST_ClaseFamiliaBN->getIdFamilia() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_MST_ClaseFamiliaBN->getIdLinea() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ClaseFamiliaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_ClaseFamiliaBN->getCodigo() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ClaseFamiliaBN->getEstado() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ClaseFamiliaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ClaseFamiliaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ClaseFamiliaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ClaseFamiliaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_ClaseFamiliaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdFamilia )
    {
        if( is_null( $i_IdFamilia ) ){ $i_IdFamilia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClaseFamilia ";
        $s_SQLQuery .= "WHERE IdFamilia = ".$i_IdFamilia." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ClaseFamiliaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ClaseFamiliaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ClaseFamiliaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdFamilia() ) ) $s_SQLQuery .= "MST_ClaseFamilia.IdFamilia = ".$this->getIdFamilia()." AND ";
        if ( !is_null( $this->getIdLinea() ) ) $s_SQLQuery .= "MST_ClaseFamilia.IdLinea = ".$this->getIdLinea()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_ClaseFamilia.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_ClaseFamilia.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ClaseFamilia.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ClaseFamilia.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ClaseFamilia.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ClaseFamilia.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ClaseFamilia.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ClaseFamilia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ClaseFamiliaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClaseFamilia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ClaseFamiliaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ClaseFamiliaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ClaseFamiliaBN[] = $o_MST_ClaseFamiliaBN;
            }
        }
        return $a_MST_ClaseFamiliaBN;
    }

    /* Devuelve un objeto MST_ClaseFamiliaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ClaseFamilia )
    {
        $o_MST_ClaseFamiliaBN = new MST_ClaseFamiliaBN();
        if ( !is_null( $a_MST_ClaseFamilia['IdFamilia'] ) ) $o_MST_ClaseFamiliaBN->setIdFamilia( ( integer ) $a_MST_ClaseFamilia['IdFamilia'] );
        if ( !is_null( $a_MST_ClaseFamilia['IdLinea'] ) ) $o_MST_ClaseFamiliaBN->setIdLinea( ( integer ) $a_MST_ClaseFamilia['IdLinea'] );
        if ( !is_null( $a_MST_ClaseFamilia['Descripcion'] ) ) $o_MST_ClaseFamiliaBN->setDescripcion( $a_MST_ClaseFamilia['Descripcion'] );
        if ( !is_null( $a_MST_ClaseFamilia['Codigo'] ) ) $o_MST_ClaseFamiliaBN->setCodigo( $a_MST_ClaseFamilia['Codigo'] );
        if ( !is_null( $a_MST_ClaseFamilia['Estado'] ) ) $o_MST_ClaseFamiliaBN->setEstado( $a_MST_ClaseFamilia['Estado'] );
        if ( !is_null( $a_MST_ClaseFamilia['FechaCreacion'] ) ) $o_MST_ClaseFamiliaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ClaseFamilia['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ClaseFamilia['UsuarioCreacion'] ) ) $o_MST_ClaseFamiliaBN->setUsuarioCreacion( $a_MST_ClaseFamilia['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ClaseFamilia['FechaModificacion'] ) ) $o_MST_ClaseFamiliaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ClaseFamilia['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ClaseFamilia['UsuarioModificacion'] ) ) $o_MST_ClaseFamiliaBN->setUsuarioModificacion( $a_MST_ClaseFamilia['UsuarioModificacion'] );
        return $o_MST_ClaseFamiliaBN;
    }
}
?>