<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Cartera.xml */
/* Generado: 2024-10-18 17:06:00 */

/* Busqueda de registros de la tabla MST_Cartera. */
abstract class BaseMST_CarteraFN extends MST_CarteraBN
{
    /* Declaracion de constantes */
    const IdCartera = "MST_Cartera.IdCartera";
    const Nombre = "MST_Cartera.Nombre";
    const FlagRango = "MST_Cartera.FlagRango";
    const Estado = "MST_Cartera.Estado";
    const UsuarioCreacion = "MST_Cartera.UsuarioCreacion";
    const FechaCreacion = "MST_Cartera.FechaCreacion";
    const UsuarioModificacion = "MST_Cartera.UsuarioModificacion";
    const FechaModificacion = "MST_Cartera.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Cartera.IdCartera AS IdCartera, ";
        $s_SQLQuery .= "MST_Cartera.Nombre AS Nombre, ";
        $s_SQLQuery .= "MST_Cartera.FlagRango AS FlagRango, ";
        $s_SQLQuery .= "MST_Cartera.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Cartera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Cartera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Cartera.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_Cartera.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_CarteraBN */
    public function setByBN( MST_CarteraBN $o_MST_CarteraBN )
    {
        if ( !is_null( $o_MST_CarteraBN->getIdCartera() ) )
        {
            $this->setIdCartera( $o_MST_CarteraBN->getIdCartera() );
        }
        if ( !is_null( $o_MST_CarteraBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_CarteraBN->getNombre() );
        }
        if ( !is_null( $o_MST_CarteraBN->getFlagRango() ) )
        {
            $this->setFlagRango( $o_MST_CarteraBN->getFlagRango() );
        }
        if ( !is_null( $o_MST_CarteraBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_CarteraBN->getEstado() );
        }
        if ( !is_null( $o_MST_CarteraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_CarteraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_CarteraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_CarteraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_CarteraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_CarteraBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_CarteraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_CarteraBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_CarteraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCartera )
    {
        if( is_null( $i_IdCartera ) ){ $i_IdCartera = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Cartera ";
        $s_SQLQuery .= "WHERE IdCartera = ".$i_IdCartera." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_CarteraBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_CarteraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_CarteraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCartera() ) ) $s_SQLQuery .= "MST_Cartera.IdCartera = ".$this->getIdCartera()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "MST_Cartera.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getFlagRango() ) ) $s_SQLQuery .= "MST_Cartera.FlagRango = ".$this->getFlagRango()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Cartera.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Cartera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Cartera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Cartera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Cartera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Cartera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_CarteraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Cartera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_CarteraBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_CarteraBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_CarteraBN[] = $o_MST_CarteraBN;
            }
        }
        return $a_MST_CarteraBN;
    }

    /* Devuelve un objeto MST_CarteraBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Cartera )
    {
        $o_MST_CarteraBN = new MST_CarteraBN();
        if ( !is_null( $a_MST_Cartera['IdCartera'] ) ) $o_MST_CarteraBN->setIdCartera( ( integer ) $a_MST_Cartera['IdCartera'] );
        if ( !is_null( $a_MST_Cartera['Nombre'] ) ) $o_MST_CarteraBN->setNombre( $a_MST_Cartera['Nombre'] );
        if ( !is_null( $a_MST_Cartera['FlagRango'] ) ) $o_MST_CarteraBN->setFlagRango( ( integer ) $a_MST_Cartera['FlagRango'] );
        if ( !is_null( $a_MST_Cartera['Estado'] ) ) $o_MST_CarteraBN->setEstado( $a_MST_Cartera['Estado'] );
        if ( !is_null( $a_MST_Cartera['UsuarioCreacion'] ) ) $o_MST_CarteraBN->setUsuarioCreacion( $a_MST_Cartera['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Cartera['FechaCreacion'] ) ) $o_MST_CarteraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Cartera['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Cartera['UsuarioModificacion'] ) ) $o_MST_CarteraBN->setUsuarioModificacion( $a_MST_Cartera['UsuarioModificacion'] );
        if ( !is_null( $a_MST_Cartera['FechaModificacion'] ) ) $o_MST_CarteraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Cartera['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_CarteraBN;
    }
}
?>