<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Aduana.xml */
/* Generado: 2022-04-18 21:14:57 */

/* Busqueda de registros de la tabla MST_Aduana. */
abstract class BaseMST_AduanaFN extends MST_AduanaBN
{
    /* Declaracion de constantes */
    const Id = "MST_Aduana.Id";
    const Descripcion = "MST_Aduana.Descripcion";
    const IdUbigeo = "MST_Aduana.IdUbigeo";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Aduana.Id AS Id, ";
        $s_SQLQuery .= "MST_Aduana.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Aduana.IdUbigeo AS IdUbigeo ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_AduanaBN */
    public function setByBN( MST_AduanaBN $o_MST_AduanaBN )
    {
        if ( !is_null( $o_MST_AduanaBN->getId() ) )
        {
            $this->setId( $o_MST_AduanaBN->getId() );
        }
        if ( !is_null( $o_MST_AduanaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_AduanaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_AduanaBN->getIdUbigeo() ) )
        {
            $this->setIdUbigeo( $o_MST_AduanaBN->getIdUbigeo() );
        }
    }

    /**
    * @return MST_AduanaBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_Id )
    {
        if( is_null( $s_Id ) ){ $s_Id = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Aduana ";
        $s_SQLQuery .= "WHERE Id = '".$s_Id."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_AduanaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_AduanaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_AduanaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getId() ) ) $s_SQLQuery .= "MST_Aduana.Id = '".$this->getId()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Aduana.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getIdUbigeo() ) ) $s_SQLQuery .= "MST_Aduana.IdUbigeo = '".$this->getIdUbigeo()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Aduana WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_AduanaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Aduana WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_AduanaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_AduanaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_AduanaBN[] = $o_MST_AduanaBN;
            }
        }
        return $a_MST_AduanaBN;
    }

    /* Devuelve un objeto MST_AduanaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Aduana )
    {
        $o_MST_AduanaBN = new MST_AduanaBN();
        if ( !is_null( $a_MST_Aduana['Id'] ) ) $o_MST_AduanaBN->setId( $a_MST_Aduana['Id'] );
        if ( !is_null( $a_MST_Aduana['Descripcion'] ) ) $o_MST_AduanaBN->setDescripcion( $a_MST_Aduana['Descripcion'] );
        if ( !is_null( $a_MST_Aduana['IdUbigeo'] ) ) $o_MST_AduanaBN->setIdUbigeo( $a_MST_Aduana['IdUbigeo'] );
        return $o_MST_AduanaBN;
    }
}
?>