<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_TipoCambio.xml */
/* Generado: 2022-04-18 21:14:56 */

/* Busqueda de registros de la tabla GSS_TipoCambio. */
abstract class BaseGSS_TipoCambioFN extends GSS_TipoCambioBN
{
    /* Declaracion de constantes */
    const IdMoneda = "GSS_TipoCambio.IdMoneda";
    const IdMonedaCambio = "GSS_TipoCambio.IdMonedaCambio";
    const IdFechaCambio = "GSS_TipoCambio.IdFechaCambio";
    const IdCompania = "GSS_TipoCambio.IdCompania";
    const SunatCompra = "GSS_TipoCambio.SunatCompra";
    const SunatVenta = "GSS_TipoCambio.SunatVenta";
    const TipoCambioCobranza = "GSS_TipoCambio.TipoCambioCobranza";
    const Estado = "GSS_TipoCambio.Estado";
    const FechaCreacion = "GSS_TipoCambio.FechaCreacion";
    const UsuarioCreacion = "GSS_TipoCambio.UsuarioCreacion";
    const FechaModificacion = "GSS_TipoCambio.FechaModificacion";
    const UsuarioModificacion = "GSS_TipoCambio.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_TipoCambio.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "GSS_TipoCambio.IdMonedaCambio AS IdMonedaCambio, ";
        $s_SQLQuery .= "GSS_TipoCambio.IdFechaCambio AS IdFechaCambio, ";
        $s_SQLQuery .= "GSS_TipoCambio.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_TipoCambio.SunatCompra AS SunatCompra, ";
        $s_SQLQuery .= "GSS_TipoCambio.SunatVenta AS SunatVenta, ";
        $s_SQLQuery .= "GSS_TipoCambio.TipoCambioCobranza AS TipoCambioCobranza, ";
        $s_SQLQuery .= "GSS_TipoCambio.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_TipoCambio.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_TipoCambio.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_TipoCambio.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_TipoCambio.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_TipoCambioBN */
    public function setByBN( GSS_TipoCambioBN $o_GSS_TipoCambioBN )
    {
        if ( !is_null( $o_GSS_TipoCambioBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_GSS_TipoCambioBN->getIdMoneda() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getIdMonedaCambio() ) )
        {
            $this->setIdMonedaCambio( $o_GSS_TipoCambioBN->getIdMonedaCambio() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getIdFechaCambio() ) )
        {
            $this->setIdFechaCambio( $o_GSS_TipoCambioBN->getIdFechaCambio() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_TipoCambioBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getSunatCompra() ) )
        {
            $this->setSunatCompra( $o_GSS_TipoCambioBN->getSunatCompra() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getSunatVenta() ) )
        {
            $this->setSunatVenta( $o_GSS_TipoCambioBN->getSunatVenta() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getTipoCambioCobranza() ) )
        {
            $this->setTipoCambioCobranza( $o_GSS_TipoCambioBN->getTipoCambioCobranza() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_TipoCambioBN->getEstado() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_TipoCambioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_TipoCambioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_TipoCambioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_TipoCambioBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_TipoCambioBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdMoneda, $s_IdMonedaCambio, $d_IdFechaCambio, $i_IdCompania )
    {
        if( is_null( $s_IdMoneda ) ){ $s_IdMoneda = '-1'; } 
        if( is_null( $s_IdMonedaCambio ) ){ $s_IdMonedaCambio = '-1'; } 
        if( is_null( $d_IdFechaCambio ) ){ $d_IdFechaCambio = '-1'; } 
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_TipoCambio ";
        $s_SQLQuery .= "WHERE IdMoneda = '".$s_IdMoneda."' ";
        $s_SQLQuery .= "AND IdMonedaCambio = '".$s_IdMonedaCambio."' ";
        $s_SQLQuery .= "AND IdFechaCambio = '".$d_IdFechaCambio."' ";
        $s_SQLQuery .= "AND IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_GSS_TipoCambioBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_TipoCambioBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_TipoCambioBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "GSS_TipoCambio.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getIdMonedaCambio() ) ) $s_SQLQuery .= "GSS_TipoCambio.IdMonedaCambio = '".$this->getIdMonedaCambio()."' AND ";
        if ( !is_null( $this->getIdFechaCambio() ) ) $s_SQLQuery .= "GSS_TipoCambio.IdFechaCambio = '".$this->getIdFechaCambio()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_TipoCambio.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getSunatCompra() ) ) $s_SQLQuery .= "GSS_TipoCambio.SunatCompra = ".$this->getSunatCompra()." AND ";
        if ( !is_null( $this->getSunatVenta() ) ) $s_SQLQuery .= "GSS_TipoCambio.SunatVenta = ".$this->getSunatVenta()." AND ";
        if ( !is_null( $this->getTipoCambioCobranza() ) ) $s_SQLQuery .= "GSS_TipoCambio.TipoCambioCobranza = ".$this->getTipoCambioCobranza()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_TipoCambio.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_TipoCambio.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_TipoCambio.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_TipoCambio.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_TipoCambio.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_TipoCambio WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_TipoCambioBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_TipoCambio WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_GSS_TipoCambioBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_TipoCambioBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_TipoCambioBN[] = $o_GSS_TipoCambioBN;
            }
        }
        return $a_GSS_TipoCambioBN;
    }

    /* Devuelve un objeto GSS_TipoCambioBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_TipoCambio )
    {
        $o_GSS_TipoCambioBN = new GSS_TipoCambioBN();
        if ( !is_null( $a_GSS_TipoCambio['IdMoneda'] ) ) $o_GSS_TipoCambioBN->setIdMoneda( $a_GSS_TipoCambio['IdMoneda'] );
        if ( !is_null( $a_GSS_TipoCambio['IdMonedaCambio'] ) ) $o_GSS_TipoCambioBN->setIdMonedaCambio( $a_GSS_TipoCambio['IdMonedaCambio'] );
        if ( !is_null( $a_GSS_TipoCambio['IdFechaCambio'] ) ) $o_GSS_TipoCambioBN->setIdFechaCambio( utilTimestamp::getTimestamp( $a_GSS_TipoCambio['IdFechaCambio'], "Y-m-d" ) );
        if ( !is_null( $a_GSS_TipoCambio['IdCompania'] ) ) $o_GSS_TipoCambioBN->setIdCompania( ( integer ) $a_GSS_TipoCambio['IdCompania'] );
        if ( !is_null( $a_GSS_TipoCambio['SunatCompra'] ) ) $o_GSS_TipoCambioBN->setSunatCompra( ( float ) $a_GSS_TipoCambio['SunatCompra'] );
        if ( !is_null( $a_GSS_TipoCambio['SunatVenta'] ) ) $o_GSS_TipoCambioBN->setSunatVenta( ( float ) $a_GSS_TipoCambio['SunatVenta'] );
        if ( !is_null( $a_GSS_TipoCambio['TipoCambioCobranza'] ) ) $o_GSS_TipoCambioBN->setTipoCambioCobranza( ( float ) $a_GSS_TipoCambio['TipoCambioCobranza'] );
        if ( !is_null( $a_GSS_TipoCambio['Estado'] ) ) $o_GSS_TipoCambioBN->setEstado( $a_GSS_TipoCambio['Estado'] );
        if ( !is_null( $a_GSS_TipoCambio['FechaCreacion'] ) ) $o_GSS_TipoCambioBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_TipoCambio['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_TipoCambio['UsuarioCreacion'] ) ) $o_GSS_TipoCambioBN->setUsuarioCreacion( $a_GSS_TipoCambio['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_TipoCambio['FechaModificacion'] ) ) $o_GSS_TipoCambioBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_TipoCambio['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_TipoCambio['UsuarioModificacion'] ) ) $o_GSS_TipoCambioBN->setUsuarioModificacion( $a_GSS_TipoCambio['UsuarioModificacion'] );
        return $o_GSS_TipoCambioBN;
    }
}
?>