<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Detraccion.xml */
/* Generado: 2022-04-18 21:14:56 */

/* Busqueda de registros de la tabla GSS_Detraccion. */
abstract class BaseGSS_DetraccionFN extends GSS_DetraccionBN
{
    /* Declaracion de constantes */
    const IdDetraccion = "GSS_Detraccion.IdDetraccion";
    const Descripcion = "GSS_Detraccion.Descripcion";
    const CodigoSunat = "GSS_Detraccion.CodigoSunat";
    const CodigoSunatPr = "GSS_Detraccion.CodigoSunatPr";
    const Porcentaje = "GSS_Detraccion.Porcentaje";
    const MontoMinimo = "GSS_Detraccion.MontoMinimo";
    const Estado = "GSS_Detraccion.Estado";
    const UsuarioCreacion = "GSS_Detraccion.UsuarioCreacion";
    const FechaCreacion = "GSS_Detraccion.FechaCreacion";
    const FechaModificacion = "GSS_Detraccion.FechaModificacion";
    const UsuarioModificacion = "GSS_Detraccion.UsuarioModificacion";
    const FehaEliminacion = "GSS_Detraccion.FehaEliminacion";
    const UsuarioEliminacion = "GSS_Detraccion.UsuarioEliminacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_Detraccion.IdDetraccion AS IdDetraccion, ";
        $s_SQLQuery .= "GSS_Detraccion.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "GSS_Detraccion.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "GSS_Detraccion.CodigoSunatPr AS CodigoSunatPr, ";
        $s_SQLQuery .= "GSS_Detraccion.Porcentaje AS Porcentaje, ";
        $s_SQLQuery .= "GSS_Detraccion.MontoMinimo AS MontoMinimo, ";
        $s_SQLQuery .= "GSS_Detraccion.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_Detraccion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_Detraccion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_Detraccion.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_Detraccion.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "GSS_Detraccion.FehaEliminacion AS FehaEliminacion, ";
        $s_SQLQuery .= "GSS_Detraccion.UsuarioEliminacion AS UsuarioEliminacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_DetraccionBN */
    public function setByBN( GSS_DetraccionBN $o_GSS_DetraccionBN )
    {
        if ( !is_null( $o_GSS_DetraccionBN->getIdDetraccion() ) )
        {
            $this->setIdDetraccion( $o_GSS_DetraccionBN->getIdDetraccion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_DetraccionBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_DetraccionBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getCodigoSunatPr() ) )
        {
            $this->setCodigoSunatPr( $o_GSS_DetraccionBN->getCodigoSunatPr() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getPorcentaje() ) )
        {
            $this->setPorcentaje( $o_GSS_DetraccionBN->getPorcentaje() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getMontoMinimo() ) )
        {
            $this->setMontoMinimo( $o_GSS_DetraccionBN->getMontoMinimo() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_DetraccionBN->getEstado() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_DetraccionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_DetraccionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_DetraccionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_DetraccionBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getFehaEliminacion() ) )
        {
            $this->setFehaEliminacion( $o_GSS_DetraccionBN->getFehaEliminacion() );
        }
        if ( !is_null( $o_GSS_DetraccionBN->getUsuarioEliminacion() ) )
        {
            $this->setUsuarioEliminacion( $o_GSS_DetraccionBN->getUsuarioEliminacion() );
        }
    }

    /**
    * @return GSS_DetraccionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdDetraccion )
    {
        if( is_null( $i_IdDetraccion ) ){ $i_IdDetraccion = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Detraccion ";
        $s_SQLQuery .= "WHERE IdDetraccion = ".$i_IdDetraccion." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_GSS_DetraccionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_DetraccionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_DetraccionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdDetraccion() ) ) $s_SQLQuery .= "GSS_Detraccion.IdDetraccion = ".$this->getIdDetraccion()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "GSS_Detraccion.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "GSS_Detraccion.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getCodigoSunatPr() ) ) $s_SQLQuery .= "GSS_Detraccion.CodigoSunatPr = '".$this->getCodigoSunatPr()."' AND ";
        if ( !is_null( $this->getPorcentaje() ) ) $s_SQLQuery .= "GSS_Detraccion.Porcentaje = ".$this->getPorcentaje()." AND ";
        if ( !is_null( $this->getMontoMinimo() ) ) $s_SQLQuery .= "GSS_Detraccion.MontoMinimo = ".$this->getMontoMinimo()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_Detraccion.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_Detraccion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_Detraccion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_Detraccion.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_Detraccion.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFehaEliminacion() ) ) $s_SQLQuery .= "GSS_Detraccion.FehaEliminacion = '".$this->getFehaEliminacion()."' AND ";
        if ( !is_null( $this->getUsuarioEliminacion() ) ) $s_SQLQuery .= "GSS_Detraccion.UsuarioEliminacion = '".$this->getUsuarioEliminacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_Detraccion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_DetraccionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Detraccion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_GSS_DetraccionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_DetraccionBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_DetraccionBN[] = $o_GSS_DetraccionBN;
            }
        }
        return $a_GSS_DetraccionBN;
    }

    /* Devuelve un objeto GSS_DetraccionBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_Detraccion )
    {
        $o_GSS_DetraccionBN = new GSS_DetraccionBN();
        if ( !is_null( $a_GSS_Detraccion['IdDetraccion'] ) ) $o_GSS_DetraccionBN->setIdDetraccion( ( integer ) $a_GSS_Detraccion['IdDetraccion'] );
        if ( !is_null( $a_GSS_Detraccion['Descripcion'] ) ) $o_GSS_DetraccionBN->setDescripcion( $a_GSS_Detraccion['Descripcion'] );
        if ( !is_null( $a_GSS_Detraccion['CodigoSunat'] ) ) $o_GSS_DetraccionBN->setCodigoSunat( $a_GSS_Detraccion['CodigoSunat'] );
        if ( !is_null( $a_GSS_Detraccion['CodigoSunatPr'] ) ) $o_GSS_DetraccionBN->setCodigoSunatPr( $a_GSS_Detraccion['CodigoSunatPr'] );
        if ( !is_null( $a_GSS_Detraccion['Porcentaje'] ) ) $o_GSS_DetraccionBN->setPorcentaje( ( float ) $a_GSS_Detraccion['Porcentaje'] );
        if ( !is_null( $a_GSS_Detraccion['MontoMinimo'] ) ) $o_GSS_DetraccionBN->setMontoMinimo( ( float ) $a_GSS_Detraccion['MontoMinimo'] );
        if ( !is_null( $a_GSS_Detraccion['Estado'] ) ) $o_GSS_DetraccionBN->setEstado( $a_GSS_Detraccion['Estado'] );
        if ( !is_null( $a_GSS_Detraccion['UsuarioCreacion'] ) ) $o_GSS_DetraccionBN->setUsuarioCreacion( $a_GSS_Detraccion['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_Detraccion['FechaCreacion'] ) ) $o_GSS_DetraccionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_Detraccion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Detraccion['FechaModificacion'] ) ) $o_GSS_DetraccionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_Detraccion['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Detraccion['UsuarioModificacion'] ) ) $o_GSS_DetraccionBN->setUsuarioModificacion( $a_GSS_Detraccion['UsuarioModificacion'] );
        if ( !is_null( $a_GSS_Detraccion['FehaEliminacion'] ) ) $o_GSS_DetraccionBN->setFehaEliminacion( utilTimestamp::getTimestamp( $a_GSS_Detraccion['FehaEliminacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Detraccion['UsuarioEliminacion'] ) ) $o_GSS_DetraccionBN->setUsuarioEliminacion( $a_GSS_Detraccion['UsuarioEliminacion'] );
        return $o_GSS_DetraccionBN;
    }
}
?>