<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_Obligaciones.xml */
/* Generado: 2022-04-18 21:14:54 */

/* Busqueda de registros de la tabla CP_Obligaciones. */
abstract class BaseCP_ObligacionesFN extends CP_ObligacionesBN
{
    /* Declaracion de constantes */
    const ObligacionesId = "CP_Obligaciones.ObligacionesId";
    const IdCompania = "CP_Obligaciones.IdCompania";
    const IdSucursal = "CP_Obligaciones.IdSucursal";
    const IdTipoDocumento = "CP_Obligaciones.IdTipoDocumento";
    const Periodo = "CP_Obligaciones.Periodo";
    const FechaEmision = "CP_Obligaciones.FechaEmision";
    const FechaVencimiento = "CP_Obligaciones.FechaVencimiento";
    const FechaProgramacion = "CP_Obligaciones.FechaProgramacion";
    const DocumentoSerie = "CP_Obligaciones.DocumentoSerie";
    const DocumentoNumero = "CP_Obligaciones.DocumentoNumero";
    const DocumentoSerieNumero = "CP_Obligaciones.DocumentoSerieNumero";
    const NumeroOC = "CP_Obligaciones.NumeroOC";
    const ProveedorId = "CP_Obligaciones.ProveedorId";
    const ProveedorDocTipo = "CP_Obligaciones.ProveedorDocTipo";
    const ProveedorDocNum = "CP_Obligaciones.ProveedorDocNum";
    const ProveedorNombre = "CP_Obligaciones.ProveedorNombre";
    const IdProyecto = "CP_Obligaciones.IdProyecto";
    const ProyectoNombre = "CP_Obligaciones.ProyectoNombre";
    const Descripcion = "CP_Obligaciones.Descripcion";
    const TerminoId = "CP_Obligaciones.TerminoId";
    const MetodoPagoId = "CP_Obligaciones.MetodoPagoId";
    const IdMoneda = "CP_Obligaciones.IdMoneda";
    const TipoCambio = "CP_Obligaciones.TipoCambio";
    const AfectoIGV = "CP_Obligaciones.AfectoIGV";
    const MontoAfecto = "CP_Obligaciones.MontoAfecto";
    const MontoAfectoMN = "CP_Obligaciones.MontoAfectoMN";
    const MontoNoAfecto = "CP_Obligaciones.MontoNoAfecto";
    const MontoNoAfectoMN = "CP_Obligaciones.MontoNoAfectoMN";
    const MontoIGV = "CP_Obligaciones.MontoIGV";
    const MontoIGVMN = "CP_Obligaciones.MontoIGVMN";
    const MontoTotal = "CP_Obligaciones.MontoTotal";
    const MontoTotalMN = "CP_Obligaciones.MontoTotalMN";
    const MontoPagado = "CP_Obligaciones.MontoPagado";
    const MontoPagadoMN = "CP_Obligaciones.MontoPagadoMN";
    const MontoSaldo = "CP_Obligaciones.MontoSaldo";
    const MontoSaldoMN = "CP_Obligaciones.MontoSaldoMN";
    const ComprobanteRefId = "CP_Obligaciones.ComprobanteRefId";
    const ComprobanteTipoRefId = "CP_Obligaciones.ComprobanteTipoRefId";
    const ComprobanteSerieNumeroRef = "CP_Obligaciones.ComprobanteSerieNumeroRef";
    const ComprobanteFechaEmisionRef = "CP_Obligaciones.ComprobanteFechaEmisionRef";
    const Estado = "CP_Obligaciones.Estado";
    const EstadoPagado = "CP_Obligaciones.EstadoPagado";
    const FechaPago = "CP_Obligaciones.FechaPago";
    const UsuarioCreacion = "CP_Obligaciones.UsuarioCreacion";
    const FechaCreacion = "CP_Obligaciones.FechaCreacion";
    const UsuarioModificacion = "CP_Obligaciones.UsuarioModificacion";
    const FechaModificacion = "CP_Obligaciones.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CP_Obligaciones.ObligacionesId AS ObligacionesId, ";
        $s_SQLQuery .= "CP_Obligaciones.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "CP_Obligaciones.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "CP_Obligaciones.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "CP_Obligaciones.Periodo AS Periodo, ";
        $s_SQLQuery .= "CP_Obligaciones.FechaEmision AS FechaEmision, ";
        $s_SQLQuery .= "CP_Obligaciones.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "CP_Obligaciones.FechaProgramacion AS FechaProgramacion, ";
        $s_SQLQuery .= "CP_Obligaciones.DocumentoSerie AS DocumentoSerie, ";
        $s_SQLQuery .= "CP_Obligaciones.DocumentoNumero AS DocumentoNumero, ";
        $s_SQLQuery .= "CP_Obligaciones.DocumentoSerieNumero AS DocumentoSerieNumero, ";
        $s_SQLQuery .= "CP_Obligaciones.NumeroOC AS NumeroOC, ";
        $s_SQLQuery .= "CP_Obligaciones.ProveedorId AS ProveedorId, ";
        $s_SQLQuery .= "CP_Obligaciones.ProveedorDocTipo AS ProveedorDocTipo, ";
        $s_SQLQuery .= "CP_Obligaciones.ProveedorDocNum AS ProveedorDocNum, ";
        $s_SQLQuery .= "CP_Obligaciones.ProveedorNombre AS ProveedorNombre, ";
        $s_SQLQuery .= "CP_Obligaciones.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "CP_Obligaciones.ProyectoNombre AS ProyectoNombre, ";
        $s_SQLQuery .= "CP_Obligaciones.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CP_Obligaciones.TerminoId AS TerminoId, ";
        $s_SQLQuery .= "CP_Obligaciones.MetodoPagoId AS MetodoPagoId, ";
        $s_SQLQuery .= "CP_Obligaciones.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "CP_Obligaciones.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "CP_Obligaciones.AfectoIGV AS AfectoIGV, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoAfecto AS MontoAfecto, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoAfectoMN AS MontoAfectoMN, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoNoAfecto AS MontoNoAfecto, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoNoAfectoMN AS MontoNoAfectoMN, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoIGV AS MontoIGV, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoIGVMN AS MontoIGVMN, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoTotalMN AS MontoTotalMN, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoPagado AS MontoPagado, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoPagadoMN AS MontoPagadoMN, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoSaldo AS MontoSaldo, ";
        $s_SQLQuery .= "CP_Obligaciones.MontoSaldoMN AS MontoSaldoMN, ";
        $s_SQLQuery .= "CP_Obligaciones.ComprobanteRefId AS ComprobanteRefId, ";
        $s_SQLQuery .= "CP_Obligaciones.ComprobanteTipoRefId AS ComprobanteTipoRefId, ";
        $s_SQLQuery .= "CP_Obligaciones.ComprobanteSerieNumeroRef AS ComprobanteSerieNumeroRef, ";
        $s_SQLQuery .= "CP_Obligaciones.ComprobanteFechaEmisionRef AS ComprobanteFechaEmisionRef, ";
        $s_SQLQuery .= "CP_Obligaciones.Estado AS Estado, ";
        $s_SQLQuery .= "CP_Obligaciones.EstadoPagado AS EstadoPagado, ";
        $s_SQLQuery .= "CP_Obligaciones.FechaPago AS FechaPago, ";
        $s_SQLQuery .= "CP_Obligaciones.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CP_Obligaciones.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CP_Obligaciones.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "CP_Obligaciones.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CP_ObligacionesBN */
    public function setByBN( CP_ObligacionesBN $o_CP_ObligacionesBN )
    {
        if ( !is_null( $o_CP_ObligacionesBN->getObligacionesId() ) )
        {
            $this->setObligacionesId( $o_CP_ObligacionesBN->getObligacionesId() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_CP_ObligacionesBN->getIdCompania() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_CP_ObligacionesBN->getIdSucursal() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_CP_ObligacionesBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_CP_ObligacionesBN->getPeriodo() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getFechaEmision() ) )
        {
            $this->setFechaEmision( $o_CP_ObligacionesBN->getFechaEmision() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_CP_ObligacionesBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getFechaProgramacion() ) )
        {
            $this->setFechaProgramacion( $o_CP_ObligacionesBN->getFechaProgramacion() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getDocumentoSerie() ) )
        {
            $this->setDocumentoSerie( $o_CP_ObligacionesBN->getDocumentoSerie() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getDocumentoNumero() ) )
        {
            $this->setDocumentoNumero( $o_CP_ObligacionesBN->getDocumentoNumero() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getDocumentoSerieNumero() ) )
        {
            $this->setDocumentoSerieNumero( $o_CP_ObligacionesBN->getDocumentoSerieNumero() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getNumeroOC() ) )
        {
            $this->setNumeroOC( $o_CP_ObligacionesBN->getNumeroOC() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getProveedorId() ) )
        {
            $this->setProveedorId( $o_CP_ObligacionesBN->getProveedorId() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getProveedorDocTipo() ) )
        {
            $this->setProveedorDocTipo( $o_CP_ObligacionesBN->getProveedorDocTipo() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getProveedorDocNum() ) )
        {
            $this->setProveedorDocNum( $o_CP_ObligacionesBN->getProveedorDocNum() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getProveedorNombre() ) )
        {
            $this->setProveedorNombre( $o_CP_ObligacionesBN->getProveedorNombre() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_CP_ObligacionesBN->getIdProyecto() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getProyectoNombre() ) )
        {
            $this->setProyectoNombre( $o_CP_ObligacionesBN->getProyectoNombre() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CP_ObligacionesBN->getDescripcion() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getTerminoId() ) )
        {
            $this->setTerminoId( $o_CP_ObligacionesBN->getTerminoId() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMetodoPagoId() ) )
        {
            $this->setMetodoPagoId( $o_CP_ObligacionesBN->getMetodoPagoId() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_CP_ObligacionesBN->getIdMoneda() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_CP_ObligacionesBN->getTipoCambio() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getAfectoIGV() ) )
        {
            $this->setAfectoIGV( $o_CP_ObligacionesBN->getAfectoIGV() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoAfecto() ) )
        {
            $this->setMontoAfecto( $o_CP_ObligacionesBN->getMontoAfecto() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoAfectoMN() ) )
        {
            $this->setMontoAfectoMN( $o_CP_ObligacionesBN->getMontoAfectoMN() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoNoAfecto() ) )
        {
            $this->setMontoNoAfecto( $o_CP_ObligacionesBN->getMontoNoAfecto() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoNoAfectoMN() ) )
        {
            $this->setMontoNoAfectoMN( $o_CP_ObligacionesBN->getMontoNoAfectoMN() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoIGV() ) )
        {
            $this->setMontoIGV( $o_CP_ObligacionesBN->getMontoIGV() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoIGVMN() ) )
        {
            $this->setMontoIGVMN( $o_CP_ObligacionesBN->getMontoIGVMN() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_CP_ObligacionesBN->getMontoTotal() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoTotalMN() ) )
        {
            $this->setMontoTotalMN( $o_CP_ObligacionesBN->getMontoTotalMN() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoPagado() ) )
        {
            $this->setMontoPagado( $o_CP_ObligacionesBN->getMontoPagado() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoPagadoMN() ) )
        {
            $this->setMontoPagadoMN( $o_CP_ObligacionesBN->getMontoPagadoMN() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoSaldo() ) )
        {
            $this->setMontoSaldo( $o_CP_ObligacionesBN->getMontoSaldo() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getMontoSaldoMN() ) )
        {
            $this->setMontoSaldoMN( $o_CP_ObligacionesBN->getMontoSaldoMN() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getComprobanteRefId() ) )
        {
            $this->setComprobanteRefId( $o_CP_ObligacionesBN->getComprobanteRefId() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getComprobanteTipoRefId() ) )
        {
            $this->setComprobanteTipoRefId( $o_CP_ObligacionesBN->getComprobanteTipoRefId() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getComprobanteSerieNumeroRef() ) )
        {
            $this->setComprobanteSerieNumeroRef( $o_CP_ObligacionesBN->getComprobanteSerieNumeroRef() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getComprobanteFechaEmisionRef() ) )
        {
            $this->setComprobanteFechaEmisionRef( $o_CP_ObligacionesBN->getComprobanteFechaEmisionRef() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getEstado() ) )
        {
            $this->setEstado( $o_CP_ObligacionesBN->getEstado() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getEstadoPagado() ) )
        {
            $this->setEstadoPagado( $o_CP_ObligacionesBN->getEstadoPagado() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getFechaPago() ) )
        {
            $this->setFechaPago( $o_CP_ObligacionesBN->getFechaPago() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CP_ObligacionesBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CP_ObligacionesBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CP_ObligacionesBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_CP_ObligacionesBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CP_ObligacionesBN->getFechaModificacion() );
        }
    }

    /**
    * @return CP_ObligacionesBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_ObligacionesId )
    {
        if( is_null( $i_ObligacionesId ) ){ $i_ObligacionesId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_Obligaciones ";
        $s_SQLQuery .= "WHERE ObligacionesId = ".$i_ObligacionesId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CP_ObligacionesBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CP_ObligacionesBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CP_ObligacionesBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getObligacionesId() ) ) $s_SQLQuery .= "CP_Obligaciones.ObligacionesId = ".$this->getObligacionesId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "CP_Obligaciones.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "CP_Obligaciones.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "CP_Obligaciones.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "CP_Obligaciones.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getFechaEmision() ) ) $s_SQLQuery .= "CP_Obligaciones.FechaEmision = '".$this->getFechaEmision()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "CP_Obligaciones.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getFechaProgramacion() ) ) $s_SQLQuery .= "CP_Obligaciones.FechaProgramacion = '".$this->getFechaProgramacion()."' AND ";
        if ( !is_null( $this->getDocumentoSerie() ) ) $s_SQLQuery .= "CP_Obligaciones.DocumentoSerie = '".$this->getDocumentoSerie()."' AND ";
        if ( !is_null( $this->getDocumentoNumero() ) ) $s_SQLQuery .= "CP_Obligaciones.DocumentoNumero = '".$this->getDocumentoNumero()."' AND ";
        if ( !is_null( $this->getDocumentoSerieNumero() ) ) $s_SQLQuery .= "CP_Obligaciones.DocumentoSerieNumero = '".$this->getDocumentoSerieNumero()."' AND ";
        if ( !is_null( $this->getNumeroOC() ) ) $s_SQLQuery .= "CP_Obligaciones.NumeroOC = ".$this->getNumeroOC()." AND ";
        if ( !is_null( $this->getProveedorId() ) ) $s_SQLQuery .= "CP_Obligaciones.ProveedorId = ".$this->getProveedorId()." AND ";
        if ( !is_null( $this->getProveedorDocTipo() ) ) $s_SQLQuery .= "CP_Obligaciones.ProveedorDocTipo = '".$this->getProveedorDocTipo()."' AND ";
        if ( !is_null( $this->getProveedorDocNum() ) ) $s_SQLQuery .= "CP_Obligaciones.ProveedorDocNum = '".$this->getProveedorDocNum()."' AND ";
        if ( !is_null( $this->getProveedorNombre() ) ) $s_SQLQuery .= "CP_Obligaciones.ProveedorNombre = '".$this->getProveedorNombre()."' AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "CP_Obligaciones.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getProyectoNombre() ) ) $s_SQLQuery .= "CP_Obligaciones.ProyectoNombre = '".$this->getProyectoNombre()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CP_Obligaciones.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getTerminoId() ) ) $s_SQLQuery .= "CP_Obligaciones.TerminoId = ".$this->getTerminoId()." AND ";
        if ( !is_null( $this->getMetodoPagoId() ) ) $s_SQLQuery .= "CP_Obligaciones.MetodoPagoId = ".$this->getMetodoPagoId()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "CP_Obligaciones.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "CP_Obligaciones.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getAfectoIGV() ) ) $s_SQLQuery .= "CP_Obligaciones.AfectoIGV = ".$this->getAfectoIGV()." AND ";
        if ( !is_null( $this->getMontoAfecto() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoAfecto = ".$this->getMontoAfecto()." AND ";
        if ( !is_null( $this->getMontoAfectoMN() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoAfectoMN = ".$this->getMontoAfectoMN()." AND ";
        if ( !is_null( $this->getMontoNoAfecto() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoNoAfecto = ".$this->getMontoNoAfecto()." AND ";
        if ( !is_null( $this->getMontoNoAfectoMN() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoNoAfectoMN = ".$this->getMontoNoAfectoMN()." AND ";
        if ( !is_null( $this->getMontoIGV() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoIGV = ".$this->getMontoIGV()." AND ";
        if ( !is_null( $this->getMontoIGVMN() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoIGVMN = ".$this->getMontoIGVMN()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getMontoTotalMN() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoTotalMN = ".$this->getMontoTotalMN()." AND ";
        if ( !is_null( $this->getMontoPagado() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoPagado = ".$this->getMontoPagado()." AND ";
        if ( !is_null( $this->getMontoPagadoMN() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoPagadoMN = ".$this->getMontoPagadoMN()." AND ";
        if ( !is_null( $this->getMontoSaldo() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoSaldo = ".$this->getMontoSaldo()." AND ";
        if ( !is_null( $this->getMontoSaldoMN() ) ) $s_SQLQuery .= "CP_Obligaciones.MontoSaldoMN = ".$this->getMontoSaldoMN()." AND ";
        if ( !is_null( $this->getComprobanteRefId() ) ) $s_SQLQuery .= "CP_Obligaciones.ComprobanteRefId = ".$this->getComprobanteRefId()." AND ";
        if ( !is_null( $this->getComprobanteTipoRefId() ) ) $s_SQLQuery .= "CP_Obligaciones.ComprobanteTipoRefId = '".$this->getComprobanteTipoRefId()."' AND ";
        if ( !is_null( $this->getComprobanteSerieNumeroRef() ) ) $s_SQLQuery .= "CP_Obligaciones.ComprobanteSerieNumeroRef = '".$this->getComprobanteSerieNumeroRef()."' AND ";
        if ( !is_null( $this->getComprobanteFechaEmisionRef() ) ) $s_SQLQuery .= "CP_Obligaciones.ComprobanteFechaEmisionRef = '".$this->getComprobanteFechaEmisionRef()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CP_Obligaciones.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getEstadoPagado() ) ) $s_SQLQuery .= "CP_Obligaciones.EstadoPagado = '".$this->getEstadoPagado()."' AND ";
        if ( !is_null( $this->getFechaPago() ) ) $s_SQLQuery .= "CP_Obligaciones.FechaPago = '".$this->getFechaPago()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CP_Obligaciones.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CP_Obligaciones.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CP_Obligaciones.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CP_Obligaciones.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CP_Obligaciones WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CP_ObligacionesBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_Obligaciones WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CP_ObligacionesBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CP_ObligacionesBN = $this->insertObjectBN( $a_SQLRow );
                $a_CP_ObligacionesBN[] = $o_CP_ObligacionesBN;
            }
        }
        return $a_CP_ObligacionesBN;
    }

    /* Devuelve un objeto CP_ObligacionesBN desde un objeto propel */
    public function insertObjectBN( $a_CP_Obligaciones )
    {
        $o_CP_ObligacionesBN = new CP_ObligacionesBN();
        if ( !is_null( $a_CP_Obligaciones['ObligacionesId'] ) ) $o_CP_ObligacionesBN->setObligacionesId( ( integer ) $a_CP_Obligaciones['ObligacionesId'] );
        if ( !is_null( $a_CP_Obligaciones['IdCompania'] ) ) $o_CP_ObligacionesBN->setIdCompania( ( integer ) $a_CP_Obligaciones['IdCompania'] );
        if ( !is_null( $a_CP_Obligaciones['IdSucursal'] ) ) $o_CP_ObligacionesBN->setIdSucursal( ( integer ) $a_CP_Obligaciones['IdSucursal'] );
        if ( !is_null( $a_CP_Obligaciones['IdTipoDocumento'] ) ) $o_CP_ObligacionesBN->setIdTipoDocumento( $a_CP_Obligaciones['IdTipoDocumento'] );
        if ( !is_null( $a_CP_Obligaciones['Periodo'] ) ) $o_CP_ObligacionesBN->setPeriodo( $a_CP_Obligaciones['Periodo'] );
        if ( !is_null( $a_CP_Obligaciones['FechaEmision'] ) ) $o_CP_ObligacionesBN->setFechaEmision( utilTimestamp::getTimestamp( $a_CP_Obligaciones['FechaEmision'], "Y-m-d" ) );
        if ( !is_null( $a_CP_Obligaciones['FechaVencimiento'] ) ) $o_CP_ObligacionesBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_CP_Obligaciones['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_CP_Obligaciones['FechaProgramacion'] ) ) $o_CP_ObligacionesBN->setFechaProgramacion( utilTimestamp::getTimestamp( $a_CP_Obligaciones['FechaProgramacion'], "Y-m-d" ) );
        if ( !is_null( $a_CP_Obligaciones['DocumentoSerie'] ) ) $o_CP_ObligacionesBN->setDocumentoSerie( $a_CP_Obligaciones['DocumentoSerie'] );
        if ( !is_null( $a_CP_Obligaciones['DocumentoNumero'] ) ) $o_CP_ObligacionesBN->setDocumentoNumero( $a_CP_Obligaciones['DocumentoNumero'] );
        if ( !is_null( $a_CP_Obligaciones['DocumentoSerieNumero'] ) ) $o_CP_ObligacionesBN->setDocumentoSerieNumero( $a_CP_Obligaciones['DocumentoSerieNumero'] );
        if ( !is_null( $a_CP_Obligaciones['NumeroOC'] ) ) $o_CP_ObligacionesBN->setNumeroOC( ( integer ) $a_CP_Obligaciones['NumeroOC'] );
        if ( !is_null( $a_CP_Obligaciones['ProveedorId'] ) ) $o_CP_ObligacionesBN->setProveedorId( ( integer ) $a_CP_Obligaciones['ProveedorId'] );
        if ( !is_null( $a_CP_Obligaciones['ProveedorDocTipo'] ) ) $o_CP_ObligacionesBN->setProveedorDocTipo( $a_CP_Obligaciones['ProveedorDocTipo'] );
        if ( !is_null( $a_CP_Obligaciones['ProveedorDocNum'] ) ) $o_CP_ObligacionesBN->setProveedorDocNum( $a_CP_Obligaciones['ProveedorDocNum'] );
        if ( !is_null( $a_CP_Obligaciones['ProveedorNombre'] ) ) $o_CP_ObligacionesBN->setProveedorNombre( $a_CP_Obligaciones['ProveedorNombre'] );
        if ( !is_null( $a_CP_Obligaciones['IdProyecto'] ) ) $o_CP_ObligacionesBN->setIdProyecto( ( integer ) $a_CP_Obligaciones['IdProyecto'] );
        if ( !is_null( $a_CP_Obligaciones['ProyectoNombre'] ) ) $o_CP_ObligacionesBN->setProyectoNombre( $a_CP_Obligaciones['ProyectoNombre'] );
        if ( !is_null( $a_CP_Obligaciones['Descripcion'] ) ) $o_CP_ObligacionesBN->setDescripcion( $a_CP_Obligaciones['Descripcion'] );
        if ( !is_null( $a_CP_Obligaciones['TerminoId'] ) ) $o_CP_ObligacionesBN->setTerminoId( ( integer ) $a_CP_Obligaciones['TerminoId'] );
        if ( !is_null( $a_CP_Obligaciones['MetodoPagoId'] ) ) $o_CP_ObligacionesBN->setMetodoPagoId( ( integer ) $a_CP_Obligaciones['MetodoPagoId'] );
        if ( !is_null( $a_CP_Obligaciones['IdMoneda'] ) ) $o_CP_ObligacionesBN->setIdMoneda( $a_CP_Obligaciones['IdMoneda'] );
        if ( !is_null( $a_CP_Obligaciones['TipoCambio'] ) ) $o_CP_ObligacionesBN->setTipoCambio( ( float ) $a_CP_Obligaciones['TipoCambio'] );
        if ( !is_null( $a_CP_Obligaciones['AfectoIGV'] ) ) $o_CP_ObligacionesBN->setAfectoIGV( ( integer ) $a_CP_Obligaciones['AfectoIGV'] );
        if ( !is_null( $a_CP_Obligaciones['MontoAfecto'] ) ) $o_CP_ObligacionesBN->setMontoAfecto( ( float ) $a_CP_Obligaciones['MontoAfecto'] );
        if ( !is_null( $a_CP_Obligaciones['MontoAfectoMN'] ) ) $o_CP_ObligacionesBN->setMontoAfectoMN( ( float ) $a_CP_Obligaciones['MontoAfectoMN'] );
        if ( !is_null( $a_CP_Obligaciones['MontoNoAfecto'] ) ) $o_CP_ObligacionesBN->setMontoNoAfecto( ( float ) $a_CP_Obligaciones['MontoNoAfecto'] );
        if ( !is_null( $a_CP_Obligaciones['MontoNoAfectoMN'] ) ) $o_CP_ObligacionesBN->setMontoNoAfectoMN( ( float ) $a_CP_Obligaciones['MontoNoAfectoMN'] );
        if ( !is_null( $a_CP_Obligaciones['MontoIGV'] ) ) $o_CP_ObligacionesBN->setMontoIGV( ( float ) $a_CP_Obligaciones['MontoIGV'] );
        if ( !is_null( $a_CP_Obligaciones['MontoIGVMN'] ) ) $o_CP_ObligacionesBN->setMontoIGVMN( ( float ) $a_CP_Obligaciones['MontoIGVMN'] );
        if ( !is_null( $a_CP_Obligaciones['MontoTotal'] ) ) $o_CP_ObligacionesBN->setMontoTotal( ( float ) $a_CP_Obligaciones['MontoTotal'] );
        if ( !is_null( $a_CP_Obligaciones['MontoTotalMN'] ) ) $o_CP_ObligacionesBN->setMontoTotalMN( ( float ) $a_CP_Obligaciones['MontoTotalMN'] );
        if ( !is_null( $a_CP_Obligaciones['MontoPagado'] ) ) $o_CP_ObligacionesBN->setMontoPagado( ( float ) $a_CP_Obligaciones['MontoPagado'] );
        if ( !is_null( $a_CP_Obligaciones['MontoPagadoMN'] ) ) $o_CP_ObligacionesBN->setMontoPagadoMN( ( float ) $a_CP_Obligaciones['MontoPagadoMN'] );
        if ( !is_null( $a_CP_Obligaciones['MontoSaldo'] ) ) $o_CP_ObligacionesBN->setMontoSaldo( ( float ) $a_CP_Obligaciones['MontoSaldo'] );
        if ( !is_null( $a_CP_Obligaciones['MontoSaldoMN'] ) ) $o_CP_ObligacionesBN->setMontoSaldoMN( ( float ) $a_CP_Obligaciones['MontoSaldoMN'] );
        if ( !is_null( $a_CP_Obligaciones['ComprobanteRefId'] ) ) $o_CP_ObligacionesBN->setComprobanteRefId( ( integer ) $a_CP_Obligaciones['ComprobanteRefId'] );
        if ( !is_null( $a_CP_Obligaciones['ComprobanteTipoRefId'] ) ) $o_CP_ObligacionesBN->setComprobanteTipoRefId( $a_CP_Obligaciones['ComprobanteTipoRefId'] );
        if ( !is_null( $a_CP_Obligaciones['ComprobanteSerieNumeroRef'] ) ) $o_CP_ObligacionesBN->setComprobanteSerieNumeroRef( $a_CP_Obligaciones['ComprobanteSerieNumeroRef'] );
        if ( !is_null( $a_CP_Obligaciones['ComprobanteFechaEmisionRef'] ) ) $o_CP_ObligacionesBN->setComprobanteFechaEmisionRef( utilTimestamp::getTimestamp( $a_CP_Obligaciones['ComprobanteFechaEmisionRef'], "Y-m-d" ) );
        if ( !is_null( $a_CP_Obligaciones['Estado'] ) ) $o_CP_ObligacionesBN->setEstado( $a_CP_Obligaciones['Estado'] );
        if ( !is_null( $a_CP_Obligaciones['EstadoPagado'] ) ) $o_CP_ObligacionesBN->setEstadoPagado( $a_CP_Obligaciones['EstadoPagado'] );
        if ( !is_null( $a_CP_Obligaciones['FechaPago'] ) ) $o_CP_ObligacionesBN->setFechaPago( utilTimestamp::getTimestamp( $a_CP_Obligaciones['FechaPago'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_Obligaciones['UsuarioCreacion'] ) ) $o_CP_ObligacionesBN->setUsuarioCreacion( $a_CP_Obligaciones['UsuarioCreacion'] );
        if ( !is_null( $a_CP_Obligaciones['FechaCreacion'] ) ) $o_CP_ObligacionesBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CP_Obligaciones['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_Obligaciones['UsuarioModificacion'] ) ) $o_CP_ObligacionesBN->setUsuarioModificacion( $a_CP_Obligaciones['UsuarioModificacion'] );
        if ( !is_null( $a_CP_Obligaciones['FechaModificacion'] ) ) $o_CP_ObligacionesBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CP_Obligaciones['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_CP_ObligacionesBN;
    }
}
?>