<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_Aplicacion.xml */
/* Generado: 2022-04-18 21:14:53 */

/* Busqueda de registros de la tabla CP_Aplicacion. */
abstract class BaseCP_AplicacionFN extends CP_AplicacionBN
{
    /* Declaracion de constantes */
    const IdAplicacion = "CP_Aplicacion.IdAplicacion";
    const IdParent = "CP_Aplicacion.IdParent";
    const IdCompania = "CP_Aplicacion.IdCompania";
    const IdSucursal = "CP_Aplicacion.IdSucursal";
    const IdTipoPago = "CP_Aplicacion.IdTipoPago";
    const IdCaja = "CP_Aplicacion.IdCaja";
    const IdTurno = "CP_Aplicacion.IdTurno";
    const IdCierre = "CP_Aplicacion.IdCierre";
    const IdBanco = "CP_Aplicacion.IdBanco";
    const IdCuenta = "CP_Aplicacion.IdCuenta";
    const IdMoneda = "CP_Aplicacion.IdMoneda";
    const MonedaDes = "CP_Aplicacion.MonedaDes";
    const TipoCambio = "CP_Aplicacion.TipoCambio";
    const TipoPagoNombre = "CP_Aplicacion.TipoPagoNombre";
    const IdPersona = "CP_Aplicacion.IdPersona";
    const TipoDocCliente = "CP_Aplicacion.TipoDocCliente";
    const NumTipoDocCliente = "CP_Aplicacion.NumTipoDocCliente";
    const NombreCliente = "CP_Aplicacion.NombreCliente";
    const NombreTipo = "CP_Aplicacion.NombreTipo";
    const ClaseNombre = "CP_Aplicacion.ClaseNombre";
    const Descripcion = "CP_Aplicacion.Descripcion";
    const ReciboNumero = "CP_Aplicacion.ReciboNumero";
    const IdDocRecibo = "CP_Aplicacion.IdDocRecibo";
    const IdNumeroDocumento = "CP_Aplicacion.IdNumeroDocumento";
    const IdDocNumRef = "CP_Aplicacion.IdDocNumRef";
    const CodDocRef = "CP_Aplicacion.CodDocRef";
    const SerieNumeroDocRef = "CP_Aplicacion.SerieNumeroDocRef";
    const MontoTotalDocRef = "CP_Aplicacion.MontoTotalDocRef";
    const SaldoDocRef = "CP_Aplicacion.SaldoDocRef";
    const FechaDocRef = "CP_Aplicacion.FechaDocRef";
    const FechaDocVenRef = "CP_Aplicacion.FechaDocVenRef";
    const IdMonedaRef = "CP_Aplicacion.IdMonedaRef";
    const TipoCambioRef = "CP_Aplicacion.TipoCambioRef";
    const CodVendedorRef = "CP_Aplicacion.CodVendedorRef";
    const IdAlmacenRef = "CP_Aplicacion.IdAlmacenRef";
    const Periodo = "CP_Aplicacion.Periodo";
    const FechaAplicacion = "CP_Aplicacion.FechaAplicacion";
    const MontoAplicado = "CP_Aplicacion.MontoAplicado";
    const MontoAplicacionMN = "CP_Aplicacion.MontoAplicacionMN";
    const MontoAplicacionME = "CP_Aplicacion.MontoAplicacionME";
    const Mostrar = "CP_Aplicacion.Mostrar";
    const Estado = "CP_Aplicacion.Estado";
    const FechaCreacion = "CP_Aplicacion.FechaCreacion";
    const UsuarioCreacion = "CP_Aplicacion.UsuarioCreacion";
    const FechaModificacion = "CP_Aplicacion.FechaModificacion";
    const UsuarioModificacion = "CP_Aplicacion.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CP_Aplicacion.IdAplicacion AS IdAplicacion, ";
        $s_SQLQuery .= "CP_Aplicacion.IdParent AS IdParent, ";
        $s_SQLQuery .= "CP_Aplicacion.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "CP_Aplicacion.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "CP_Aplicacion.IdTipoPago AS IdTipoPago, ";
        $s_SQLQuery .= "CP_Aplicacion.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "CP_Aplicacion.IdTurno AS IdTurno, ";
        $s_SQLQuery .= "CP_Aplicacion.IdCierre AS IdCierre, ";
        $s_SQLQuery .= "CP_Aplicacion.IdBanco AS IdBanco, ";
        $s_SQLQuery .= "CP_Aplicacion.IdCuenta AS IdCuenta, ";
        $s_SQLQuery .= "CP_Aplicacion.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "CP_Aplicacion.MonedaDes AS MonedaDes, ";
        $s_SQLQuery .= "CP_Aplicacion.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "CP_Aplicacion.TipoPagoNombre AS TipoPagoNombre, ";
        $s_SQLQuery .= "CP_Aplicacion.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "CP_Aplicacion.TipoDocCliente AS TipoDocCliente, ";
        $s_SQLQuery .= "CP_Aplicacion.NumTipoDocCliente AS NumTipoDocCliente, ";
        $s_SQLQuery .= "CP_Aplicacion.NombreCliente AS NombreCliente, ";
        $s_SQLQuery .= "CP_Aplicacion.NombreTipo AS NombreTipo, ";
        $s_SQLQuery .= "CP_Aplicacion.ClaseNombre AS ClaseNombre, ";
        $s_SQLQuery .= "CP_Aplicacion.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CP_Aplicacion.ReciboNumero AS ReciboNumero, ";
        $s_SQLQuery .= "CP_Aplicacion.IdDocRecibo AS IdDocRecibo, ";
        $s_SQLQuery .= "CP_Aplicacion.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "CP_Aplicacion.IdDocNumRef AS IdDocNumRef, ";
        $s_SQLQuery .= "CP_Aplicacion.CodDocRef AS CodDocRef, ";
        $s_SQLQuery .= "CP_Aplicacion.SerieNumeroDocRef AS SerieNumeroDocRef, ";
        $s_SQLQuery .= "CP_Aplicacion.MontoTotalDocRef AS MontoTotalDocRef, ";
        $s_SQLQuery .= "CP_Aplicacion.SaldoDocRef AS SaldoDocRef, ";
        $s_SQLQuery .= "CP_Aplicacion.FechaDocRef AS FechaDocRef, ";
        $s_SQLQuery .= "CP_Aplicacion.FechaDocVenRef AS FechaDocVenRef, ";
        $s_SQLQuery .= "CP_Aplicacion.IdMonedaRef AS IdMonedaRef, ";
        $s_SQLQuery .= "CP_Aplicacion.TipoCambioRef AS TipoCambioRef, ";
        $s_SQLQuery .= "CP_Aplicacion.CodVendedorRef AS CodVendedorRef, ";
        $s_SQLQuery .= "CP_Aplicacion.IdAlmacenRef AS IdAlmacenRef, ";
        $s_SQLQuery .= "CP_Aplicacion.Periodo AS Periodo, ";
        $s_SQLQuery .= "CP_Aplicacion.FechaAplicacion AS FechaAplicacion, ";
        $s_SQLQuery .= "CP_Aplicacion.MontoAplicado AS MontoAplicado, ";
        $s_SQLQuery .= "CP_Aplicacion.MontoAplicacionMN AS MontoAplicacionMN, ";
        $s_SQLQuery .= "CP_Aplicacion.MontoAplicacionME AS MontoAplicacionME, ";
        $s_SQLQuery .= "CP_Aplicacion.Mostrar AS Mostrar, ";
        $s_SQLQuery .= "CP_Aplicacion.Estado AS Estado, ";
        $s_SQLQuery .= "CP_Aplicacion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CP_Aplicacion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CP_Aplicacion.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "CP_Aplicacion.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CP_AplicacionBN */
    public function setByBN( CP_AplicacionBN $o_CP_AplicacionBN )
    {
        if ( !is_null( $o_CP_AplicacionBN->getIdAplicacion() ) )
        {
            $this->setIdAplicacion( $o_CP_AplicacionBN->getIdAplicacion() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdParent() ) )
        {
            $this->setIdParent( $o_CP_AplicacionBN->getIdParent() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_CP_AplicacionBN->getIdCompania() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_CP_AplicacionBN->getIdSucursal() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdTipoPago() ) )
        {
            $this->setIdTipoPago( $o_CP_AplicacionBN->getIdTipoPago() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_CP_AplicacionBN->getIdCaja() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_CP_AplicacionBN->getIdTurno() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_CP_AplicacionBN->getIdCierre() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdBanco() ) )
        {
            $this->setIdBanco( $o_CP_AplicacionBN->getIdBanco() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdCuenta() ) )
        {
            $this->setIdCuenta( $o_CP_AplicacionBN->getIdCuenta() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_CP_AplicacionBN->getIdMoneda() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getMonedaDes() ) )
        {
            $this->setMonedaDes( $o_CP_AplicacionBN->getMonedaDes() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_CP_AplicacionBN->getTipoCambio() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getTipoPagoNombre() ) )
        {
            $this->setTipoPagoNombre( $o_CP_AplicacionBN->getTipoPagoNombre() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_CP_AplicacionBN->getIdPersona() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getTipoDocCliente() ) )
        {
            $this->setTipoDocCliente( $o_CP_AplicacionBN->getTipoDocCliente() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getNumTipoDocCliente() ) )
        {
            $this->setNumTipoDocCliente( $o_CP_AplicacionBN->getNumTipoDocCliente() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getNombreCliente() ) )
        {
            $this->setNombreCliente( $o_CP_AplicacionBN->getNombreCliente() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getNombreTipo() ) )
        {
            $this->setNombreTipo( $o_CP_AplicacionBN->getNombreTipo() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getClaseNombre() ) )
        {
            $this->setClaseNombre( $o_CP_AplicacionBN->getClaseNombre() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CP_AplicacionBN->getDescripcion() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getReciboNumero() ) )
        {
            $this->setReciboNumero( $o_CP_AplicacionBN->getReciboNumero() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_CP_AplicacionBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_CP_AplicacionBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdDocNumRef() ) )
        {
            $this->setIdDocNumRef( $o_CP_AplicacionBN->getIdDocNumRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getCodDocRef() ) )
        {
            $this->setCodDocRef( $o_CP_AplicacionBN->getCodDocRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getSerieNumeroDocRef() ) )
        {
            $this->setSerieNumeroDocRef( $o_CP_AplicacionBN->getSerieNumeroDocRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getMontoTotalDocRef() ) )
        {
            $this->setMontoTotalDocRef( $o_CP_AplicacionBN->getMontoTotalDocRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getSaldoDocRef() ) )
        {
            $this->setSaldoDocRef( $o_CP_AplicacionBN->getSaldoDocRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getFechaDocRef() ) )
        {
            $this->setFechaDocRef( $o_CP_AplicacionBN->getFechaDocRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getFechaDocVenRef() ) )
        {
            $this->setFechaDocVenRef( $o_CP_AplicacionBN->getFechaDocVenRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdMonedaRef() ) )
        {
            $this->setIdMonedaRef( $o_CP_AplicacionBN->getIdMonedaRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getTipoCambioRef() ) )
        {
            $this->setTipoCambioRef( $o_CP_AplicacionBN->getTipoCambioRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getCodVendedorRef() ) )
        {
            $this->setCodVendedorRef( $o_CP_AplicacionBN->getCodVendedorRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getIdAlmacenRef() ) )
        {
            $this->setIdAlmacenRef( $o_CP_AplicacionBN->getIdAlmacenRef() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_CP_AplicacionBN->getPeriodo() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getFechaAplicacion() ) )
        {
            $this->setFechaAplicacion( $o_CP_AplicacionBN->getFechaAplicacion() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getMontoAplicado() ) )
        {
            $this->setMontoAplicado( $o_CP_AplicacionBN->getMontoAplicado() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getMontoAplicacionMN() ) )
        {
            $this->setMontoAplicacionMN( $o_CP_AplicacionBN->getMontoAplicacionMN() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getMontoAplicacionME() ) )
        {
            $this->setMontoAplicacionME( $o_CP_AplicacionBN->getMontoAplicacionME() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getMostrar() ) )
        {
            $this->setMostrar( $o_CP_AplicacionBN->getMostrar() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getEstado() ) )
        {
            $this->setEstado( $o_CP_AplicacionBN->getEstado() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CP_AplicacionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CP_AplicacionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CP_AplicacionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_CP_AplicacionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CP_AplicacionBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return CP_AplicacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdAplicacion )
    {
        if( is_null( $i_IdAplicacion ) ){ $i_IdAplicacion = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_Aplicacion ";
        $s_SQLQuery .= "WHERE IdAplicacion = ".$i_IdAplicacion." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CP_AplicacionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CP_AplicacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CP_AplicacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdAplicacion() ) ) $s_SQLQuery .= "CP_Aplicacion.IdAplicacion = ".$this->getIdAplicacion()." AND ";
        if ( !is_null( $this->getIdParent() ) ) $s_SQLQuery .= "CP_Aplicacion.IdParent = ".$this->getIdParent()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "CP_Aplicacion.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "CP_Aplicacion.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdTipoPago() ) ) $s_SQLQuery .= "CP_Aplicacion.IdTipoPago = ".$this->getIdTipoPago()." AND ";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "CP_Aplicacion.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getIdTurno() ) ) $s_SQLQuery .= "CP_Aplicacion.IdTurno = ".$this->getIdTurno()." AND ";
        if ( !is_null( $this->getIdCierre() ) ) $s_SQLQuery .= "CP_Aplicacion.IdCierre = ".$this->getIdCierre()." AND ";
        if ( !is_null( $this->getIdBanco() ) ) $s_SQLQuery .= "CP_Aplicacion.IdBanco = ".$this->getIdBanco()." AND ";
        if ( !is_null( $this->getIdCuenta() ) ) $s_SQLQuery .= "CP_Aplicacion.IdCuenta = ".$this->getIdCuenta()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "CP_Aplicacion.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getMonedaDes() ) ) $s_SQLQuery .= "CP_Aplicacion.MonedaDes = '".$this->getMonedaDes()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "CP_Aplicacion.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getTipoPagoNombre() ) ) $s_SQLQuery .= "CP_Aplicacion.TipoPagoNombre = '".$this->getTipoPagoNombre()."' AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "CP_Aplicacion.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getTipoDocCliente() ) ) $s_SQLQuery .= "CP_Aplicacion.TipoDocCliente = '".$this->getTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNumTipoDocCliente() ) ) $s_SQLQuery .= "CP_Aplicacion.NumTipoDocCliente = '".$this->getNumTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNombreCliente() ) ) $s_SQLQuery .= "CP_Aplicacion.NombreCliente = '".$this->getNombreCliente()."' AND ";
        if ( !is_null( $this->getNombreTipo() ) ) $s_SQLQuery .= "CP_Aplicacion.NombreTipo = '".$this->getNombreTipo()."' AND ";
        if ( !is_null( $this->getClaseNombre() ) ) $s_SQLQuery .= "CP_Aplicacion.ClaseNombre = '".$this->getClaseNombre()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CP_Aplicacion.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getReciboNumero() ) ) $s_SQLQuery .= "CP_Aplicacion.ReciboNumero = '".$this->getReciboNumero()."' AND ";
        if ( !is_null( $this->getIdDocRecibo() ) ) $s_SQLQuery .= "CP_Aplicacion.IdDocRecibo = ".$this->getIdDocRecibo()." AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "CP_Aplicacion.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdDocNumRef() ) ) $s_SQLQuery .= "CP_Aplicacion.IdDocNumRef = '".$this->getIdDocNumRef()."' AND ";
        if ( !is_null( $this->getCodDocRef() ) ) $s_SQLQuery .= "CP_Aplicacion.CodDocRef = '".$this->getCodDocRef()."' AND ";
        if ( !is_null( $this->getSerieNumeroDocRef() ) ) $s_SQLQuery .= "CP_Aplicacion.SerieNumeroDocRef = '".$this->getSerieNumeroDocRef()."' AND ";
        if ( !is_null( $this->getMontoTotalDocRef() ) ) $s_SQLQuery .= "CP_Aplicacion.MontoTotalDocRef = ".$this->getMontoTotalDocRef()." AND ";
        if ( !is_null( $this->getSaldoDocRef() ) ) $s_SQLQuery .= "CP_Aplicacion.SaldoDocRef = ".$this->getSaldoDocRef()." AND ";
        if ( !is_null( $this->getFechaDocRef() ) ) $s_SQLQuery .= "CP_Aplicacion.FechaDocRef = '".$this->getFechaDocRef()."' AND ";
        if ( !is_null( $this->getFechaDocVenRef() ) ) $s_SQLQuery .= "CP_Aplicacion.FechaDocVenRef = '".$this->getFechaDocVenRef()."' AND ";
        if ( !is_null( $this->getIdMonedaRef() ) ) $s_SQLQuery .= "CP_Aplicacion.IdMonedaRef = '".$this->getIdMonedaRef()."' AND ";
        if ( !is_null( $this->getTipoCambioRef() ) ) $s_SQLQuery .= "CP_Aplicacion.TipoCambioRef = ".$this->getTipoCambioRef()." AND ";
        if ( !is_null( $this->getCodVendedorRef() ) ) $s_SQLQuery .= "CP_Aplicacion.CodVendedorRef = '".$this->getCodVendedorRef()."' AND ";
        if ( !is_null( $this->getIdAlmacenRef() ) ) $s_SQLQuery .= "CP_Aplicacion.IdAlmacenRef = '".$this->getIdAlmacenRef()."' AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "CP_Aplicacion.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getFechaAplicacion() ) ) $s_SQLQuery .= "CP_Aplicacion.FechaAplicacion = '".$this->getFechaAplicacion()."' AND ";
        if ( !is_null( $this->getMontoAplicado() ) ) $s_SQLQuery .= "CP_Aplicacion.MontoAplicado = ".$this->getMontoAplicado()." AND ";
        if ( !is_null( $this->getMontoAplicacionMN() ) ) $s_SQLQuery .= "CP_Aplicacion.MontoAplicacionMN = ".$this->getMontoAplicacionMN()." AND ";
        if ( !is_null( $this->getMontoAplicacionME() ) ) $s_SQLQuery .= "CP_Aplicacion.MontoAplicacionME = ".$this->getMontoAplicacionME()." AND ";
        if ( !is_null( $this->getMostrar() ) ) $s_SQLQuery .= "CP_Aplicacion.Mostrar = '".$this->getMostrar()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CP_Aplicacion.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CP_Aplicacion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CP_Aplicacion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CP_Aplicacion.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CP_Aplicacion.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CP_Aplicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CP_AplicacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_Aplicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CP_AplicacionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CP_AplicacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_CP_AplicacionBN[] = $o_CP_AplicacionBN;
            }
        }
        return $a_CP_AplicacionBN;
    }

    /* Devuelve un objeto CP_AplicacionBN desde un objeto propel */
    public function insertObjectBN( $a_CP_Aplicacion )
    {
        $o_CP_AplicacionBN = new CP_AplicacionBN();
        if ( !is_null( $a_CP_Aplicacion['IdAplicacion'] ) ) $o_CP_AplicacionBN->setIdAplicacion( ( integer ) $a_CP_Aplicacion['IdAplicacion'] );
        if ( !is_null( $a_CP_Aplicacion['IdParent'] ) ) $o_CP_AplicacionBN->setIdParent( ( integer ) $a_CP_Aplicacion['IdParent'] );
        if ( !is_null( $a_CP_Aplicacion['IdCompania'] ) ) $o_CP_AplicacionBN->setIdCompania( ( integer ) $a_CP_Aplicacion['IdCompania'] );
        if ( !is_null( $a_CP_Aplicacion['IdSucursal'] ) ) $o_CP_AplicacionBN->setIdSucursal( ( integer ) $a_CP_Aplicacion['IdSucursal'] );
        if ( !is_null( $a_CP_Aplicacion['IdTipoPago'] ) ) $o_CP_AplicacionBN->setIdTipoPago( ( integer ) $a_CP_Aplicacion['IdTipoPago'] );
        if ( !is_null( $a_CP_Aplicacion['IdCaja'] ) ) $o_CP_AplicacionBN->setIdCaja( ( integer ) $a_CP_Aplicacion['IdCaja'] );
        if ( !is_null( $a_CP_Aplicacion['IdTurno'] ) ) $o_CP_AplicacionBN->setIdTurno( ( integer ) $a_CP_Aplicacion['IdTurno'] );
        if ( !is_null( $a_CP_Aplicacion['IdCierre'] ) ) $o_CP_AplicacionBN->setIdCierre( ( integer ) $a_CP_Aplicacion['IdCierre'] );
        if ( !is_null( $a_CP_Aplicacion['IdBanco'] ) ) $o_CP_AplicacionBN->setIdBanco( ( integer ) $a_CP_Aplicacion['IdBanco'] );
        if ( !is_null( $a_CP_Aplicacion['IdCuenta'] ) ) $o_CP_AplicacionBN->setIdCuenta( ( integer ) $a_CP_Aplicacion['IdCuenta'] );
        if ( !is_null( $a_CP_Aplicacion['IdMoneda'] ) ) $o_CP_AplicacionBN->setIdMoneda( $a_CP_Aplicacion['IdMoneda'] );
        if ( !is_null( $a_CP_Aplicacion['MonedaDes'] ) ) $o_CP_AplicacionBN->setMonedaDes( $a_CP_Aplicacion['MonedaDes'] );
        if ( !is_null( $a_CP_Aplicacion['TipoCambio'] ) ) $o_CP_AplicacionBN->setTipoCambio( ( float ) $a_CP_Aplicacion['TipoCambio'] );
        if ( !is_null( $a_CP_Aplicacion['TipoPagoNombre'] ) ) $o_CP_AplicacionBN->setTipoPagoNombre( $a_CP_Aplicacion['TipoPagoNombre'] );
        if ( !is_null( $a_CP_Aplicacion['IdPersona'] ) ) $o_CP_AplicacionBN->setIdPersona( ( integer ) $a_CP_Aplicacion['IdPersona'] );
        if ( !is_null( $a_CP_Aplicacion['TipoDocCliente'] ) ) $o_CP_AplicacionBN->setTipoDocCliente( $a_CP_Aplicacion['TipoDocCliente'] );
        if ( !is_null( $a_CP_Aplicacion['NumTipoDocCliente'] ) ) $o_CP_AplicacionBN->setNumTipoDocCliente( $a_CP_Aplicacion['NumTipoDocCliente'] );
        if ( !is_null( $a_CP_Aplicacion['NombreCliente'] ) ) $o_CP_AplicacionBN->setNombreCliente( $a_CP_Aplicacion['NombreCliente'] );
        if ( !is_null( $a_CP_Aplicacion['NombreTipo'] ) ) $o_CP_AplicacionBN->setNombreTipo( $a_CP_Aplicacion['NombreTipo'] );
        if ( !is_null( $a_CP_Aplicacion['ClaseNombre'] ) ) $o_CP_AplicacionBN->setClaseNombre( $a_CP_Aplicacion['ClaseNombre'] );
        if ( !is_null( $a_CP_Aplicacion['Descripcion'] ) ) $o_CP_AplicacionBN->setDescripcion( $a_CP_Aplicacion['Descripcion'] );
        if ( !is_null( $a_CP_Aplicacion['ReciboNumero'] ) ) $o_CP_AplicacionBN->setReciboNumero( $a_CP_Aplicacion['ReciboNumero'] );
        if ( !is_null( $a_CP_Aplicacion['IdDocRecibo'] ) ) $o_CP_AplicacionBN->setIdDocRecibo( ( integer ) $a_CP_Aplicacion['IdDocRecibo'] );
        if ( !is_null( $a_CP_Aplicacion['IdNumeroDocumento'] ) ) $o_CP_AplicacionBN->setIdNumeroDocumento( $a_CP_Aplicacion['IdNumeroDocumento'] );
        if ( !is_null( $a_CP_Aplicacion['IdDocNumRef'] ) ) $o_CP_AplicacionBN->setIdDocNumRef( $a_CP_Aplicacion['IdDocNumRef'] );
        if ( !is_null( $a_CP_Aplicacion['CodDocRef'] ) ) $o_CP_AplicacionBN->setCodDocRef( $a_CP_Aplicacion['CodDocRef'] );
        if ( !is_null( $a_CP_Aplicacion['SerieNumeroDocRef'] ) ) $o_CP_AplicacionBN->setSerieNumeroDocRef( $a_CP_Aplicacion['SerieNumeroDocRef'] );
        if ( !is_null( $a_CP_Aplicacion['MontoTotalDocRef'] ) ) $o_CP_AplicacionBN->setMontoTotalDocRef( ( float ) $a_CP_Aplicacion['MontoTotalDocRef'] );
        if ( !is_null( $a_CP_Aplicacion['SaldoDocRef'] ) ) $o_CP_AplicacionBN->setSaldoDocRef( ( float ) $a_CP_Aplicacion['SaldoDocRef'] );
        if ( !is_null( $a_CP_Aplicacion['FechaDocRef'] ) ) $o_CP_AplicacionBN->setFechaDocRef( utilTimestamp::getTimestamp( $a_CP_Aplicacion['FechaDocRef'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_Aplicacion['FechaDocVenRef'] ) ) $o_CP_AplicacionBN->setFechaDocVenRef( utilTimestamp::getTimestamp( $a_CP_Aplicacion['FechaDocVenRef'], "Y-m-d" ) );
        if ( !is_null( $a_CP_Aplicacion['IdMonedaRef'] ) ) $o_CP_AplicacionBN->setIdMonedaRef( $a_CP_Aplicacion['IdMonedaRef'] );
        if ( !is_null( $a_CP_Aplicacion['TipoCambioRef'] ) ) $o_CP_AplicacionBN->setTipoCambioRef( ( float ) $a_CP_Aplicacion['TipoCambioRef'] );
        if ( !is_null( $a_CP_Aplicacion['CodVendedorRef'] ) ) $o_CP_AplicacionBN->setCodVendedorRef( $a_CP_Aplicacion['CodVendedorRef'] );
        if ( !is_null( $a_CP_Aplicacion['IdAlmacenRef'] ) ) $o_CP_AplicacionBN->setIdAlmacenRef( $a_CP_Aplicacion['IdAlmacenRef'] );
        if ( !is_null( $a_CP_Aplicacion['Periodo'] ) ) $o_CP_AplicacionBN->setPeriodo( $a_CP_Aplicacion['Periodo'] );
        if ( !is_null( $a_CP_Aplicacion['FechaAplicacion'] ) ) $o_CP_AplicacionBN->setFechaAplicacion( utilTimestamp::getTimestamp( $a_CP_Aplicacion['FechaAplicacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_Aplicacion['MontoAplicado'] ) ) $o_CP_AplicacionBN->setMontoAplicado( ( float ) $a_CP_Aplicacion['MontoAplicado'] );
        if ( !is_null( $a_CP_Aplicacion['MontoAplicacionMN'] ) ) $o_CP_AplicacionBN->setMontoAplicacionMN( ( float ) $a_CP_Aplicacion['MontoAplicacionMN'] );
        if ( !is_null( $a_CP_Aplicacion['MontoAplicacionME'] ) ) $o_CP_AplicacionBN->setMontoAplicacionME( ( float ) $a_CP_Aplicacion['MontoAplicacionME'] );
        if ( !is_null( $a_CP_Aplicacion['Mostrar'] ) ) $o_CP_AplicacionBN->setMostrar( $a_CP_Aplicacion['Mostrar'] );
        if ( !is_null( $a_CP_Aplicacion['Estado'] ) ) $o_CP_AplicacionBN->setEstado( $a_CP_Aplicacion['Estado'] );
        if ( !is_null( $a_CP_Aplicacion['FechaCreacion'] ) ) $o_CP_AplicacionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CP_Aplicacion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_Aplicacion['UsuarioCreacion'] ) ) $o_CP_AplicacionBN->setUsuarioCreacion( $a_CP_Aplicacion['UsuarioCreacion'] );
        if ( !is_null( $a_CP_Aplicacion['FechaModificacion'] ) ) $o_CP_AplicacionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CP_Aplicacion['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_Aplicacion['UsuarioModificacion'] ) ) $o_CP_AplicacionBN->setUsuarioModificacion( $a_CP_Aplicacion['UsuarioModificacion'] );
        return $o_CP_AplicacionBN;
    }
}
?>