<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CAR_VehiculoMarca.xml */
/* Generado: 2024-12-31 05:19:00 */

/* Busqueda de registros de la tabla CAR_VehiculoMarca. */
abstract class BaseCAR_VehiculoMarcaFN extends CAR_VehiculoMarcaBN
{
    /* Declaracion de constantes */
    const IdVehiculoMarca = "CAR_VehiculoMarca.IdVehiculoMarca";
    const Descripcion = "CAR_VehiculoMarca.Descripcion";
    const Codigo = "CAR_VehiculoMarca.Codigo";
    const Estado = "CAR_VehiculoMarca.Estado";
    const Eliminado = "CAR_VehiculoMarca.Eliminado";
    const FechaCreacion = "CAR_VehiculoMarca.FechaCreacion";
    const UsuarioCreacion = "CAR_VehiculoMarca.UsuarioCreacion";
    const FechaEliminado = "CAR_VehiculoMarca.FechaEliminado";
    const UsuarioEliminado = "CAR_VehiculoMarca.UsuarioEliminado";
    const UsuarioModificacion = "CAR_VehiculoMarca.UsuarioModificacion";
    const FechaModificacion = "CAR_VehiculoMarca.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CAR_VehiculoMarca.IdVehiculoMarca AS IdVehiculoMarca, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.Codigo AS Codigo, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.Estado AS Estado, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.Eliminado AS Eliminado, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.FechaEliminado AS FechaEliminado, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.UsuarioEliminado AS UsuarioEliminado, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "CAR_VehiculoMarca.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CAR_VehiculoMarcaBN */
    public function setByBN( CAR_VehiculoMarcaBN $o_CAR_VehiculoMarcaBN )
    {
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getIdVehiculoMarca() ) )
        {
            $this->setIdVehiculoMarca( $o_CAR_VehiculoMarcaBN->getIdVehiculoMarca() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CAR_VehiculoMarcaBN->getDescripcion() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_CAR_VehiculoMarcaBN->getCodigo() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getEstado() ) )
        {
            $this->setEstado( $o_CAR_VehiculoMarcaBN->getEstado() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getEliminado() ) )
        {
            $this->setEliminado( $o_CAR_VehiculoMarcaBN->getEliminado() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CAR_VehiculoMarcaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CAR_VehiculoMarcaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_CAR_VehiculoMarcaBN->getFechaEliminado() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_CAR_VehiculoMarcaBN->getUsuarioEliminado() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CAR_VehiculoMarcaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_CAR_VehiculoMarcaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CAR_VehiculoMarcaBN->getFechaModificacion() );
        }
    }

    /**
    * @return CAR_VehiculoMarcaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdVehiculoMarca )
    {
        if( is_null( $i_IdVehiculoMarca ) ){ $i_IdVehiculoMarca = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_VehiculoMarca ";
        $s_SQLQuery .= "WHERE IdVehiculoMarca = ".$i_IdVehiculoMarca." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CAR_VehiculoMarcaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CAR_VehiculoMarcaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CAR_VehiculoMarcaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdVehiculoMarca() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.IdVehiculoMarca = ".$this->getIdVehiculoMarca()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getEliminado() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.Eliminado = ".$this->getEliminado()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaEliminado() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.FechaEliminado = '".$this->getFechaEliminado()."' AND ";
        if ( !is_null( $this->getUsuarioEliminado() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.UsuarioEliminado = '".$this->getUsuarioEliminado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CAR_VehiculoMarca.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CAR_VehiculoMarca WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CAR_VehiculoMarcaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_VehiculoMarca WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CAR_VehiculoMarcaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CAR_VehiculoMarcaBN = $this->insertObjectBN( $a_SQLRow );
                $a_CAR_VehiculoMarcaBN[] = $o_CAR_VehiculoMarcaBN;
            }
        }
        return $a_CAR_VehiculoMarcaBN;
    }

    /* Devuelve un objeto CAR_VehiculoMarcaBN desde un objeto propel */
    public function insertObjectBN( $a_CAR_VehiculoMarca )
    {
        $o_CAR_VehiculoMarcaBN = new CAR_VehiculoMarcaBN();
        if ( !is_null( $a_CAR_VehiculoMarca['IdVehiculoMarca'] ) ) $o_CAR_VehiculoMarcaBN->setIdVehiculoMarca( ( integer ) $a_CAR_VehiculoMarca['IdVehiculoMarca'] );
        if ( !is_null( $a_CAR_VehiculoMarca['Descripcion'] ) ) $o_CAR_VehiculoMarcaBN->setDescripcion( $a_CAR_VehiculoMarca['Descripcion'] );
        if ( !is_null( $a_CAR_VehiculoMarca['Codigo'] ) ) $o_CAR_VehiculoMarcaBN->setCodigo( $a_CAR_VehiculoMarca['Codigo'] );
        if ( !is_null( $a_CAR_VehiculoMarca['Estado'] ) ) $o_CAR_VehiculoMarcaBN->setEstado( $a_CAR_VehiculoMarca['Estado'] );
        if ( !is_null( $a_CAR_VehiculoMarca['Eliminado'] ) ) $o_CAR_VehiculoMarcaBN->setEliminado( ( integer ) $a_CAR_VehiculoMarca['Eliminado'] );
        if ( !is_null( $a_CAR_VehiculoMarca['FechaCreacion'] ) ) $o_CAR_VehiculoMarcaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CAR_VehiculoMarca['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_VehiculoMarca['UsuarioCreacion'] ) ) $o_CAR_VehiculoMarcaBN->setUsuarioCreacion( $a_CAR_VehiculoMarca['UsuarioCreacion'] );
        if ( !is_null( $a_CAR_VehiculoMarca['FechaEliminado'] ) ) $o_CAR_VehiculoMarcaBN->setFechaEliminado( utilTimestamp::getTimestamp( $a_CAR_VehiculoMarca['FechaEliminado'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_VehiculoMarca['UsuarioEliminado'] ) ) $o_CAR_VehiculoMarcaBN->setUsuarioEliminado( $a_CAR_VehiculoMarca['UsuarioEliminado'] );
        if ( !is_null( $a_CAR_VehiculoMarca['UsuarioModificacion'] ) ) $o_CAR_VehiculoMarcaBN->setUsuarioModificacion( $a_CAR_VehiculoMarca['UsuarioModificacion'] );
        if ( !is_null( $a_CAR_VehiculoMarca['FechaModificacion'] ) ) $o_CAR_VehiculoMarcaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CAR_VehiculoMarca['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_CAR_VehiculoMarcaBN;
    }
}
?>