<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CAR_Vehiculo.xml */
/* Generado: 2024-12-31 05:16:49 */

/* Busqueda de registros de la tabla CAR_Vehiculo. */
abstract class BaseCAR_VehiculoFN extends CAR_VehiculoBN
{
    /* Declaracion de constantes */
    const Placa = "CAR_Vehiculo.Placa";
    const Pais = "CAR_Vehiculo.Pais";
    const IdVehiculoTipo = "CAR_Vehiculo.IdVehiculoTipo";
    const IdVehiculoMarca = "CAR_Vehiculo.IdVehiculoMarca";
    const IdVehiculoModelo = "CAR_Vehiculo.IdVehiculoModelo";
    const NombreTipoVehiculo = "CAR_Vehiculo.NombreTipoVehiculo";
    const NombreMarca = "CAR_Vehiculo.NombreMarca";
    const NombreModelo = "CAR_Vehiculo.NombreModelo";
    const Color = "CAR_Vehiculo.Color";
    const NumeroMotor = "CAR_Vehiculo.NumeroMotor";
    const Vin = "CAR_Vehiculo.Vin";
    const JsonCad = "CAR_Vehiculo.JsonCad";
    const FechaCreacion = "CAR_Vehiculo.FechaCreacion";
    const UsuarioCreacion = "CAR_Vehiculo.UsuarioCreacion";
    const FechaModificacion = "CAR_Vehiculo.FechaModificacion";
    const UsuarioModificacion = "CAR_Vehiculo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CAR_Vehiculo.Placa AS Placa, ";
        $s_SQLQuery .= "CAR_Vehiculo.Pais AS Pais, ";
        $s_SQLQuery .= "CAR_Vehiculo.IdVehiculoTipo AS IdVehiculoTipo, ";
        $s_SQLQuery .= "CAR_Vehiculo.IdVehiculoMarca AS IdVehiculoMarca, ";
        $s_SQLQuery .= "CAR_Vehiculo.IdVehiculoModelo AS IdVehiculoModelo, ";
        $s_SQLQuery .= "CAR_Vehiculo.NombreTipoVehiculo AS NombreTipoVehiculo, ";
        $s_SQLQuery .= "CAR_Vehiculo.NombreMarca AS NombreMarca, ";
        $s_SQLQuery .= "CAR_Vehiculo.NombreModelo AS NombreModelo, ";
        $s_SQLQuery .= "CAR_Vehiculo.Color AS Color, ";
        $s_SQLQuery .= "CAR_Vehiculo.NumeroMotor AS NumeroMotor, ";
        $s_SQLQuery .= "CAR_Vehiculo.Vin AS Vin, ";
        $s_SQLQuery .= "CAR_Vehiculo.JsonCad AS JsonCad, ";
        $s_SQLQuery .= "CAR_Vehiculo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CAR_Vehiculo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CAR_Vehiculo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "CAR_Vehiculo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CAR_VehiculoBN */
    public function setByBN( CAR_VehiculoBN $o_CAR_VehiculoBN )
    {
        if ( !is_null( $o_CAR_VehiculoBN->getPlaca() ) )
        {
            $this->setPlaca( $o_CAR_VehiculoBN->getPlaca() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getPais() ) )
        {
            $this->setPais( $o_CAR_VehiculoBN->getPais() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getIdVehiculoTipo() ) )
        {
            $this->setIdVehiculoTipo( $o_CAR_VehiculoBN->getIdVehiculoTipo() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getIdVehiculoMarca() ) )
        {
            $this->setIdVehiculoMarca( $o_CAR_VehiculoBN->getIdVehiculoMarca() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getIdVehiculoModelo() ) )
        {
            $this->setIdVehiculoModelo( $o_CAR_VehiculoBN->getIdVehiculoModelo() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getNombreTipoVehiculo() ) )
        {
            $this->setNombreTipoVehiculo( $o_CAR_VehiculoBN->getNombreTipoVehiculo() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getNombreMarca() ) )
        {
            $this->setNombreMarca( $o_CAR_VehiculoBN->getNombreMarca() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getNombreModelo() ) )
        {
            $this->setNombreModelo( $o_CAR_VehiculoBN->getNombreModelo() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getColor() ) )
        {
            $this->setColor( $o_CAR_VehiculoBN->getColor() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getNumeroMotor() ) )
        {
            $this->setNumeroMotor( $o_CAR_VehiculoBN->getNumeroMotor() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getVin() ) )
        {
            $this->setVin( $o_CAR_VehiculoBN->getVin() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getJsonCad() ) )
        {
            $this->setJsonCad( $o_CAR_VehiculoBN->getJsonCad() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CAR_VehiculoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CAR_VehiculoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CAR_VehiculoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_CAR_VehiculoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CAR_VehiculoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return CAR_VehiculoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_Placa )
    {
        if( is_null( $s_Placa ) ){ $s_Placa = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_Vehiculo ";
        $s_SQLQuery .= "WHERE Placa = '".$s_Placa."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CAR_VehiculoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CAR_VehiculoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CAR_VehiculoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getPlaca() ) ) $s_SQLQuery .= "CAR_Vehiculo.Placa = '".$this->getPlaca()."' AND ";
        if ( !is_null( $this->getPais() ) ) $s_SQLQuery .= "CAR_Vehiculo.Pais = '".$this->getPais()."' AND ";
        if ( !is_null( $this->getIdVehiculoTipo() ) ) $s_SQLQuery .= "CAR_Vehiculo.IdVehiculoTipo = ".$this->getIdVehiculoTipo()." AND ";
        if ( !is_null( $this->getIdVehiculoMarca() ) ) $s_SQLQuery .= "CAR_Vehiculo.IdVehiculoMarca = ".$this->getIdVehiculoMarca()." AND ";
        if ( !is_null( $this->getIdVehiculoModelo() ) ) $s_SQLQuery .= "CAR_Vehiculo.IdVehiculoModelo = ".$this->getIdVehiculoModelo()." AND ";
        if ( !is_null( $this->getNombreTipoVehiculo() ) ) $s_SQLQuery .= "CAR_Vehiculo.NombreTipoVehiculo = '".$this->getNombreTipoVehiculo()."' AND ";
        if ( !is_null( $this->getNombreMarca() ) ) $s_SQLQuery .= "CAR_Vehiculo.NombreMarca = '".$this->getNombreMarca()."' AND ";
        if ( !is_null( $this->getNombreModelo() ) ) $s_SQLQuery .= "CAR_Vehiculo.NombreModelo = '".$this->getNombreModelo()."' AND ";
        if ( !is_null( $this->getColor() ) ) $s_SQLQuery .= "CAR_Vehiculo.Color = '".$this->getColor()."' AND ";
        if ( !is_null( $this->getNumeroMotor() ) ) $s_SQLQuery .= "CAR_Vehiculo.NumeroMotor = '".$this->getNumeroMotor()."' AND ";
        if ( !is_null( $this->getVin() ) ) $s_SQLQuery .= "CAR_Vehiculo.Vin = '".$this->getVin()."' AND ";
        if ( !is_null( $this->getJsonCad() ) ) $s_SQLQuery .= "CAR_Vehiculo.JsonCad = '".$this->getJsonCad()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CAR_Vehiculo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CAR_Vehiculo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CAR_Vehiculo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CAR_Vehiculo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CAR_Vehiculo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CAR_VehiculoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_Vehiculo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CAR_VehiculoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CAR_VehiculoBN = $this->insertObjectBN( $a_SQLRow );
                $a_CAR_VehiculoBN[] = $o_CAR_VehiculoBN;
            }
        }
        return $a_CAR_VehiculoBN;
    }

    /* Devuelve un objeto CAR_VehiculoBN desde un objeto propel */
    public function insertObjectBN( $a_CAR_Vehiculo )
    {
        $o_CAR_VehiculoBN = new CAR_VehiculoBN();
        if ( !is_null( $a_CAR_Vehiculo['Placa'] ) ) $o_CAR_VehiculoBN->setPlaca( $a_CAR_Vehiculo['Placa'] );
        if ( !is_null( $a_CAR_Vehiculo['Pais'] ) ) $o_CAR_VehiculoBN->setPais( $a_CAR_Vehiculo['Pais'] );
        if ( !is_null( $a_CAR_Vehiculo['IdVehiculoTipo'] ) ) $o_CAR_VehiculoBN->setIdVehiculoTipo( ( integer ) $a_CAR_Vehiculo['IdVehiculoTipo'] );
        if ( !is_null( $a_CAR_Vehiculo['IdVehiculoMarca'] ) ) $o_CAR_VehiculoBN->setIdVehiculoMarca( ( integer ) $a_CAR_Vehiculo['IdVehiculoMarca'] );
        if ( !is_null( $a_CAR_Vehiculo['IdVehiculoModelo'] ) ) $o_CAR_VehiculoBN->setIdVehiculoModelo( ( integer ) $a_CAR_Vehiculo['IdVehiculoModelo'] );
        if ( !is_null( $a_CAR_Vehiculo['NombreTipoVehiculo'] ) ) $o_CAR_VehiculoBN->setNombreTipoVehiculo( $a_CAR_Vehiculo['NombreTipoVehiculo'] );
        if ( !is_null( $a_CAR_Vehiculo['NombreMarca'] ) ) $o_CAR_VehiculoBN->setNombreMarca( $a_CAR_Vehiculo['NombreMarca'] );
        if ( !is_null( $a_CAR_Vehiculo['NombreModelo'] ) ) $o_CAR_VehiculoBN->setNombreModelo( $a_CAR_Vehiculo['NombreModelo'] );
        if ( !is_null( $a_CAR_Vehiculo['Color'] ) ) $o_CAR_VehiculoBN->setColor( $a_CAR_Vehiculo['Color'] );
        if ( !is_null( $a_CAR_Vehiculo['NumeroMotor'] ) ) $o_CAR_VehiculoBN->setNumeroMotor( $a_CAR_Vehiculo['NumeroMotor'] );
        if ( !is_null( $a_CAR_Vehiculo['Vin'] ) ) $o_CAR_VehiculoBN->setVin( $a_CAR_Vehiculo['Vin'] );
        if ( !is_null( $a_CAR_Vehiculo['JsonCad'] ) ) $o_CAR_VehiculoBN->setJsonCad( $a_CAR_Vehiculo['JsonCad'] );
        if ( !is_null( $a_CAR_Vehiculo['FechaCreacion'] ) ) $o_CAR_VehiculoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CAR_Vehiculo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_Vehiculo['UsuarioCreacion'] ) ) $o_CAR_VehiculoBN->setUsuarioCreacion( $a_CAR_Vehiculo['UsuarioCreacion'] );
        if ( !is_null( $a_CAR_Vehiculo['FechaModificacion'] ) ) $o_CAR_VehiculoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CAR_Vehiculo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_Vehiculo['UsuarioModificacion'] ) ) $o_CAR_VehiculoBN->setUsuarioModificacion( $a_CAR_Vehiculo['UsuarioModificacion'] );
        return $o_CAR_VehiculoBN;
    }
}
?>