<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemTipo.xml */
/* Generado: 2022-04-18 21:14:50 */

/* Busqueda de registros de la tabla ALM_ItemTipo. */
abstract class BaseALM_ItemTipoFN extends ALM_ItemTipoBN
{
    /* Declaracion de constantes */
    const IdItemTipo = "ALM_ItemTipo.IdItemTipo";
    const DescripcionLocal = "ALM_ItemTipo.DescripcionLocal";
    const DescripcionIngles = "ALM_ItemTipo.DescripcionIngles";
    const CodigoSunat = "ALM_ItemTipo.CodigoSunat";
    const CuentaMayor = "ALM_ItemTipo.CuentaMayor";
    const IngenieriaFlag = "ALM_ItemTipo.IngenieriaFlag";
    const TransacciondelSistemaFlag = "ALM_ItemTipo.TransacciondelSistemaFlag";
    const MateriaPrimaFlag = "ALM_ItemTipo.MateriaPrimaFlag";
    const VerDiaSemanaFlag = "ALM_ItemTipo.VerDiaSemanaFlag";
    const Estado = "ALM_ItemTipo.Estado";
    const UsuarioModificacion = "ALM_ItemTipo.UsuarioModificacion";
    const FechaModificacion = "ALM_ItemTipo.FechaModificacion";
    const UsuarioCreacion = "ALM_ItemTipo.UsuarioCreacion";
    const FechaCreacion = "ALM_ItemTipo.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_ItemTipo.IdItemTipo AS IdItemTipo, ";
        $s_SQLQuery .= "ALM_ItemTipo.DescripcionLocal AS DescripcionLocal, ";
        $s_SQLQuery .= "ALM_ItemTipo.DescripcionIngles AS DescripcionIngles, ";
        $s_SQLQuery .= "ALM_ItemTipo.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "ALM_ItemTipo.CuentaMayor AS CuentaMayor, ";
        $s_SQLQuery .= "ALM_ItemTipo.IngenieriaFlag AS IngenieriaFlag, ";
        $s_SQLQuery .= "ALM_ItemTipo.TransacciondelSistemaFlag AS TransacciondelSistemaFlag, ";
        $s_SQLQuery .= "ALM_ItemTipo.MateriaPrimaFlag AS MateriaPrimaFlag, ";
        $s_SQLQuery .= "ALM_ItemTipo.VerDiaSemanaFlag AS VerDiaSemanaFlag, ";
        $s_SQLQuery .= "ALM_ItemTipo.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_ItemTipo.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_ItemTipo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_ItemTipo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_ItemTipo.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_ItemTipoBN */
    public function setByBN( ALM_ItemTipoBN $o_ALM_ItemTipoBN )
    {
        if ( !is_null( $o_ALM_ItemTipoBN->getIdItemTipo() ) )
        {
            $this->setIdItemTipo( $o_ALM_ItemTipoBN->getIdItemTipo() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_ALM_ItemTipoBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_ALM_ItemTipoBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_ALM_ItemTipoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getCuentaMayor() ) )
        {
            $this->setCuentaMayor( $o_ALM_ItemTipoBN->getCuentaMayor() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getIngenieriaFlag() ) )
        {
            $this->setIngenieriaFlag( $o_ALM_ItemTipoBN->getIngenieriaFlag() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getTransacciondelSistemaFlag() ) )
        {
            $this->setTransacciondelSistemaFlag( $o_ALM_ItemTipoBN->getTransacciondelSistemaFlag() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getMateriaPrimaFlag() ) )
        {
            $this->setMateriaPrimaFlag( $o_ALM_ItemTipoBN->getMateriaPrimaFlag() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getVerDiaSemanaFlag() ) )
        {
            $this->setVerDiaSemanaFlag( $o_ALM_ItemTipoBN->getVerDiaSemanaFlag() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_ItemTipoBN->getEstado() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemTipoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemTipoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemTipoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemTipoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemTipoBN->getFechaCreacion() );
        }
    }

    /**
    * @return ALM_ItemTipoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdItemTipo )
    {
        if( is_null( $s_IdItemTipo ) ){ $s_IdItemTipo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemTipo ";
        $s_SQLQuery .= "WHERE IdItemTipo = '".$s_IdItemTipo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_ItemTipoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_ItemTipoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ItemTipoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdItemTipo() ) ) $s_SQLQuery .= "ALM_ItemTipo.IdItemTipo = '".$this->getIdItemTipo()."' AND ";
        if ( !is_null( $this->getDescripcionLocal() ) ) $s_SQLQuery .= "ALM_ItemTipo.DescripcionLocal = '".$this->getDescripcionLocal()."' AND ";
        if ( !is_null( $this->getDescripcionIngles() ) ) $s_SQLQuery .= "ALM_ItemTipo.DescripcionIngles = '".$this->getDescripcionIngles()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "ALM_ItemTipo.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getCuentaMayor() ) ) $s_SQLQuery .= "ALM_ItemTipo.CuentaMayor = '".$this->getCuentaMayor()."' AND ";
        if ( !is_null( $this->getIngenieriaFlag() ) ) $s_SQLQuery .= "ALM_ItemTipo.IngenieriaFlag = '".$this->getIngenieriaFlag()."' AND ";
        if ( !is_null( $this->getTransacciondelSistemaFlag() ) ) $s_SQLQuery .= "ALM_ItemTipo.TransacciondelSistemaFlag = '".$this->getTransacciondelSistemaFlag()."' AND ";
        if ( !is_null( $this->getMateriaPrimaFlag() ) ) $s_SQLQuery .= "ALM_ItemTipo.MateriaPrimaFlag = '".$this->getMateriaPrimaFlag()."' AND ";
        if ( !is_null( $this->getVerDiaSemanaFlag() ) ) $s_SQLQuery .= "ALM_ItemTipo.VerDiaSemanaFlag = '".$this->getVerDiaSemanaFlag()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_ItemTipo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_ItemTipo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_ItemTipo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_ItemTipo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_ItemTipo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_ItemTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_ItemTipoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_ItemTipoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_ItemTipoBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_ItemTipoBN[] = $o_ALM_ItemTipoBN;
            }
        }
        return $a_ALM_ItemTipoBN;
    }

    /* Devuelve un objeto ALM_ItemTipoBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_ItemTipo )
    {
        $o_ALM_ItemTipoBN = new ALM_ItemTipoBN();
        if ( !is_null( $a_ALM_ItemTipo['IdItemTipo'] ) ) $o_ALM_ItemTipoBN->setIdItemTipo( $a_ALM_ItemTipo['IdItemTipo'] );
        if ( !is_null( $a_ALM_ItemTipo['DescripcionLocal'] ) ) $o_ALM_ItemTipoBN->setDescripcionLocal( $a_ALM_ItemTipo['DescripcionLocal'] );
        if ( !is_null( $a_ALM_ItemTipo['DescripcionIngles'] ) ) $o_ALM_ItemTipoBN->setDescripcionIngles( $a_ALM_ItemTipo['DescripcionIngles'] );
        if ( !is_null( $a_ALM_ItemTipo['CodigoSunat'] ) ) $o_ALM_ItemTipoBN->setCodigoSunat( $a_ALM_ItemTipo['CodigoSunat'] );
        if ( !is_null( $a_ALM_ItemTipo['CuentaMayor'] ) ) $o_ALM_ItemTipoBN->setCuentaMayor( $a_ALM_ItemTipo['CuentaMayor'] );
        if ( !is_null( $a_ALM_ItemTipo['IngenieriaFlag'] ) ) $o_ALM_ItemTipoBN->setIngenieriaFlag( $a_ALM_ItemTipo['IngenieriaFlag'] );
        if ( !is_null( $a_ALM_ItemTipo['TransacciondelSistemaFlag'] ) ) $o_ALM_ItemTipoBN->setTransacciondelSistemaFlag( $a_ALM_ItemTipo['TransacciondelSistemaFlag'] );
        if ( !is_null( $a_ALM_ItemTipo['MateriaPrimaFlag'] ) ) $o_ALM_ItemTipoBN->setMateriaPrimaFlag( $a_ALM_ItemTipo['MateriaPrimaFlag'] );
        if ( !is_null( $a_ALM_ItemTipo['VerDiaSemanaFlag'] ) ) $o_ALM_ItemTipoBN->setVerDiaSemanaFlag( $a_ALM_ItemTipo['VerDiaSemanaFlag'] );
        if ( !is_null( $a_ALM_ItemTipo['Estado'] ) ) $o_ALM_ItemTipoBN->setEstado( $a_ALM_ItemTipo['Estado'] );
        if ( !is_null( $a_ALM_ItemTipo['UsuarioModificacion'] ) ) $o_ALM_ItemTipoBN->setUsuarioModificacion( $a_ALM_ItemTipo['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_ItemTipo['FechaModificacion'] ) ) $o_ALM_ItemTipoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_ItemTipo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemTipo['UsuarioCreacion'] ) ) $o_ALM_ItemTipoBN->setUsuarioCreacion( $a_ALM_ItemTipo['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_ItemTipo['FechaCreacion'] ) ) $o_ALM_ItemTipoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_ItemTipo['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_ItemTipoBN;
    }
}
?>