<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaArhivos.xml */
/* Generado: 2022-04-18 21:14:48 */

/* Busqueda de registros de la tabla ALM_CajaChicaArhivos. */
abstract class BaseALM_CajaChicaArhivosFN extends ALM_CajaChicaArhivosBN
{
    /* Declaracion de constantes */
    const IdCajaDet = "ALM_CajaChicaArhivos.IdCajaDet";
    const IdSecuencia = "ALM_CajaChicaArhivos.IdSecuencia";
    const Nombre = "ALM_CajaChicaArhivos.Nombre";
    const Tipo = "ALM_CajaChicaArhivos.Tipo";
    const TipoCompleto = "ALM_CajaChicaArhivos.TipoCompleto";
    const Tamanio = "ALM_CajaChicaArhivos.Tamanio";
    const UbicacionURL = "ALM_CajaChicaArhivos.UbicacionURL";
    const UbicacionFisica = "ALM_CajaChicaArhivos.UbicacionFisica";
    const FechaCreacion = "ALM_CajaChicaArhivos.FechaCreacion";
    const UsuarioCreacion = "ALM_CajaChicaArhivos.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_CajaChicaArhivos.IdCajaDet AS IdCajaDet, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.Nombre AS Nombre, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.Tipo AS Tipo, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.TipoCompleto AS TipoCompleto, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.Tamanio AS Tamanio, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.UbicacionURL AS UbicacionURL, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.UbicacionFisica AS UbicacionFisica, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaArhivos.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_CajaChicaArhivosBN */
    public function setByBN( ALM_CajaChicaArhivosBN $o_ALM_CajaChicaArhivosBN )
    {
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getIdCajaDet() ) )
        {
            $this->setIdCajaDet( $o_ALM_CajaChicaArhivosBN->getIdCajaDet() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_CajaChicaArhivosBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getNombre() ) )
        {
            $this->setNombre( $o_ALM_CajaChicaArhivosBN->getNombre() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getTipo() ) )
        {
            $this->setTipo( $o_ALM_CajaChicaArhivosBN->getTipo() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getTipoCompleto() ) )
        {
            $this->setTipoCompleto( $o_ALM_CajaChicaArhivosBN->getTipoCompleto() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getTamanio() ) )
        {
            $this->setTamanio( $o_ALM_CajaChicaArhivosBN->getTamanio() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getUbicacionURL() ) )
        {
            $this->setUbicacionURL( $o_ALM_CajaChicaArhivosBN->getUbicacionURL() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_ALM_CajaChicaArhivosBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_CajaChicaArhivosBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaArhivosBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_CajaChicaArhivosBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return ALM_CajaChicaArhivosBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCajaDet, $i_IdSecuencia )
    {
        if( is_null( $i_IdCajaDet ) ){ $i_IdCajaDet = -1; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaArhivos ";
        $s_SQLQuery .= "WHERE IdCajaDet = ".$i_IdCajaDet." ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_CajaChicaArhivosBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_CajaChicaArhivosBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_CajaChicaArhivosBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCajaDet() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.IdCajaDet = ".$this->getIdCajaDet()." AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getTipoCompleto() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.TipoCompleto = '".$this->getTipoCompleto()."' AND ";
        if ( !is_null( $this->getTamanio() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.Tamanio = ".$this->getTamanio()." AND ";
        if ( !is_null( $this->getUbicacionURL() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.UbicacionURL = '".$this->getUbicacionURL()."' AND ";
        if ( !is_null( $this->getUbicacionFisica() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.UbicacionFisica = '".$this->getUbicacionFisica()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaArhivos.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_CajaChicaArhivos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_CajaChicaArhivosBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaArhivos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_CajaChicaArhivosBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_CajaChicaArhivosBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_CajaChicaArhivosBN[] = $o_ALM_CajaChicaArhivosBN;
            }
        }
        return $a_ALM_CajaChicaArhivosBN;
    }

    /* Devuelve un objeto ALM_CajaChicaArhivosBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_CajaChicaArhivos )
    {
        $o_ALM_CajaChicaArhivosBN = new ALM_CajaChicaArhivosBN();
        if ( !is_null( $a_ALM_CajaChicaArhivos['IdCajaDet'] ) ) $o_ALM_CajaChicaArhivosBN->setIdCajaDet( ( integer ) $a_ALM_CajaChicaArhivos['IdCajaDet'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['IdSecuencia'] ) ) $o_ALM_CajaChicaArhivosBN->setIdSecuencia( ( integer ) $a_ALM_CajaChicaArhivos['IdSecuencia'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['Nombre'] ) ) $o_ALM_CajaChicaArhivosBN->setNombre( $a_ALM_CajaChicaArhivos['Nombre'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['Tipo'] ) ) $o_ALM_CajaChicaArhivosBN->setTipo( $a_ALM_CajaChicaArhivos['Tipo'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['TipoCompleto'] ) ) $o_ALM_CajaChicaArhivosBN->setTipoCompleto( $a_ALM_CajaChicaArhivos['TipoCompleto'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['Tamanio'] ) ) $o_ALM_CajaChicaArhivosBN->setTamanio( ( integer ) $a_ALM_CajaChicaArhivos['Tamanio'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['UbicacionURL'] ) ) $o_ALM_CajaChicaArhivosBN->setUbicacionURL( $a_ALM_CajaChicaArhivos['UbicacionURL'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['UbicacionFisica'] ) ) $o_ALM_CajaChicaArhivosBN->setUbicacionFisica( $a_ALM_CajaChicaArhivos['UbicacionFisica'] );
        if ( !is_null( $a_ALM_CajaChicaArhivos['FechaCreacion'] ) ) $o_ALM_CajaChicaArhivosBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaArhivos['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaArhivos['UsuarioCreacion'] ) ) $o_ALM_CajaChicaArhivosBN->setUsuarioCreacion( $a_ALM_CajaChicaArhivos['UsuarioCreacion'] );
        return $o_ALM_CajaChicaArhivosBN;
    }
}
?>