<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_Vendedor.xml */
/* Generado: 2021-09-14 19:26:57 */

/* Mantenimiento de los registros de la tabla VTA_Vendedor */
abstract class BaseVTA_VendedorDP extends VTA_VendedorBV
{
    /* Constructor ( Establece los valores desde un objeto VTA_VendedorBN ) */
    public function __construct( VTA_VendedorBN $o_VTA_VendedorBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_VTA_VendedorBN ) )
        {
            $this->setByBN( $o_VTA_VendedorBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto VTA_VendedorBN */
    public function setByBN( VTA_VendedorBN $o_VTA_VendedorBN )
    {
        if ( !is_null( $o_VTA_VendedorBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_VTA_VendedorBN->getIdPersona() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getPorcentajeDscto() ) )
        {
            $this->setPorcentajeDscto( $o_VTA_VendedorBN->getPorcentajeDscto() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_VTA_VendedorBN->getIdUsuario() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_VendedorBN->getEstado() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_VendedorBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_VendedorBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_VendedorBN->getFechaModificacion() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_VendedorBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_VTA_VendedorFN = new VTA_VendedorFN();
        $o_VTA_VendedorBN = $o_VTA_VendedorFN->selectByPk( $this->getIdPersona() );
        if ( is_null( $o_VTA_VendedorBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO VTA_Vendedor ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdPersona() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPersona";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdPersona()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPorcentajeDscto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PorcentajeDscto";
                $s_SQLQuery2 .= $s_Separator."".$this->getPorcentajeDscto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUsuario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUsuario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdUsuario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE VTA_Vendedor SET ";
            $s_Separator = "";
            if ( !is_null( $this->getPorcentajeDscto() ) )
            {
                $s_SQLQuery .= $s_Separator."PorcentajeDscto = ".$this->getPorcentajeDscto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUsuario() ) )
            {
                $s_SQLQuery .= $s_Separator."IdUsuario = '".$this->getIdUsuario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdPersona = ".$this->getIdPersona().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM VTA_Vendedor WHERE  IdPersona = ".$this->getIdPersona().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>