<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenTipo.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Mantenimiento de los registros de la tabla VTA_OrdenTipo */
abstract class BaseVTA_OrdenTipoDP extends VTA_OrdenTipoBV
{
    /* Constructor ( Establece los valores desde un objeto VTA_OrdenTipoBN ) */
    public function __construct( VTA_OrdenTipoBN $o_VTA_OrdenTipoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_VTA_OrdenTipoBN ) )
        {
            $this->setByBN( $o_VTA_OrdenTipoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto VTA_OrdenTipoBN */
    public function setByBN( VTA_OrdenTipoBN $o_VTA_OrdenTipoBN )
    {
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoId() ) )
        {
            $this->setOrdenTipoId( $o_VTA_OrdenTipoBN->getOrdenTipoId() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoCod() ) )
        {
            $this->setOrdenTipoCod( $o_VTA_OrdenTipoBN->getOrdenTipoCod() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoDescripcion() ) )
        {
            $this->setOrdenTipoDescripcion( $o_VTA_OrdenTipoBN->getOrdenTipoDescripcion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoPrefijo() ) )
        {
            $this->setOrdenTipoPrefijo( $o_VTA_OrdenTipoBN->getOrdenTipoPrefijo() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getDocRefTipo() ) )
        {
            $this->setDocRefTipo( $o_VTA_OrdenTipoBN->getDocRefTipo() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoPublico() ) )
        {
            $this->setOrdenTipoPublico( $o_VTA_OrdenTipoBN->getOrdenTipoPublico() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoEstado() ) )
        {
            $this->setOrdenTipoEstado( $o_VTA_OrdenTipoBN->getOrdenTipoEstado() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenCreacion() ) )
        {
            $this->setOrdenCreacion( $o_VTA_OrdenTipoBN->getOrdenCreacion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_OrdenTipoBN->getFechaCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_VTA_OrdenTipoFN = new VTA_OrdenTipoFN();
        $o_VTA_OrdenTipoBN = $o_VTA_OrdenTipoFN->selectByPk( $this->getOrdenTipoId() );
        if ( is_null( $o_VTA_OrdenTipoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO VTA_OrdenTipo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getOrdenTipoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenTipoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getOrdenTipoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoCod() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenTipoCod";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenTipoCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenTipoDescripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenTipoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoPrefijo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenTipoPrefijo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenTipoPrefijo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocRefTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DocRefTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDocRefTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoPublico() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenTipoPublico";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenTipoPublico()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenTipoEstado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenTipoEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE VTA_OrdenTipo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getOrdenTipoCod() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenTipoCod = '".$this->getOrdenTipoCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenTipoDescripcion = '".$this->getOrdenTipoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoPrefijo() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenTipoPrefijo = '".$this->getOrdenTipoPrefijo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocRefTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."DocRefTipo = '".$this->getDocRefTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoPublico() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenTipoPublico = '".$this->getOrdenTipoPublico()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenTipoEstado = '".$this->getOrdenTipoEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenCreacion = '".$this->getOrdenCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  OrdenTipoId = ".$this->getOrdenTipoId().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM VTA_OrdenTipo WHERE  OrdenTipoId = ".$this->getOrdenTipoId().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>