<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_DocumentoCuotas.xml */
/* Generado: 2022-09-29 19:36:24 */

/* Mantenimiento de los registros de la tabla VTA_DocumentoCuotas */
abstract class BaseVTA_DocumentoCuotasDP extends VTA_DocumentoCuotasBV
{
    /* Constructor ( Establece los valores desde un objeto VTA_DocumentoCuotasBN ) */
    public function __construct( VTA_DocumentoCuotasBN $o_VTA_DocumentoCuotasBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_VTA_DocumentoCuotasBN ) )
        {
            $this->setByBN( $o_VTA_DocumentoCuotasBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto VTA_DocumentoCuotasBN */
    public function setByBN( VTA_DocumentoCuotasBN $o_VTA_DocumentoCuotasBN )
    {
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getCuotaId() ) )
        {
            $this->setCuotaId( $o_VTA_DocumentoCuotasBN->getCuotaId() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getNumeroDocumentoId() ) )
        {
            $this->setNumeroDocumentoId( $o_VTA_DocumentoCuotasBN->getNumeroDocumentoId() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getCuotaMonto() ) )
        {
            $this->setCuotaMonto( $o_VTA_DocumentoCuotasBN->getCuotaMonto() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getCuotaFecha() ) )
        {
            $this->setCuotaFecha( $o_VTA_DocumentoCuotasBN->getCuotaFecha() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_DocumentoCuotasBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_DocumentoCuotasBN->getFechaCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_VTA_DocumentoCuotasFN = new VTA_DocumentoCuotasFN();
        $o_VTA_DocumentoCuotasBN = $o_VTA_DocumentoCuotasFN->selectByPk( $this->getCuotaId() );
        if ( is_null( $o_VTA_DocumentoCuotasBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO VTA_DocumentoCuotas ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getCuotaId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CuotaId";
                $s_SQLQuery2 .= $s_Separator."".$this->getCuotaId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroDocumentoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NumeroDocumentoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getNumeroDocumentoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuotaMonto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CuotaMonto";
                $s_SQLQuery2 .= $s_Separator."".$this->getCuotaMonto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuotaFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CuotaFecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCuotaFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE VTA_DocumentoCuotas SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNumeroDocumentoId() ) )
            {
                $s_SQLQuery .= $s_Separator."NumeroDocumentoId = ".$this->getNumeroDocumentoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuotaMonto() ) )
            {
                $s_SQLQuery .= $s_Separator."CuotaMonto = ".$this->getCuotaMonto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuotaFecha() ) )
            {
                $s_SQLQuery .= $s_Separator."CuotaFecha = '".$this->getCuotaFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  CuotaId = ".$this->getCuotaId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM VTA_DocumentoCuotas WHERE  CuotaId = ".$this->getCuotaId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>