<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: sys_parametros.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Mantenimiento de los registros de la tabla sys_parametros */
abstract class BaseSys_parametrosDP extends Sys_parametrosBV
{
    /* Constructor ( Establece los valores desde un objeto Sys_parametrosBN ) */
    public function __construct( Sys_parametrosBN $o_Sys_parametrosBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_Sys_parametrosBN ) )
        {
            $this->setByBN( $o_Sys_parametrosBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto Sys_parametrosBN */
    public function setByBN( Sys_parametrosBN $o_Sys_parametrosBN )
    {
        if ( !is_null( $o_Sys_parametrosBN->getParametroid() ) )
        {
            $this->setParametroid( $o_Sys_parametrosBN->getParametroid() );
        }
        if ( !is_null( $o_Sys_parametrosBN->getParametrocod() ) )
        {
            $this->setParametrocod( $o_Sys_parametrosBN->getParametrocod() );
        }
        if ( !is_null( $o_Sys_parametrosBN->getParamtetrovalor() ) )
        {
            $this->setParamtetrovalor( $o_Sys_parametrosBN->getParamtetrovalor() );
        }
        if ( !is_null( $o_Sys_parametrosBN->getComentario() ) )
        {
            $this->setComentario( $o_Sys_parametrosBN->getComentario() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_sys_parametrosFN = new Sys_parametrosFN();
        $o_sys_parametrosBN = $o_sys_parametrosFN->selectByPk( $this->getParametroid(), $this->getParametrocod() );
        if ( is_null( $o_sys_parametrosBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO sys_parametros ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getParametroid() ) )
            {
                $s_SQLQuery1 .= $s_Separator."parametroid";
                $s_SQLQuery2 .= $s_Separator."'".$this->getParametroid()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getParametrocod() ) )
            {
                $s_SQLQuery1 .= $s_Separator."parametrocod";
                $s_SQLQuery2 .= $s_Separator."'".$this->getParametrocod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getParamtetrovalor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."paramtetrovalor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getParamtetrovalor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE sys_parametros SET ";
            $s_Separator = "";
            if ( !is_null( $this->getParamtetrovalor() ) )
            {
                $s_SQLQuery .= $s_Separator."paramtetrovalor = '".$this->getParamtetrovalor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  parametroid = '".$this->getParametroid()."' AND  parametrocod = '".$this->getParametrocod()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM sys_parametros WHERE  parametroid = '".$this->getParametroid()."' AND  parametrocod = '".$this->getParametrocod()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>