<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_Serie.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Mantenimiento de los registros de la tabla SR_Serie */
abstract class BaseSR_SerieDP extends SR_SerieBV
{
    /* Constructor ( Establece los valores desde un objeto SR_SerieBN ) */
    public function __construct( SR_SerieBN $o_SR_SerieBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SR_SerieBN ) )
        {
            $this->setByBN( $o_SR_SerieBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SR_SerieBN */
    public function setByBN( SR_SerieBN $o_SR_SerieBN )
    {
        if ( !is_null( $o_SR_SerieBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_SerieBN->getSerieId() );
        }
        if ( !is_null( $o_SR_SerieBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_SerieBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_SerieBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_SerieBN->getProductoId() );
        }
        if ( !is_null( $o_SR_SerieBN->getSerieNumero() ) )
        {
            $this->setSerieNumero( $o_SR_SerieBN->getSerieNumero() );
        }
        if ( !is_null( $o_SR_SerieBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_SerieBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_SerieBN->getUltimaOperacion() ) )
        {
            $this->setUltimaOperacion( $o_SR_SerieBN->getUltimaOperacion() );
        }
        if ( !is_null( $o_SR_SerieBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_SerieBN->getEstado() );
        }
        if ( !is_null( $o_SR_SerieBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_SerieBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_SerieBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_SerieBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_SerieBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_SerieBN->getComentario() );
        }
        if ( !is_null( $o_SR_SerieBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_SerieBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_SerieBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_SerieBN->getFechaRegistro() );
        }
        if ( !is_null( $o_SR_SerieBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_SerieBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_SR_SerieBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_SerieBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SR_SerieFN = new SR_SerieFN();
        $o_SR_SerieBN = $o_SR_SerieFN->selectByPk( $this->getSerieId() );
        if ( is_null( $o_SR_SerieBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SR_Serie ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getSerieId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieId";
                $s_SQLQuery2 .= $s_Separator."".$this->getSerieId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProductoId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSerieNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Almacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUltimaOperacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UltimaOperacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUltimaOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SR_Serie SET ";
            $s_Separator = "";
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery .= $s_Separator."MovimientoId = ".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery .= $s_Separator."ProductoId = '".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."SerieNumero = '".$this->getSerieNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery .= $s_Separator."Almacen = '".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUltimaOperacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UltimaOperacion = '".$this->getUltimaOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaTipo = '".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaNumero = '".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  SerieId = ".$this->getSerieId().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SR_Serie WHERE  SerieId = ".$this->getSerieId().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>