<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_PreSerieEscaneo.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Mantenimiento de los registros de la tabla SR_PreSerieEscaneo */
abstract class BaseSR_PreSerieEscaneoDP extends SR_PreSerieEscaneoBV
{
    /* Constructor ( Establece los valores desde un objeto SR_PreSerieEscaneoBN ) */
    public function __construct( SR_PreSerieEscaneoBN $o_SR_PreSerieEscaneoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SR_PreSerieEscaneoBN ) )
        {
            $this->setByBN( $o_SR_PreSerieEscaneoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SR_PreSerieEscaneoBN */
    public function setByBN( SR_PreSerieEscaneoBN $o_SR_PreSerieEscaneoBN )
    {
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_PreSerieEscaneoBN->getSerieId() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_PreSerieEscaneoBN->getProductoId() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_PreSerieEscaneoBN->getFecha() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getOperacion() ) )
        {
            $this->setOperacion( $o_SR_PreSerieEscaneoBN->getOperacion() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_PreSerieEscaneoBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_PreSerieEscaneoBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_PreSerieEscaneoBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_PreSerieEscaneoBN->getComentario() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_PreSerieEscaneoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_PreSerieEscaneoBN->getFechaRegistro() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
        $o_SR_PreSerieEscaneoBN = $o_SR_PreSerieEscaneoFN->selectByPk( $this->getMovimientoDetalleId(), $this->getSerieId() );
        if ( is_null( $o_SR_PreSerieEscaneoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SR_PreSerieEscaneo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getMovimientoDetalleId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoDetalleId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoDetalleId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieId";
                $s_SQLQuery2 .= $s_Separator."".$this->getSerieId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProductoId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Fecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOperacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Operacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Almacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SR_PreSerieEscaneo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery .= $s_Separator."ProductoId = '".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery .= $s_Separator."Fecha = '".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOperacion() ) )
            {
                $s_SQLQuery .= $s_Separator."Operacion = '".$this->getOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery .= $s_Separator."Almacen = '".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaTipo = '".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaNumero = '".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND  SerieId = ".$this->getSerieId().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SR_PreSerieEscaneo WHERE  MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND  SerieId = ".$this->getSerieId().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>