<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_GuiaRemisionH.xml */
/* Generado: 2024-08-25 21:43:26 */

/* Mantenimiento de los registros de la tabla SR_GuiaRemisionH */
abstract class BaseSR_GuiaRemisionHDP extends SR_GuiaRemisionHBV
{
    /* Constructor ( Establece los valores desde un objeto SR_GuiaRemisionHBN ) */
    public function __construct( SR_GuiaRemisionHBN $o_SR_GuiaRemisionHBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SR_GuiaRemisionHBN ) )
        {
            $this->setByBN( $o_SR_GuiaRemisionHBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SR_GuiaRemisionHBN */
    public function setByBN( SR_GuiaRemisionHBN $o_SR_GuiaRemisionHBN )
    {
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaRemisionId() ) )
        {
            $this->setGuiaRemisionId( $o_SR_GuiaRemisionHBN->getGuiaRemisionId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SR_GuiaRemisionHBN->getIdCompania() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SR_GuiaRemisionHBN->getIdSucursal() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTipoGuia() ) )
        {
            $this->setTipoGuia( $o_SR_GuiaRemisionHBN->getTipoGuia() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaSerie() ) )
        {
            $this->setGuiaSerie( $o_SR_GuiaRemisionHBN->getGuiaSerie() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaNumero() ) )
        {
            $this->setGuiaNumero( $o_SR_GuiaRemisionHBN->getGuiaNumero() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaFecha() ) )
        {
            $this->setGuiaFecha( $o_SR_GuiaRemisionHBN->getGuiaFecha() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaIniTraslado() ) )
        {
            $this->setFechaIniTraslado( $o_SR_GuiaRemisionHBN->getFechaIniTraslado() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_SR_GuiaRemisionHBN->getIdProyecto() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getOrdenTipoComercialId() ) )
        {
            $this->setOrdenTipoComercialId( $o_SR_GuiaRemisionHBN->getOrdenTipoComercialId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaParentId() ) )
        {
            $this->setReferenciaParentId( $o_SR_GuiaRemisionHBN->getReferenciaParentId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaParentNum() ) )
        {
            $this->setReferenciaParentNum( $o_SR_GuiaRemisionHBN->getReferenciaParentNum() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaIdTipoDocumento() ) )
        {
            $this->setReferenciaIdTipoDocumento( $o_SR_GuiaRemisionHBN->getReferenciaIdTipoDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_GuiaRemisionHBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_GuiaRemisionHBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_SR_GuiaRemisionHBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_GuiaRemisionHBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMovimientoDetId() ) )
        {
            $this->setMovimientoDetId( $o_SR_GuiaRemisionHBN->getMovimientoDetId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaInicioAlq() ) )
        {
            $this->setFechaInicioAlq( $o_SR_GuiaRemisionHBN->getFechaInicioAlq() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaFinAlq() ) )
        {
            $this->setFechaFinAlq( $o_SR_GuiaRemisionHBN->getFechaFinAlq() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaTipoDoc() ) )
        {
            $this->setEmpresaTipoDoc( $o_SR_GuiaRemisionHBN->getEmpresaTipoDoc() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaNumDoc() ) )
        {
            $this->setEmpresaNumDoc( $o_SR_GuiaRemisionHBN->getEmpresaNumDoc() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaInfoAdicional() ) )
        {
            $this->setEmpresaInfoAdicional( $o_SR_GuiaRemisionHBN->getEmpresaInfoAdicional() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaDireccion() ) )
        {
            $this->setEmpresaDireccion( $o_SR_GuiaRemisionHBN->getEmpresaDireccion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getClienteNombre() ) )
        {
            $this->setClienteNombre( $o_SR_GuiaRemisionHBN->getClienteNombre() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getClienteTipoDocumento() ) )
        {
            $this->setClienteTipoDocumento( $o_SR_GuiaRemisionHBN->getClienteTipoDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getClienteNumDocumento() ) )
        {
            $this->setClienteNumDocumento( $o_SR_GuiaRemisionHBN->getClienteNumDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDepartamentoOrigen() ) )
        {
            $this->setDepartamentoOrigen( $o_SR_GuiaRemisionHBN->getDepartamentoOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getProvinciaOrigen() ) )
        {
            $this->setProvinciaOrigen( $o_SR_GuiaRemisionHBN->getProvinciaOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDistritoOrigen() ) )
        {
            $this->setDistritoOrigen( $o_SR_GuiaRemisionHBN->getDistritoOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDireccionOrigen() ) )
        {
            $this->setDireccionOrigen( $o_SR_GuiaRemisionHBN->getDireccionOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getUbigeoOrigen() ) )
        {
            $this->setUbigeoOrigen( $o_SR_GuiaRemisionHBN->getUbigeoOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDepartamentoDestino() ) )
        {
            $this->setDepartamentoDestino( $o_SR_GuiaRemisionHBN->getDepartamentoDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getProvinciaDestino() ) )
        {
            $this->setProvinciaDestino( $o_SR_GuiaRemisionHBN->getProvinciaDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDistritoDestino() ) )
        {
            $this->setDistritoDestino( $o_SR_GuiaRemisionHBN->getDistritoDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDireccionDestino() ) )
        {
            $this->setDireccionDestino( $o_SR_GuiaRemisionHBN->getDireccionDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getUbigeoDestino() ) )
        {
            $this->setUbigeoDestino( $o_SR_GuiaRemisionHBN->getUbigeoDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdVehiculo() ) )
        {
            $this->setIdVehiculo( $o_SR_GuiaRemisionHBN->getIdVehiculo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdChofer() ) )
        {
            $this->setIdChofer( $o_SR_GuiaRemisionHBN->getIdChofer() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMotivoTrasladoId() ) )
        {
            $this->setMotivoTrasladoId( $o_SR_GuiaRemisionHBN->getMotivoTrasladoId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getModalidadTransporteId() ) )
        {
            $this->setModalidadTransporteId( $o_SR_GuiaRemisionHBN->getModalidadTransporteId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getPesoTotal() ) )
        {
            $this->setPesoTotal( $o_SR_GuiaRemisionHBN->getPesoTotal() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getNumeroBultos() ) )
        {
            $this->setNumeroBultos( $o_SR_GuiaRemisionHBN->getNumeroBultos() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getConductorDocumentoTipo() ) )
        {
            $this->setConductorDocumentoTipo( $o_SR_GuiaRemisionHBN->getConductorDocumentoTipo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getConductorDocumentoNumero() ) )
        {
            $this->setConductorDocumentoNumero( $o_SR_GuiaRemisionHBN->getConductorDocumentoNumero() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getConductorDenominacion() ) )
        {
            $this->setConductorDenominacion( $o_SR_GuiaRemisionHBN->getConductorDenominacion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getConductorNombre() ) )
        {
            $this->setConductorNombre( $o_SR_GuiaRemisionHBN->getConductorNombre() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getConductorApellido() ) )
        {
            $this->setConductorApellido( $o_SR_GuiaRemisionHBN->getConductorApellido() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getConductorNumeroLicencia() ) )
        {
            $this->setConductorNumeroLicencia( $o_SR_GuiaRemisionHBN->getConductorNumeroLicencia() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTransportistaDocumentoTipo() ) )
        {
            $this->setTransportistaDocumentoTipo( $o_SR_GuiaRemisionHBN->getTransportistaDocumentoTipo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTransportistaDocumentoNumero() ) )
        {
            $this->setTransportistaDocumentoNumero( $o_SR_GuiaRemisionHBN->getTransportistaDocumentoNumero() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTransportistaDenominacion() ) )
        {
            $this->setTransportistaDenominacion( $o_SR_GuiaRemisionHBN->getTransportistaDenominacion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTransportistaPlacaNumero() ) )
        {
            $this->setTransportistaPlacaNumero( $o_SR_GuiaRemisionHBN->getTransportistaPlacaNumero() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_GuiaRemisionHBN->getComentario() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_SR_GuiaRemisionHBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_SR_GuiaRemisionHBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_SR_GuiaRemisionHBN->getIdTransaccion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMensajeException() ) )
        {
            $this->setMensajeException( $o_SR_GuiaRemisionHBN->getMensajeException() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_GuiaRemisionHBN->getEstado() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEstadoDevolucion() ) )
        {
            $this->setEstadoDevolucion( $o_SR_GuiaRemisionHBN->getEstadoDevolucion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEstadoSunat() ) )
        {
            $this->setEstadoSunat( $o_SR_GuiaRemisionHBN->getEstadoSunat() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTipoDeComprobante() ) )
        {
            $this->setTipoDeComprobante( $o_SR_GuiaRemisionHBN->getTipoDeComprobante() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlace() ) )
        {
            $this->setEnlace( $o_SR_GuiaRemisionHBN->getEnlace() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getAceptadaPorSunat() ) )
        {
            $this->setAceptadaPorSunat( $o_SR_GuiaRemisionHBN->getAceptadaPorSunat() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatDescription() ) )
        {
            $this->setSunatDescription( $o_SR_GuiaRemisionHBN->getSunatDescription() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatNote() ) )
        {
            $this->setSunatNote( $o_SR_GuiaRemisionHBN->getSunatNote() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatResponsecode() ) )
        {
            $this->setSunatResponsecode( $o_SR_GuiaRemisionHBN->getSunatResponsecode() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatSoapError() ) )
        {
            $this->setSunatSoapError( $o_SR_GuiaRemisionHBN->getSunatSoapError() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getPdfZipBase64() ) )
        {
            $this->setPdfZipBase64( $o_SR_GuiaRemisionHBN->getPdfZipBase64() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getXmlZipBase64() ) )
        {
            $this->setXmlZipBase64( $o_SR_GuiaRemisionHBN->getXmlZipBase64() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getCdrZipBase64() ) )
        {
            $this->setCdrZipBase64( $o_SR_GuiaRemisionHBN->getCdrZipBase64() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlaceDelPdf() ) )
        {
            $this->setEnlaceDelPdf( $o_SR_GuiaRemisionHBN->getEnlaceDelPdf() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlaceDelXml() ) )
        {
            $this->setEnlaceDelXml( $o_SR_GuiaRemisionHBN->getEnlaceDelXml() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlaceDelCdr() ) )
        {
            $this->setEnlaceDelCdr( $o_SR_GuiaRemisionHBN->getEnlaceDelCdr() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getErrorsResponse() ) )
        {
            $this->setErrorsResponse( $o_SR_GuiaRemisionHBN->getErrorsResponse() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getErrorsCodigo() ) )
        {
            $this->setErrorsCodigo( $o_SR_GuiaRemisionHBN->getErrorsCodigo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getNotaImportante() ) )
        {
            $this->setNotaImportante( $o_SR_GuiaRemisionHBN->getNotaImportante() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDataJson() ) )
        {
            $this->setDataJson( $o_SR_GuiaRemisionHBN->getDataJson() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_GuiaRemisionHBN->getFechaRegistro() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_GuiaRemisionHBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_GuiaRemisionHBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_GuiaRemisionHBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
        $o_SR_GuiaRemisionHBN = $o_SR_GuiaRemisionHFN->selectByPk( $this->getGuiaRemisionId() );
        if ( is_null( $o_SR_GuiaRemisionHBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SR_GuiaRemisionH ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getGuiaRemisionId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."GuiaRemisionId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getGuiaRemisionId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoGuia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoGuia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipoGuia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getGuiaSerie() ) )
            {
                $s_SQLQuery1 .= $s_Separator."GuiaSerie";
                $s_SQLQuery2 .= $s_Separator."'".$this->getGuiaSerie()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getGuiaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."GuiaNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getGuiaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getGuiaFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."GuiaFecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getGuiaFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaIniTraslado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaIniTraslado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaIniTraslado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProyecto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProyecto";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdProyecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoComercialId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenTipoComercialId";
                $s_SQLQuery2 .= $s_Separator."".$this->getOrdenTipoComercialId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaParentId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaParentId";
                $s_SQLQuery2 .= $s_Separator."".$this->getReferenciaParentId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaParentNum() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaParentNum";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaParentNum()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaIdTipoDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaIdTipoDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumeroDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaNumeroDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaNumeroDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMovimientoDetId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoDetId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoDetId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaInicioAlq() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaInicioAlq";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaInicioAlq()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaFinAlq() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaFinAlq";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaFinAlq()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaTipoDoc() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EmpresaTipoDoc";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEmpresaTipoDoc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaNumDoc() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EmpresaNumDoc";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEmpresaNumDoc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaInfoAdicional() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EmpresaInfoAdicional";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEmpresaInfoAdicional()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaDireccion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EmpresaDireccion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEmpresaDireccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteNombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteTipoDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteTipoDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNumDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteNumDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteNumDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamentoOrigen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DepartamentoOrigen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDepartamentoOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvinciaOrigen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProvinciaOrigen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProvinciaOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistritoOrigen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DistritoOrigen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDistritoOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionOrigen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DireccionOrigen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDireccionOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeoOrigen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UbigeoOrigen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbigeoOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamentoDestino() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DepartamentoDestino";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDepartamentoDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvinciaDestino() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProvinciaDestino";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProvinciaDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistritoDestino() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DistritoDestino";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDistritoDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionDestino() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DireccionDestino";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDireccionDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeoDestino() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UbigeoDestino";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbigeoDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdVehiculo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdVehiculo";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdVehiculo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdChofer() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdChofer";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdChofer()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMotivoTrasladoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MotivoTrasladoId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMotivoTrasladoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModalidadTransporteId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ModalidadTransporteId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getModalidadTransporteId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPesoTotal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PesoTotal";
                $s_SQLQuery2 .= $s_Separator."".$this->getPesoTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroBultos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NumeroBultos";
                $s_SQLQuery2 .= $s_Separator."".$this->getNumeroBultos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorDocumentoTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ConductorDocumentoTipo";
                $s_SQLQuery2 .= $s_Separator."".$this->getConductorDocumentoTipo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorDocumentoNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ConductorDocumentoNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getConductorDocumentoNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorDenominacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ConductorDenominacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getConductorDenominacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ConductorNombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getConductorNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorApellido() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ConductorApellido";
                $s_SQLQuery2 .= $s_Separator."'".$this->getConductorApellido()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorNumeroLicencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ConductorNumeroLicencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getConductorNumeroLicencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaDocumentoTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TransportistaDocumentoTipo";
                $s_SQLQuery2 .= $s_Separator."".$this->getTransportistaDocumentoTipo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaDocumentoNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TransportistaDocumentoNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTransportistaDocumentoNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaDenominacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TransportistaDenominacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTransportistaDenominacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaPlacaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TransportistaPlacaNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTransportistaPlacaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdNumeroDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdNumeroDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdNumeroDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTransaccion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTransaccion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTransaccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMensajeException() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MensajeException";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMensajeException()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstadoDevolucion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EstadoDevolucion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstadoDevolucion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstadoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EstadoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstadoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoDeComprobante() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoDeComprobante";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipoDeComprobante()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlace() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Enlace";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEnlace()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAceptadaPorSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AceptadaPorSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAceptadaPorSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatDescription() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SunatDescription";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSunatDescription()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatNote() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SunatNote";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSunatNote()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatResponsecode() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SunatResponsecode";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSunatResponsecode()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatSoapError() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SunatSoapError";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSunatSoapError()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPdfZipBase64() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PdfZipBase64";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPdfZipBase64()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getXmlZipBase64() ) )
            {
                $s_SQLQuery1 .= $s_Separator."XmlZipBase64";
                $s_SQLQuery2 .= $s_Separator."'".$this->getXmlZipBase64()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCdrZipBase64() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CdrZipBase64";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCdrZipBase64()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlaceDelPdf() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EnlaceDelPdf";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEnlaceDelPdf()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlaceDelXml() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EnlaceDelXml";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEnlaceDelXml()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlaceDelCdr() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EnlaceDelCdr";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEnlaceDelCdr()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getErrorsResponse() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ErrorsResponse";
                $s_SQLQuery2 .= $s_Separator."'".$this->getErrorsResponse()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getErrorsCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ErrorsCodigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getErrorsCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotaImportante() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NotaImportante";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNotaImportante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDataJson() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DataJson";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDataJson()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SR_GuiaRemisionH SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoGuia() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoGuia = '".$this->getTipoGuia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getGuiaSerie() ) )
            {
                $s_SQLQuery .= $s_Separator."GuiaSerie = '".$this->getGuiaSerie()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getGuiaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."GuiaNumero = '".$this->getGuiaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getGuiaFecha() ) )
            {
                $s_SQLQuery .= $s_Separator."GuiaFecha = '".$this->getGuiaFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaIniTraslado() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaIniTraslado = '".$this->getFechaIniTraslado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProyecto() ) )
            {
                $s_SQLQuery .= $s_Separator."IdProyecto = ".$this->getIdProyecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenTipoComercialId() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenTipoComercialId = ".$this->getOrdenTipoComercialId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaParentId() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaParentId = ".$this->getReferenciaParentId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaParentNum() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaParentNum = '".$this->getReferenciaParentNum()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaIdTipoDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaIdTipoDocumento = '".$this->getReferenciaIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaTipo = '".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaNumero = '".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumeroDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery .= $s_Separator."MovimientoId = ".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMovimientoDetId() ) )
            {
                $s_SQLQuery .= $s_Separator."MovimientoDetId = ".$this->getMovimientoDetId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaInicioAlq() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaInicioAlq = '".$this->getFechaInicioAlq()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaFinAlq() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaFinAlq = '".$this->getFechaFinAlq()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaTipoDoc() ) )
            {
                $s_SQLQuery .= $s_Separator."EmpresaTipoDoc = '".$this->getEmpresaTipoDoc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaNumDoc() ) )
            {
                $s_SQLQuery .= $s_Separator."EmpresaNumDoc = '".$this->getEmpresaNumDoc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaInfoAdicional() ) )
            {
                $s_SQLQuery .= $s_Separator."EmpresaInfoAdicional = '".$this->getEmpresaInfoAdicional()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmpresaDireccion() ) )
            {
                $s_SQLQuery .= $s_Separator."EmpresaDireccion = '".$this->getEmpresaDireccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteNombre = '".$this->getClienteNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteTipoDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteTipoDocumento = '".$this->getClienteTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNumDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteNumDocumento = '".$this->getClienteNumDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamentoOrigen() ) )
            {
                $s_SQLQuery .= $s_Separator."DepartamentoOrigen = '".$this->getDepartamentoOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvinciaOrigen() ) )
            {
                $s_SQLQuery .= $s_Separator."ProvinciaOrigen = '".$this->getProvinciaOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistritoOrigen() ) )
            {
                $s_SQLQuery .= $s_Separator."DistritoOrigen = '".$this->getDistritoOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionOrigen() ) )
            {
                $s_SQLQuery .= $s_Separator."DireccionOrigen = '".$this->getDireccionOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeoOrigen() ) )
            {
                $s_SQLQuery .= $s_Separator."UbigeoOrigen = '".$this->getUbigeoOrigen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamentoDestino() ) )
            {
                $s_SQLQuery .= $s_Separator."DepartamentoDestino = '".$this->getDepartamentoDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvinciaDestino() ) )
            {
                $s_SQLQuery .= $s_Separator."ProvinciaDestino = '".$this->getProvinciaDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistritoDestino() ) )
            {
                $s_SQLQuery .= $s_Separator."DistritoDestino = '".$this->getDistritoDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionDestino() ) )
            {
                $s_SQLQuery .= $s_Separator."DireccionDestino = '".$this->getDireccionDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeoDestino() ) )
            {
                $s_SQLQuery .= $s_Separator."UbigeoDestino = '".$this->getUbigeoDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdVehiculo() ) )
            {
                $s_SQLQuery .= $s_Separator."IdVehiculo = ".$this->getIdVehiculo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdChofer() ) )
            {
                $s_SQLQuery .= $s_Separator."IdChofer = ".$this->getIdChofer()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMotivoTrasladoId() ) )
            {
                $s_SQLQuery .= $s_Separator."MotivoTrasladoId = '".$this->getMotivoTrasladoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModalidadTransporteId() ) )
            {
                $s_SQLQuery .= $s_Separator."ModalidadTransporteId = '".$this->getModalidadTransporteId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPesoTotal() ) )
            {
                $s_SQLQuery .= $s_Separator."PesoTotal = ".$this->getPesoTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroBultos() ) )
            {
                $s_SQLQuery .= $s_Separator."NumeroBultos = ".$this->getNumeroBultos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorDocumentoTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."ConductorDocumentoTipo = ".$this->getConductorDocumentoTipo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorDocumentoNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."ConductorDocumentoNumero = '".$this->getConductorDocumentoNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorDenominacion() ) )
            {
                $s_SQLQuery .= $s_Separator."ConductorDenominacion = '".$this->getConductorDenominacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."ConductorNombre = '".$this->getConductorNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorApellido() ) )
            {
                $s_SQLQuery .= $s_Separator."ConductorApellido = '".$this->getConductorApellido()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getConductorNumeroLicencia() ) )
            {
                $s_SQLQuery .= $s_Separator."ConductorNumeroLicencia = '".$this->getConductorNumeroLicencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaDocumentoTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."TransportistaDocumentoTipo = ".$this->getTransportistaDocumentoTipo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaDocumentoNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."TransportistaDocumentoNumero = '".$this->getTransportistaDocumentoNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaDenominacion() ) )
            {
                $s_SQLQuery .= $s_Separator."TransportistaDenominacion = '".$this->getTransportistaDenominacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransportistaPlacaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."TransportistaPlacaNumero = '".$this->getTransportistaPlacaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTipoDocumento = '".$this->getIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdNumeroDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."IdNumeroDocumento = '".$this->getIdNumeroDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTransaccion() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTransaccion = '".$this->getIdTransaccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMensajeException() ) )
            {
                $s_SQLQuery .= $s_Separator."MensajeException = '".$this->getMensajeException()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstadoDevolucion() ) )
            {
                $s_SQLQuery .= $s_Separator."EstadoDevolucion = '".$this->getEstadoDevolucion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstadoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."EstadoSunat = '".$this->getEstadoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoDeComprobante() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoDeComprobante = ".$this->getTipoDeComprobante()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlace() ) )
            {
                $s_SQLQuery .= $s_Separator."Enlace = '".$this->getEnlace()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAceptadaPorSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."AceptadaPorSunat = '".$this->getAceptadaPorSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatDescription() ) )
            {
                $s_SQLQuery .= $s_Separator."SunatDescription = '".$this->getSunatDescription()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatNote() ) )
            {
                $s_SQLQuery .= $s_Separator."SunatNote = '".$this->getSunatNote()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatResponsecode() ) )
            {
                $s_SQLQuery .= $s_Separator."SunatResponsecode = '".$this->getSunatResponsecode()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatSoapError() ) )
            {
                $s_SQLQuery .= $s_Separator."SunatSoapError = '".$this->getSunatSoapError()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPdfZipBase64() ) )
            {
                $s_SQLQuery .= $s_Separator."PdfZipBase64 = '".$this->getPdfZipBase64()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getXmlZipBase64() ) )
            {
                $s_SQLQuery .= $s_Separator."XmlZipBase64 = '".$this->getXmlZipBase64()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCdrZipBase64() ) )
            {
                $s_SQLQuery .= $s_Separator."CdrZipBase64 = '".$this->getCdrZipBase64()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlaceDelPdf() ) )
            {
                $s_SQLQuery .= $s_Separator."EnlaceDelPdf = '".$this->getEnlaceDelPdf()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlaceDelXml() ) )
            {
                $s_SQLQuery .= $s_Separator."EnlaceDelXml = '".$this->getEnlaceDelXml()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnlaceDelCdr() ) )
            {
                $s_SQLQuery .= $s_Separator."EnlaceDelCdr = '".$this->getEnlaceDelCdr()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getErrorsResponse() ) )
            {
                $s_SQLQuery .= $s_Separator."ErrorsResponse = '".$this->getErrorsResponse()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getErrorsCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."ErrorsCodigo = '".$this->getErrorsCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotaImportante() ) )
            {
                $s_SQLQuery .= $s_Separator."NotaImportante = '".$this->getNotaImportante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDataJson() ) )
            {
                $s_SQLQuery .= $s_Separator."DataJson = '".$this->getDataJson()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  GuiaRemisionId = '".$this->getGuiaRemisionId()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SR_GuiaRemisionH WHERE  GuiaRemisionId = '".$this->getGuiaRemisionId()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>