<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_UsuarioCompania.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Mantenimiento de los registros de la tabla SEG_UsuarioCompania */
abstract class BaseSEG_UsuarioCompaniaDP extends SEG_UsuarioCompaniaBV
{
    /* Constructor ( Establece los valores desde un objeto SEG_UsuarioCompaniaBN ) */
    public function __construct( SEG_UsuarioCompaniaBN $o_SEG_UsuarioCompaniaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SEG_UsuarioCompaniaBN ) )
        {
            $this->setByBN( $o_SEG_UsuarioCompaniaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SEG_UsuarioCompaniaBN */
    public function setByBN( SEG_UsuarioCompaniaBN $o_SEG_UsuarioCompaniaBN )
    {
        if ( !is_null( $o_SEG_UsuarioCompaniaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SEG_UsuarioCompaniaBN->getIdCompania() );
        }
        if ( !is_null( $o_SEG_UsuarioCompaniaBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_SEG_UsuarioCompaniaBN->getIdUsuario() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SEG_UsuarioCompaniaFN = new SEG_UsuarioCompaniaFN();
        $o_SEG_UsuarioCompaniaBN = $o_SEG_UsuarioCompaniaFN->selectByPk( $this->getIdCompania(), $this->getIdUsuario() );
        if ( is_null( $o_SEG_UsuarioCompaniaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SEG_UsuarioCompania ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUsuario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUsuario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdUsuario()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SEG_UsuarioCompania SET ";
            $s_Separator = "";
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdUsuario = '".$this->getIdUsuario()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SEG_UsuarioCompania WHERE  IdCompania = ".$this->getIdCompania()." AND  IdUsuario = '".$this->getIdUsuario()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>