<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_Grupo.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Mantenimiento de los registros de la tabla PR_Grupo */
abstract class BasePR_GrupoDP extends PR_GrupoBV
{
    /* Constructor ( Establece los valores desde un objeto PR_GrupoBN ) */
    public function __construct( PR_GrupoBN $o_PR_GrupoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PR_GrupoBN ) )
        {
            $this->setByBN( $o_PR_GrupoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PR_GrupoBN */
    public function setByBN( PR_GrupoBN $o_PR_GrupoBN )
    {
        if ( !is_null( $o_PR_GrupoBN->getIdPrGrupo() ) )
        {
            $this->setIdPrGrupo( $o_PR_GrupoBN->getIdPrGrupo() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_PR_GrupoBN->getIdCompania() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_PR_GrupoBN->getIdSucursal() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdPrTipoId() ) )
        {
            $this->setIdPrTipoId( $o_PR_GrupoBN->getIdPrTipoId() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaInicio() ) )
        {
            $this->setFechaInicio( $o_PR_GrupoBN->getFechaInicio() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaExpiracion() ) )
        {
            $this->setFechaExpiracion( $o_PR_GrupoBN->getFechaExpiracion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getDescripcionPromo() ) )
        {
            $this->setDescripcionPromo( $o_PR_GrupoBN->getDescripcionPromo() );
        }
        if ( !is_null( $o_PR_GrupoBN->getEstado() ) )
        {
            $this->setEstado( $o_PR_GrupoBN->getEstado() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_PR_GrupoBN->getIdLinea() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_PR_GrupoBN->getIdFamilia() );
        }
        if ( !is_null( $o_PR_GrupoBN->getValor() ) )
        {
            $this->setValor( $o_PR_GrupoBN->getValor() );
        }
        if ( !is_null( $o_PR_GrupoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PR_GrupoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PR_GrupoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PR_GrupoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PR_GrupoBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PR_GrupoFN = new PR_GrupoFN();
        $o_PR_GrupoBN = $o_PR_GrupoFN->selectByPk( $this->getIdPrGrupo() );
        if ( is_null( $o_PR_GrupoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PR_Grupo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdPrGrupo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPrGrupo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdPrGrupo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdPrTipoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPrTipoId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdPrTipoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaInicio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaInicio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaInicio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaExpiracion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaExpiracion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaExpiracion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionPromo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionPromo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionPromo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdLinea() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLinea";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdLinea()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFamilia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFamilia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdFamilia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Valor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getValor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PR_Grupo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdPrTipoId() ) )
            {
                $s_SQLQuery .= $s_Separator."IdPrTipoId = '".$this->getIdPrTipoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaInicio() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaInicio = '".$this->getFechaInicio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaExpiracion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaExpiracion = '".$this->getFechaExpiracion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionPromo() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionPromo = '".$this->getDescripcionPromo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdLinea() ) )
            {
                $s_SQLQuery .= $s_Separator."IdLinea = ".$this->getIdLinea()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFamilia() ) )
            {
                $s_SQLQuery .= $s_Separator."IdFamilia = ".$this->getIdFamilia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValor() ) )
            {
                $s_SQLQuery .= $s_Separator."Valor = '".$this->getValor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdPrGrupo = '".$this->getIdPrGrupo()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PR_Grupo WHERE  IdPrGrupo = '".$this->getIdPrGrupo()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>