<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_ServicioExterno.xml */
/* Generado: 2021-03-29 22:25:57 */

/* Mantenimiento de los registros de la tabla PRD_ServicioExterno */
abstract class BasePRD_ServicioExternoDP extends PRD_ServicioExternoBV
{
    /* Constructor ( Establece los valores desde un objeto PRD_ServicioExternoBN ) */
    public function __construct( PRD_ServicioExternoBN $o_PRD_ServicioExternoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PRD_ServicioExternoBN ) )
        {
            $this->setByBN( $o_PRD_ServicioExternoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PRD_ServicioExternoBN */
    public function setByBN( PRD_ServicioExternoBN $o_PRD_ServicioExternoBN )
    {
        if ( !is_null( $o_PRD_ServicioExternoBN->getIdServExt() ) )
        {
            $this->setIdServExt( $o_PRD_ServicioExternoBN->getIdServExt() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PRD_ServicioExternoBN->getDescripcion() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getEstado() ) )
        {
            $this->setEstado( $o_PRD_ServicioExternoBN->getEstado() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_PRD_ServicioExternoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_PRD_ServicioExternoBN->getFechaRegistro() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_ServicioExternoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_ServicioExternoBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PRD_ServicioExternoFN = new PRD_ServicioExternoFN();
        $o_PRD_ServicioExternoBN = $o_PRD_ServicioExternoFN->selectByPk( $this->getIdServExt() );
        if ( is_null( $o_PRD_ServicioExternoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PRD_ServicioExterno ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdServExt() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdServExt";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdServExt()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PRD_ServicioExterno SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdServExt = ".$this->getIdServExt().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PRD_ServicioExterno WHERE  IdServExt = ".$this->getIdServExt().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>