<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_MarcacionTipo.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Mantenimiento de los registros de la tabla PLA_MarcacionTipo */
abstract class BasePLA_MarcacionTipoDP extends PLA_MarcacionTipoBV
{
    /* Constructor ( Establece los valores desde un objeto PLA_MarcacionTipoBN ) */
    public function __construct( PLA_MarcacionTipoBN $o_PLA_MarcacionTipoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PLA_MarcacionTipoBN ) )
        {
            $this->setByBN( $o_PLA_MarcacionTipoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PLA_MarcacionTipoBN */
    public function setByBN( PLA_MarcacionTipoBN $o_PLA_MarcacionTipoBN )
    {
        if ( !is_null( $o_PLA_MarcacionTipoBN->getIdTipo() ) )
        {
            $this->setIdTipo( $o_PLA_MarcacionTipoBN->getIdTipo() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getIdRegistro() ) )
        {
            $this->setIdRegistro( $o_PLA_MarcacionTipoBN->getIdRegistro() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PLA_MarcacionTipoBN->getDescripcion() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_PLA_MarcacionTipoBN->getSecuencia() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getEstado() ) )
        {
            $this->setEstado( $o_PLA_MarcacionTipoBN->getEstado() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getTieneDescuentoFlag() ) )
        {
            $this->setTieneDescuentoFlag( $o_PLA_MarcacionTipoBN->getTieneDescuentoFlag() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getTieneDiaSiguienteFlag() ) )
        {
            $this->setTieneDiaSiguienteFlag( $o_PLA_MarcacionTipoBN->getTieneDiaSiguienteFlag() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PLA_MarcacionTipoFN = new PLA_MarcacionTipoFN();
        $o_PLA_MarcacionTipoBN = $o_PLA_MarcacionTipoFN->selectByPk( $this->getIdTipo(), $this->getIdRegistro() );
        if ( is_null( $o_PLA_MarcacionTipoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PLA_MarcacionTipo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Secuencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTieneDescuentoFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TieneDescuentoFlag";
                $s_SQLQuery2 .= $s_Separator."".$this->getTieneDescuentoFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTieneDiaSiguienteFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TieneDiaSiguienteFlag";
                $s_SQLQuery2 .= $s_Separator."".$this->getTieneDiaSiguienteFlag()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PLA_MarcacionTipo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery .= $s_Separator."Secuencia = ".$this->getSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTieneDescuentoFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."TieneDescuentoFlag = ".$this->getTieneDescuentoFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTieneDiaSiguienteFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."TieneDiaSiguienteFlag = ".$this->getTieneDiaSiguienteFlag()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTipo = '".$this->getIdTipo()."' AND  IdRegistro = '".$this->getIdRegistro()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PLA_MarcacionTipo WHERE  IdTipo = '".$this->getIdTipo()."' AND  IdRegistro = '".$this->getIdRegistro()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>