<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_EmpleadoCargo.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Mantenimiento de los registros de la tabla PLA_EmpleadoCargo */
abstract class BasePLA_EmpleadoCargoDP extends PLA_EmpleadoCargoBV
{
    /* Constructor ( Establece los valores desde un objeto PLA_EmpleadoCargoBN ) */
    public function __construct( PLA_EmpleadoCargoBN $o_PLA_EmpleadoCargoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PLA_EmpleadoCargoBN ) )
        {
            $this->setByBN( $o_PLA_EmpleadoCargoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PLA_EmpleadoCargoBN */
    public function setByBN( PLA_EmpleadoCargoBN $o_PLA_EmpleadoCargoBN )
    {
        if ( !is_null( $o_PLA_EmpleadoCargoBN->getIdCargo() ) )
        {
            $this->setIdCargo( $o_PLA_EmpleadoCargoBN->getIdCargo() );
        }
        if ( !is_null( $o_PLA_EmpleadoCargoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PLA_EmpleadoCargoBN->getDescripcion() );
        }
        if ( !is_null( $o_PLA_EmpleadoCargoBN->getEstado() ) )
        {
            $this->setEstado( $o_PLA_EmpleadoCargoBN->getEstado() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PLA_EmpleadoCargoFN = new PLA_EmpleadoCargoFN();
        $o_PLA_EmpleadoCargoBN = $o_PLA_EmpleadoCargoFN->selectByPk( $this->getIdCargo() );
        if ( is_null( $o_PLA_EmpleadoCargoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PLA_EmpleadoCargo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCargo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCargo";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCargo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PLA_EmpleadoCargo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCargo = ".$this->getIdCargo().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PLA_EmpleadoCargo WHERE  IdCargo = ".$this->getIdCargo().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>