<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ValidezOf.xml */
/* Generado: 2021-09-07 05:02:21 */

/* Mantenimiento de los registros de la tabla MST_ValidezOf */
abstract class BaseMST_ValidezOfDP extends MST_ValidezOfBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ValidezOfBN ) */
    public function __construct( MST_ValidezOfBN $o_MST_ValidezOfBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ValidezOfBN ) )
        {
            $this->setByBN( $o_MST_ValidezOfBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ValidezOfBN */
    public function setByBN( MST_ValidezOfBN $o_MST_ValidezOfBN )
    {
        if ( !is_null( $o_MST_ValidezOfBN->getValidezId() ) )
        {
            $this->setValidezId( $o_MST_ValidezOfBN->getValidezId() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ValidezOfBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getCantHoras() ) )
        {
            $this->setCantHoras( $o_MST_ValidezOfBN->getCantHoras() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ValidezOfBN->getEstado() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ValidezOfBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ValidezOfBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ValidezOfBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ValidezOfBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ValidezOfFN = new MST_ValidezOfFN();
        $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPk( $this->getValidezId() );
        if ( is_null( $o_MST_ValidezOfBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ValidezOf ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getValidezId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ValidezId";
                $s_SQLQuery2 .= $s_Separator."".$this->getValidezId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantHoras() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CantHoras";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantHoras()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ValidezOf SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantHoras() ) )
            {
                $s_SQLQuery .= $s_Separator."CantHoras = ".$this->getCantHoras()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  ValidezId = ".$this->getValidezId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ValidezOf WHERE  ValidezId = ".$this->getValidezId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>