<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Turno.xml */
/* Generado: 2021-11-09 06:44:44 */

/* Mantenimiento de los registros de la tabla MST_Turno */
abstract class BaseMST_TurnoDP extends MST_TurnoBV
{
    /* Constructor ( Establece los valores desde un objeto MST_TurnoBN ) */
    public function __construct( MST_TurnoBN $o_MST_TurnoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_TurnoBN ) )
        {
            $this->setByBN( $o_MST_TurnoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_TurnoBN */
    public function setByBN( MST_TurnoBN $o_MST_TurnoBN )
    {
        if ( !is_null( $o_MST_TurnoBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_MST_TurnoBN->getIdTurno() );
        }
        if ( !is_null( $o_MST_TurnoBN->getIdGrupoTurno() ) )
        {
            $this->setIdGrupoTurno( $o_MST_TurnoBN->getIdGrupoTurno() );
        }
        if ( !is_null( $o_MST_TurnoBN->getIdTipoTurno() ) )
        {
            $this->setIdTipoTurno( $o_MST_TurnoBN->getIdTipoTurno() );
        }
        if ( !is_null( $o_MST_TurnoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TurnoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getHoraInicio() ) )
        {
            $this->setHoraInicio( $o_MST_TurnoBN->getHoraInicio() );
        }
        if ( !is_null( $o_MST_TurnoBN->getHoraFinal() ) )
        {
            $this->setHoraFinal( $o_MST_TurnoBN->getHoraFinal() );
        }
        if ( !is_null( $o_MST_TurnoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TurnoBN->getEstado() );
        }
        if ( !is_null( $o_MST_TurnoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TurnoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TurnoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TurnoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TurnoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_TurnoFN = new MST_TurnoFN();
        $o_MST_TurnoBN = $o_MST_TurnoFN->selectByPk( $this->getIdTurno() );
        if ( is_null( $o_MST_TurnoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_Turno ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTurno";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdGrupoTurno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdGrupoTurno";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdGrupoTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoTurno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoTurno";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTipoTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getHoraInicio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."HoraInicio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getHoraInicio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getHoraFinal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."HoraFinal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getHoraFinal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_Turno SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdGrupoTurno() ) )
            {
                $s_SQLQuery .= $s_Separator."IdGrupoTurno = ".$this->getIdGrupoTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoTurno() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTipoTurno = ".$this->getIdTipoTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getHoraInicio() ) )
            {
                $s_SQLQuery .= $s_Separator."HoraInicio = '".$this->getHoraInicio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getHoraFinal() ) )
            {
                $s_SQLQuery .= $s_Separator."HoraFinal = '".$this->getHoraFinal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTurno = ".$this->getIdTurno().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_Turno WHERE  IdTurno = ".$this->getIdTurno().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>