<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoOperacionMast.xml */
/* Generado: 2020-08-18 04:21:28 */

/* Mantenimiento de los registros de la tabla MST_TipoOperacionMast */
abstract class BaseMST_TipoOperacionMastDP extends MST_TipoOperacionMastBV
{
    /* Constructor ( Establece los valores desde un objeto MST_TipoOperacionMastBN ) */
    public function __construct( MST_TipoOperacionMastBN $o_MST_TipoOperacionMastBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_TipoOperacionMastBN ) )
        {
            $this->setByBN( $o_MST_TipoOperacionMastBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_TipoOperacionMastBN */
    public function setByBN( MST_TipoOperacionMastBN $o_MST_TipoOperacionMastBN )
    {
        if ( !is_null( $o_MST_TipoOperacionMastBN->getIdOperacion() ) )
        {
            $this->setIdOperacion( $o_MST_TipoOperacionMastBN->getIdOperacion() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoOperacionMastBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TipoOperacionMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TipoOperacionMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TipoOperacionMastBN->getUsuarioCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_TipoOperacionMastFN = new MST_TipoOperacionMastFN();
        $o_MST_TipoOperacionMastBN = $o_MST_TipoOperacionMastFN->selectByPk( $this->getIdOperacion() );
        if ( is_null( $o_MST_TipoOperacionMastBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_TipoOperacionMast ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdOperacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdOperacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_TipoOperacionMast SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdOperacion = '".$this->getIdOperacion()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_TipoOperacionMast WHERE  IdOperacion = '".$this->getIdOperacion()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>