<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoNotaDebito.xml */
/* Generado: 2022-03-27 14:30:23 */

/* Mantenimiento de los registros de la tabla MST_TipoNotaDebito */
abstract class BaseMST_TipoNotaDebitoDP extends MST_TipoNotaDebitoBV
{
    /* Constructor ( Establece los valores desde un objeto MST_TipoNotaDebitoBN ) */
    public function __construct( MST_TipoNotaDebitoBN $o_MST_TipoNotaDebitoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_TipoNotaDebitoBN ) )
        {
            $this->setByBN( $o_MST_TipoNotaDebitoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_TipoNotaDebitoBN */
    public function setByBN( MST_TipoNotaDebitoBN $o_MST_TipoNotaDebitoBN )
    {
        if ( !is_null( $o_MST_TipoNotaDebitoBN->getId() ) )
        {
            $this->setId( $o_MST_TipoNotaDebitoBN->getId() );
        }
        if ( !is_null( $o_MST_TipoNotaDebitoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_MST_TipoNotaDebitoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_MST_TipoNotaDebitoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoNotaDebitoBN->getDescripcion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_TipoNotaDebitoFN = new MST_TipoNotaDebitoFN();
        $o_MST_TipoNotaDebitoBN = $o_MST_TipoNotaDebitoFN->selectByPk( $this->getId() );
        if ( is_null( $o_MST_TipoNotaDebitoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_TipoNotaDebito ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Id";
                $s_SQLQuery2 .= $s_Separator."".$this->getId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_TipoNotaDebito SET ";
            $s_Separator = "";
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  Id = ".$this->getId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_TipoNotaDebito WHERE  Id = ".$this->getId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>