<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoNotaCredito.xml */
/* Generado: 2022-03-27 14:30:18 */

/* Mantenimiento de los registros de la tabla MST_TipoNotaCredito */
abstract class BaseMST_TipoNotaCreditoDP extends MST_TipoNotaCreditoBV
{
    /* Constructor ( Establece los valores desde un objeto MST_TipoNotaCreditoBN ) */
    public function __construct( MST_TipoNotaCreditoBN $o_MST_TipoNotaCreditoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_TipoNotaCreditoBN ) )
        {
            $this->setByBN( $o_MST_TipoNotaCreditoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_TipoNotaCreditoBN */
    public function setByBN( MST_TipoNotaCreditoBN $o_MST_TipoNotaCreditoBN )
    {
        if ( !is_null( $o_MST_TipoNotaCreditoBN->getId() ) )
        {
            $this->setId( $o_MST_TipoNotaCreditoBN->getId() );
        }
        if ( !is_null( $o_MST_TipoNotaCreditoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_MST_TipoNotaCreditoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_MST_TipoNotaCreditoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoNotaCreditoBN->getDescripcion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_TipoNotaCreditoFN = new MST_TipoNotaCreditoFN();
        $o_MST_TipoNotaCreditoBN = $o_MST_TipoNotaCreditoFN->selectByPk( $this->getId() );
        if ( is_null( $o_MST_TipoNotaCreditoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_TipoNotaCredito ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Id";
                $s_SQLQuery2 .= $s_Separator."".$this->getId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_TipoNotaCredito SET ";
            $s_Separator = "";
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  Id = ".$this->getId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_TipoNotaCredito WHERE  Id = ".$this->getId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>