<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Talla.xml */
/* Generado: 2024-07-07 07:30:04 */

/* Mantenimiento de los registros de la tabla MST_Talla */
abstract class BaseMST_TallaDP extends MST_TallaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_TallaBN ) */
    public function __construct( MST_TallaBN $o_MST_TallaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_TallaBN ) )
        {
            $this->setByBN( $o_MST_TallaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_TallaBN */
    public function setByBN( MST_TallaBN $o_MST_TallaBN )
    {
        if ( !is_null( $o_MST_TallaBN->getIdTalla() ) )
        {
            $this->setIdTalla( $o_MST_TallaBN->getIdTalla() );
        }
        if ( !is_null( $o_MST_TallaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TallaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TallaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TallaBN->getEstado() );
        }
        if ( !is_null( $o_MST_TallaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TallaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TallaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TallaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TallaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TallaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_TallaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TallaBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_TallaFN = new MST_TallaFN();
        $o_MST_TallaBN = $o_MST_TallaFN->selectByPk( $this->getIdTalla() );
        if ( is_null( $o_MST_TallaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_Talla ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTalla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTalla";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTalla()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_Talla SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTalla = ".$this->getIdTalla().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_Talla WHERE  IdTalla = ".$this->getIdTalla().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>