<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProductoRelacion.xml */
/* Generado: 2024-07-14 05:40:10 */

/* Mantenimiento de los registros de la tabla MST_ReferenciaProductoRelacion */
abstract class BaseMST_ReferenciaProductoRelacionDP extends MST_ReferenciaProductoRelacionBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ReferenciaProductoRelacionBN ) */
    public function __construct( MST_ReferenciaProductoRelacionBN $o_MST_ReferenciaProductoRelacionBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN ) )
        {
            $this->setByBN( $o_MST_ReferenciaProductoRelacionBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ReferenciaProductoRelacionBN */
    public function setByBN( MST_ReferenciaProductoRelacionBN $o_MST_ReferenciaProductoRelacionBN )
    {
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_ReferenciaProductoRelacionBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ReferenciaProductoRelacionBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_ReferenciaProductoRelacionBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_ReferenciaProductoRelacionBN->getIdColor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_ReferenciaProductoRelacionBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getCantTrx() ) )
        {
            $this->setCantTrx( $o_MST_ReferenciaProductoRelacionBN->getCantTrx() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ReferenciaProductoRelacionFN = new MST_ReferenciaProductoRelacionFN();
        $o_MST_ReferenciaProductoRelacionBN = $o_MST_ReferenciaProductoRelacionFN->selectByPk( $this->getIdReferencia(), $this->getIdItem() );
        if ( is_null( $o_MST_ReferenciaProductoRelacionBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ReferenciaProductoRelacion ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdReferencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdReferencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdReferencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProveedor";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdColor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdColor";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdColor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCatTalla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCatTalla";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCatTalla()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantTrx() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CantTrx";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantTrx()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ReferenciaProductoRelacion SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery .= $s_Separator."IdProveedor = ".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdColor() ) )
            {
                $s_SQLQuery .= $s_Separator."IdColor = ".$this->getIdColor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCatTalla() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCatTalla = ".$this->getIdCatTalla()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantTrx() ) )
            {
                $s_SQLQuery .= $s_Separator."CantTrx = ".$this->getCantTrx()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdReferencia = ".$this->getIdReferencia()." AND  IdItem = '".$this->getIdItem()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ReferenciaProductoRelacion WHERE  IdReferencia = ".$this->getIdReferencia()." AND  IdItem = '".$this->getIdItem()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>