<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_PlazoEnt.xml */
/* Generado: 2021-09-07 05:02:28 */

/* Mantenimiento de los registros de la tabla MST_PlazoEnt */
abstract class BaseMST_PlazoEntDP extends MST_PlazoEntBV
{
    /* Constructor ( Establece los valores desde un objeto MST_PlazoEntBN ) */
    public function __construct( MST_PlazoEntBN $o_MST_PlazoEntBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_PlazoEntBN ) )
        {
            $this->setByBN( $o_MST_PlazoEntBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_PlazoEntBN */
    public function setByBN( MST_PlazoEntBN $o_MST_PlazoEntBN )
    {
        if ( !is_null( $o_MST_PlazoEntBN->getPlazoId() ) )
        {
            $this->setPlazoId( $o_MST_PlazoEntBN->getPlazoId() );
        }
        if ( !is_null( $o_MST_PlazoEntBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_PlazoEntBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_PlazoEntBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_PlazoEntBN->getEstado() );
        }
        if ( !is_null( $o_MST_PlazoEntBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_PlazoEntBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_PlazoEntBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_PlazoEntBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_PlazoEntBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_PlazoEntBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_PlazoEntBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_PlazoEntBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_PlazoEntFN = new MST_PlazoEntFN();
        $o_MST_PlazoEntBN = $o_MST_PlazoEntFN->selectByPk( $this->getPlazoId() );
        if ( is_null( $o_MST_PlazoEntBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_PlazoEnt ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getPlazoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PlazoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getPlazoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_PlazoEnt SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  PlazoId = ".$this->getPlazoId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_PlazoEnt WHERE  PlazoId = ".$this->getPlazoId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>