<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemUbicacion.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Mantenimiento de los registros de la tabla MST_ItemUbicacion */
abstract class BaseMST_ItemUbicacionDP extends MST_ItemUbicacionBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ItemUbicacionBN ) */
    public function __construct( MST_ItemUbicacionBN $o_MST_ItemUbicacionBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ItemUbicacionBN ) )
        {
            $this->setByBN( $o_MST_ItemUbicacionBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ItemUbicacionBN */
    public function setByBN( MST_ItemUbicacionBN $o_MST_ItemUbicacionBN )
    {
        if ( !is_null( $o_MST_ItemUbicacionBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ItemUbicacionBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ItemUbicacionBN->getIdCategoria() ) )
        {
            $this->setIdCategoria( $o_MST_ItemUbicacionBN->getIdCategoria() );
        }
        if ( !is_null( $o_MST_ItemUbicacionBN->getIdTipoUbicacion() ) )
        {
            $this->setIdTipoUbicacion( $o_MST_ItemUbicacionBN->getIdTipoUbicacion() );
        }
        if ( !is_null( $o_MST_ItemUbicacionBN->getHoraHabitacion() ) )
        {
            $this->setHoraHabitacion( $o_MST_ItemUbicacionBN->getHoraHabitacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ItemUbicacionFN = new MST_ItemUbicacionFN();
        $o_MST_ItemUbicacionBN = $o_MST_ItemUbicacionFN->selectByPk( $this->getIdItem() );
        if ( is_null( $o_MST_ItemUbicacionBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ItemUbicacion ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCategoria() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCategoria";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCategoria()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoUbicacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoUbicacion";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTipoUbicacion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getHoraHabitacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."HoraHabitacion";
                $s_SQLQuery2 .= $s_Separator."".$this->getHoraHabitacion()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ItemUbicacion SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCategoria() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCategoria = ".$this->getIdCategoria()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoUbicacion() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTipoUbicacion = ".$this->getIdTipoUbicacion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getHoraHabitacion() ) )
            {
                $s_SQLQuery .= $s_Separator."HoraHabitacion = ".$this->getHoraHabitacion()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdItem = '".$this->getIdItem()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ItemUbicacion WHERE  IdItem = '".$this->getIdItem()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>