<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemFiscal.xml */
/* Generado: 2021-02-26 17:56:59 */

/* Mantenimiento de los registros de la tabla MST_ItemFiscal */
abstract class BaseMST_ItemFiscalDP extends MST_ItemFiscalBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ItemFiscalBN ) */
    public function __construct( MST_ItemFiscalBN $o_MST_ItemFiscalBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ItemFiscalBN ) )
        {
            $this->setByBN( $o_MST_ItemFiscalBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ItemFiscalBN */
    public function setByBN( MST_ItemFiscalBN $o_MST_ItemFiscalBN )
    {
        if ( !is_null( $o_MST_ItemFiscalBN->getIdItemFiscal() ) )
        {
            $this->setIdItemFiscal( $o_MST_ItemFiscalBN->getIdItemFiscal() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ItemFiscalBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getCodigoFiscal() ) )
        {
            $this->setCodigoFiscal( $o_MST_ItemFiscalBN->getCodigoFiscal() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ItemFiscalBN->getEstado() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ItemFiscalBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ItemFiscalBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ItemFiscalBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ItemFiscalBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ItemFiscalFN = new MST_ItemFiscalFN();
        $o_MST_ItemFiscalBN = $o_MST_ItemFiscalFN->selectByPk( $this->getIdItemFiscal() );
        if ( is_null( $o_MST_ItemFiscalBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ItemFiscal ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdItemFiscal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItemFiscal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdItemFiscal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoFiscal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoFiscal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoFiscal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ItemFiscal SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoFiscal() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoFiscal = '".$this->getCodigoFiscal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdItemFiscal = ".$this->getIdItemFiscal().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ItemFiscal WHERE  IdItemFiscal = ".$this->getIdItemFiscal().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>