<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemDiaSemana.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Mantenimiento de los registros de la tabla MST_ItemDiaSemana */
abstract class BaseMST_ItemDiaSemanaDP extends MST_ItemDiaSemanaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ItemDiaSemanaBN ) */
    public function __construct( MST_ItemDiaSemanaBN $o_MST_ItemDiaSemanaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ItemDiaSemanaBN ) )
        {
            $this->setByBN( $o_MST_ItemDiaSemanaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ItemDiaSemanaBN */
    public function setByBN( MST_ItemDiaSemanaBN $o_MST_ItemDiaSemanaBN )
    {
        if ( !is_null( $o_MST_ItemDiaSemanaBN->getIdDiaSem() ) )
        {
            $this->setIdDiaSem( $o_MST_ItemDiaSemanaBN->getIdDiaSem() );
        }
        if ( !is_null( $o_MST_ItemDiaSemanaBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ItemDiaSemanaBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ItemDiaSemanaBN->getDiaNumero() ) )
        {
            $this->setDiaNumero( $o_MST_ItemDiaSemanaBN->getDiaNumero() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ItemDiaSemanaFN = new MST_ItemDiaSemanaFN();
        $o_MST_ItemDiaSemanaBN = $o_MST_ItemDiaSemanaFN->selectByPk( $this->getIdDiaSem(), $this->getIdItem() );
        if ( is_null( $o_MST_ItemDiaSemanaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ItemDiaSemana ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdDiaSem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdDiaSem";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdDiaSem()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDiaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DiaNumero";
                $s_SQLQuery2 .= $s_Separator."".$this->getDiaNumero()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ItemDiaSemana SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDiaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."DiaNumero = ".$this->getDiaNumero()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdDiaSem = ".$this->getIdDiaSem()." AND  IdItem = '".$this->getIdItem()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ItemDiaSemana WHERE  IdDiaSem = ".$this->getIdDiaSem()." AND  IdItem = '".$this->getIdItem()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>