<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CategoriaTallaRelacion.xml */
/* Generado: 2024-07-07 08:03:57 */

/* Mantenimiento de los registros de la tabla MST_CategoriaTallaRelacion */
abstract class BaseMST_CategoriaTallaRelacionDP extends MST_CategoriaTallaRelacionBV
{
    /* Constructor ( Establece los valores desde un objeto MST_CategoriaTallaRelacionBN ) */
    public function __construct( MST_CategoriaTallaRelacionBN $o_MST_CategoriaTallaRelacionBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_CategoriaTallaRelacionBN ) )
        {
            $this->setByBN( $o_MST_CategoriaTallaRelacionBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_CategoriaTallaRelacionBN */
    public function setByBN( MST_CategoriaTallaRelacionBN $o_MST_CategoriaTallaRelacionBN )
    {
        if ( !is_null( $o_MST_CategoriaTallaRelacionBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_CategoriaTallaRelacionBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_CategoriaTallaRelacionBN->getIdTalla() ) )
        {
            $this->setIdTalla( $o_MST_CategoriaTallaRelacionBN->getIdTalla() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_CategoriaTallaRelacionFN = new MST_CategoriaTallaRelacionFN();
        $o_MST_CategoriaTallaRelacionBN = $o_MST_CategoriaTallaRelacionFN->selectByPk( $this->getIdCatTalla(), $this->getIdTalla() );
        if ( is_null( $o_MST_CategoriaTallaRelacionBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_CategoriaTallaRelacion ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCatTalla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCatTalla";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCatTalla()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTalla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTalla";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTalla()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_CategoriaTallaRelacion SET ";
            $s_Separator = "";
            $s_SQLQuery .= " WHERE  IdCatTalla = ".$this->getIdCatTalla()." AND  IdTalla = ".$this->getIdTalla().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_CategoriaTallaRelacion WHERE  IdCatTalla = ".$this->getIdCatTalla()." AND  IdTalla = ".$this->getIdTalla().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>