<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Cartera.xml */
/* Generado: 2024-10-18 17:06:00 */

/* Mantenimiento de los registros de la tabla MST_Cartera */
abstract class BaseMST_CarteraDP extends MST_CarteraBV
{
    /* Constructor ( Establece los valores desde un objeto MST_CarteraBN ) */
    public function __construct( MST_CarteraBN $o_MST_CarteraBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_CarteraBN ) )
        {
            $this->setByBN( $o_MST_CarteraBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_CarteraBN */
    public function setByBN( MST_CarteraBN $o_MST_CarteraBN )
    {
        if ( !is_null( $o_MST_CarteraBN->getIdCartera() ) )
        {
            $this->setIdCartera( $o_MST_CarteraBN->getIdCartera() );
        }
        if ( !is_null( $o_MST_CarteraBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_CarteraBN->getNombre() );
        }
        if ( !is_null( $o_MST_CarteraBN->getFlagRango() ) )
        {
            $this->setFlagRango( $o_MST_CarteraBN->getFlagRango() );
        }
        if ( !is_null( $o_MST_CarteraBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_CarteraBN->getEstado() );
        }
        if ( !is_null( $o_MST_CarteraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_CarteraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_CarteraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_CarteraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_CarteraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_CarteraBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_CarteraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_CarteraBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_CarteraFN = new MST_CarteraFN();
        $o_MST_CarteraBN = $o_MST_CarteraFN->selectByPk( $this->getIdCartera() );
        if ( is_null( $o_MST_CarteraBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_Cartera ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCartera() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCartera";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCartera()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagRango() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlagRango";
                $s_SQLQuery2 .= $s_Separator."".$this->getFlagRango()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_Cartera SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagRango() ) )
            {
                $s_SQLQuery .= $s_Separator."FlagRango = ".$this->getFlagRango()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCartera = ".$this->getIdCartera().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_Cartera WHERE  IdCartera = ".$this->getIdCartera().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>