<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Aduana.xml */
/* Generado: 2021-08-07 04:50:42 */

/* Mantenimiento de los registros de la tabla MST_Aduana */
abstract class BaseMST_AduanaDP extends MST_AduanaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_AduanaBN ) */
    public function __construct( MST_AduanaBN $o_MST_AduanaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_AduanaBN ) )
        {
            $this->setByBN( $o_MST_AduanaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_AduanaBN */
    public function setByBN( MST_AduanaBN $o_MST_AduanaBN )
    {
        if ( !is_null( $o_MST_AduanaBN->getId() ) )
        {
            $this->setId( $o_MST_AduanaBN->getId() );
        }
        if ( !is_null( $o_MST_AduanaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_AduanaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_AduanaBN->getIdUbigeo() ) )
        {
            $this->setIdUbigeo( $o_MST_AduanaBN->getIdUbigeo() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_AduanaFN = new MST_AduanaFN();
        $o_MST_AduanaBN = $o_MST_AduanaFN->selectByPk( $this->getId() );
        if ( is_null( $o_MST_AduanaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_Aduana ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Id";
                $s_SQLQuery2 .= $s_Separator."'".$this->getId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUbigeo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUbigeo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdUbigeo()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_Aduana SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUbigeo() ) )
            {
                $s_SQLQuery .= $s_Separator."IdUbigeo = '".$this->getIdUbigeo()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  Id = '".$this->getId()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_Aduana WHERE  Id = '".$this->getId()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>