<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_UsuarioSucuDocumento.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_UsuarioSucuDocumento */
abstract class BaseGSS_UsuarioSucuDocumentoDP extends GSS_UsuarioSucuDocumentoBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_UsuarioSucuDocumentoBN ) */
    public function __construct( GSS_UsuarioSucuDocumentoBN $o_GSS_UsuarioSucuDocumentoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN ) )
        {
            $this->setByBN( $o_GSS_UsuarioSucuDocumentoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_UsuarioSucuDocumentoBN */
    public function setByBN( GSS_UsuarioSucuDocumentoBN $o_GSS_UsuarioSucuDocumentoBN )
    {
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdSucuDoc() ) )
        {
            $this->setIdSucuDoc( $o_GSS_UsuarioSucuDocumentoBN->getIdSucuDoc() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_GSS_UsuarioSucuDocumentoBN->getIdUsuario() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_UsuarioSucuDocumentoBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() ) )
        {
            $this->setIdSucursalDocumento( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getSerieDocumento() ) )
        {
            $this->setSerieDocumento( $o_GSS_UsuarioSucuDocumentoBN->getSerieDocumento() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
        $o_GSS_UsuarioSucuDocumentoBN = $o_GSS_UsuarioSucuDocumentoFN->selectByPk( $this->getIdSucuDoc() );
        if ( is_null( $o_GSS_UsuarioSucuDocumentoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_UsuarioSucuDocumento ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdSucuDoc() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucuDoc";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucuDoc()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUsuario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUsuario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdUsuario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursalDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursalDocumento";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursalDocumento()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSerieDocumento()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_UsuarioSucuDocumento SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdUsuario() ) )
            {
                $s_SQLQuery .= $s_Separator."IdUsuario = '".$this->getIdUsuario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTipoDocumento = '".$this->getIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursalDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursalDocumento = ".$this->getIdSucursalDocumento()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."SerieDocumento = '".$this->getSerieDocumento()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdSucuDoc = ".$this->getIdSucuDoc().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_UsuarioSucuDocumento WHERE  IdSucuDoc = ".$this->getIdSucuDoc().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>