<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Ticketera.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_Ticketera */
abstract class BaseGSS_TicketeraDP extends GSS_TicketeraBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_TicketeraBN ) */
    public function __construct( GSS_TicketeraBN $o_GSS_TicketeraBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_TicketeraBN ) )
        {
            $this->setByBN( $o_GSS_TicketeraBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_TicketeraBN */
    public function setByBN( GSS_TicketeraBN $o_GSS_TicketeraBN )
    {
        if ( !is_null( $o_GSS_TicketeraBN->getIdTicketera() ) )
        {
            $this->setIdTicketera( $o_GSS_TicketeraBN->getIdTicketera() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_GSS_TicketeraBN->getIdSucursal() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getAutorizacionSunat() ) )
        {
            $this->setAutorizacionSunat( $o_GSS_TicketeraBN->getAutorizacionSunat() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getSerieTicket() ) )
        {
            $this->setSerieTicket( $o_GSS_TicketeraBN->getSerieTicket() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_TicketeraBN->getEstado() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_TicketeraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_TicketeraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_TicketeraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_TicketeraBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_TicketeraFN = new GSS_TicketeraFN();
        $o_GSS_TicketeraBN = $o_GSS_TicketeraFN->selectByPk( $this->getIdTicketera() );
        if ( is_null( $o_GSS_TicketeraBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_Ticketera ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTicketera() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTicketera";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTicketera()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAutorizacionSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AutorizacionSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAutorizacionSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieTicket() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieTicket";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSerieTicket()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_Ticketera SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAutorizacionSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."AutorizacionSunat = '".$this->getAutorizacionSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieTicket() ) )
            {
                $s_SQLQuery .= $s_Separator."SerieTicket = '".$this->getSerieTicket()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTicketera = ".$this->getIdTicketera().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_Ticketera WHERE  IdTicketera = ".$this->getIdTicketera().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>