<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_ParametroMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_ParametroMast */
abstract class BaseGSS_ParametroMastDP extends GSS_ParametroMastBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_ParametroMastBN ) */
    public function __construct( GSS_ParametroMastBN $o_GSS_ParametroMastBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_ParametroMastBN ) )
        {
            $this->setByBN( $o_GSS_ParametroMastBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_ParametroMastBN */
    public function setByBN( GSS_ParametroMastBN $o_GSS_ParametroMastBN )
    {
        if ( !is_null( $o_GSS_ParametroMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_ParametroMastBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getIdAplicacionCodigo() ) )
        {
            $this->setIdAplicacionCodigo( $o_GSS_ParametroMastBN->getIdAplicacionCodigo() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getIdParametroClave() ) )
        {
            $this->setIdParametroClave( $o_GSS_ParametroMastBN->getIdParametroClave() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getDescripcionParametro() ) )
        {
            $this->setDescripcionParametro( $o_GSS_ParametroMastBN->getDescripcionParametro() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getExplicacion() ) )
        {
            $this->setExplicacion( $o_GSS_ParametroMastBN->getExplicacion() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getTipodeDatoFlag() ) )
        {
            $this->setTipodeDatoFlag( $o_GSS_ParametroMastBN->getTipodeDatoFlag() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getTexto() ) )
        {
            $this->setTexto( $o_GSS_ParametroMastBN->getTexto() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getNumero() ) )
        {
            $this->setNumero( $o_GSS_ParametroMastBN->getNumero() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getFecha() ) )
        {
            $this->setFecha( $o_GSS_ParametroMastBN->getFecha() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_ParametroMastBN->getEstado() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_ParametroMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_ParametroMastBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPk( $this->getIdCompania(), $this->getIdAplicacionCodigo(), $this->getIdParametroClave() );
        if ( is_null( $o_GSS_ParametroMastBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_ParametroMast ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAplicacionCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAplicacionCodigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAplicacionCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdParametroClave() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdParametroClave";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdParametroClave()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionParametro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionParametro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionParametro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getExplicacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Explicacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getExplicacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipodeDatoFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipodeDatoFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipodeDatoFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTexto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Texto";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTexto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Numero";
                $s_SQLQuery2 .= $s_Separator."".$this->getNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Fecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_ParametroMast SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcionParametro() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionParametro = '".$this->getDescripcionParametro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getExplicacion() ) )
            {
                $s_SQLQuery .= $s_Separator."Explicacion = '".$this->getExplicacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipodeDatoFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."TipodeDatoFlag = '".$this->getTipodeDatoFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTexto() ) )
            {
                $s_SQLQuery .= $s_Separator."Texto = '".$this->getTexto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."Numero = ".$this->getNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery .= $s_Separator."Fecha = '".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdAplicacionCodigo = '".$this->getIdAplicacionCodigo()."' AND  IdParametroClave = '".$this->getIdParametroClave()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_ParametroMast WHERE  IdCompania = ".$this->getIdCompania()." AND  IdAplicacionCodigo = '".$this->getIdAplicacionCodigo()."' AND  IdParametroClave = '".$this->getIdParametroClave()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>